package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.util.ArrayList;

/**
 * ̃wb_̃f[^Ǘ܂.
 * 
 * @author Asan
 */
public class JSpreadHeader implements JSpreadConstant {
	final JSpread spread;
	/** . VERTICAL/HORIZONTAL̂ꂩ */
	final int orientation;
	/** (dot) 0ȏ */
	int thickness;
	int defaultWidth;
	/** ȅ. ArrayList<HeaderInfo> */
	ArrayList infos = new ArrayList();
	/**
	 * e[ũTCYύXĊeŃe[uŜ߂悤ɂ邩
	 * ǂw肵ÃTCYύX̕@w肵܂B
	 * ftHg<code> AUTO_RESIZE_OFF </code>łB
	 */
	int autoResizeMode;
	/** wb_̕TCYĂƂindex.TCYĂȂƂ́A-1 */
//	int resizingViewIndex;
	transient int[] dataIndexList;
	
	JSpreadHeader(JSpread spread, int orientation, int count, int thickness, int defaultWidth) {
		assert spread != null;
		assert orientation == JSpread.VERTICAL || orientation == JSpread.HORIZONTAL: orientation;
		assert count >= 0: count;
		assert thickness >= 0: thickness;
		assert defaultWidth >= 0: defaultWidth;
		this.spread = spread;
		this.orientation = orientation;
		this.thickness = thickness;
		this.defaultWidth = defaultWidth;
		this.autoResizeMode = JSpread.AUTO_RESIZE_OFF;
//		this.resizingViewIndex = -1;
		for (int i=0; i<count; i++) {
			infos.add(new HeaderInfo(null, defaultWidth, i));
		}
		makeDataIndexList();
	}
	/**
	 * wb_擾. 
	 * @param dataIndex	
	@* @return	wb_
	 */
	HeaderInfo getInfo(int dataIndex) {
		assert 0 <= dataIndex && dataIndex < infos.size(): dataIndex;
		return (HeaderInfo) infos.get(dataIndex);
	}
	/**
	 * wb_̕(dot)߂.
	 * @param dataIndex	f[^indexB0..
	 * @return	wb_̕(dot)
	 */
	public int getWidth(int dataIndex) {
		assert 0 <= dataIndex && dataIndex < infos.size(): dataIndex;
		return getInfo(dataIndex).width;
	}
	public void setWidth(int dataIndex, int width) {
		assert 0 <= dataIndex && dataIndex < infos.size(): dataIndex;
		getInfo(dataIndex).setWidth(width);
	}
	int getMinWidth(int dataIndex) {
		assert 0 <= dataIndex && dataIndex < infos.size(): dataIndex;
		return getInfo(dataIndex).minWidth;
	}
	int getMaxWidth(int dataIndex) {
		assert 0 <= dataIndex && dataIndex < infos.size(): dataIndex;
		return getInfo(dataIndex).maxWidth;
	}
	int getPreferredWidth(int dataIndex) {
		assert 0 <= dataIndex && dataIndex < infos.size(): dataIndex;
		return getInfo(dataIndex).preferredWidth;
	}
	public void setPreferredWidth(int dataIndex, int width) {
		assert 0 <= dataIndex && dataIndex < infos.size(): dataIndex;
		getInfo(dataIndex).setPreferredWidth(width);
	}
	
	Object getValueAt(int dataIndex) {
		assert 0 <= dataIndex && dataIndex < infos.size(): dataIndex;
		return getInfo(dataIndex).value;
	}
	public void setValueAt(int dataIndex, Object value) {
		assert 0 <= dataIndex && dataIndex < infos.size(): dataIndex;
		getInfo(dataIndex).value = value;
	}
	public int getCount() {
		return infos.size();
	}
	/**
	 * Z̍̍W(dot)ԂB
	 * @param	viewIndex	\ʒu(viewIndex)
	 * @return	Z̍̍W(dot)
	 */
	int getPoint(int viewIndex) {
		int viewCount = getViewCount();
		assert 0 <= viewIndex && viewIndex <= viewCount: viewIndex;
		Color gridColor = (orientation == JSpread.HORIZONTAL) ? 
				spread.properties.getColor(JSpread.HORIZONTAL_GRID_COLOR) :
				spread.properties.getColor(JSpread.VERTICAL_GRID_COLOR);
		int space = (gridColor != null ? 1 : 0);
		int pos = 0;
		for (int i=0; i<viewIndex; i++) {
			int index = getDataIndex(i);
			pos += getWidth(index) + space;
		}
		return pos;
	}

	/**
	 * Z̉E̍W(dot)ԂBstartZ̑΍W
	 *  @param	viewIndex	\ʒu(viewIndex)
	 *  @return	Z̉E̍W(dot)
	 */
	int getTailPoint(int viewIndex) {
		int index = getDataIndex(viewIndex);
		return getPoint(viewIndex) + getWidth(index);
	}
	/**
	 * w肵WAǂ̃ZɈʒu邩ԂB
	 * @param x
	 * @return	\index. Z͈̔͊ÔƂɂ́A(-1)ԂB
	 */
	int getViewPositionAtPoint(int x) {
		if (x < 0) return -1;
		int p = 0;
		Color gridColor = (orientation == JSpread.HORIZONTAL) ? 
				spread.properties.getColor(JSpread.HORIZONTAL_GRID_COLOR) :
				spread.properties.getColor(JSpread.VERTICAL_GRID_COLOR);
		int space = (gridColor != null ? 1 : 0);
		int viewCount = getViewCount();
		for (int i=0; i<viewCount; i++) {
			int index = getDataIndex(i);
			p += getWidth(index) + space;
			if (x < p) {
				return i;
			}
		}
		return -1;
	}
	int getTotalWidth() {
		return getPoint(getViewCount());
	}
	/**
	 * \ʒu(viewIndex)f[^ʒu(dataIndex)o߂̑Ή\.
	 */
	void makeDataIndexList() {
		dataIndexList = new int[getViewCount()];
		for (int i=0; i<infos.size(); i++) {
			if (getInfo(i).viewPosition != -1) { 
				dataIndexList[getInfo(i).viewPosition] = i;
			}
		}
	}
	/** \s/̐Ԃ. */
	public int getViewCount() {
		int viewCount = 0;
		for (int i=0; i<infos.size(); i++) {
			if (getInfo(i).viewPosition != -1) viewCount++;
		}
		return viewCount;
	}
	/**
	 * \ʒu(viewIndex)f[^̃CfbNX߂.
	 * @param	viewIndex	\ʒu(0..)
	 * @return	f[^̃CfbNX
	 */
	int getDataIndex(int viewIndex) {
		assert 0 <= viewIndex && viewIndex < dataIndexList.length: viewIndex;
		return dataIndexList[viewIndex];
	}
	public int getAutoResizeMode() {
		return autoResizeMode;
	}
	public void setAutoResizeMode(int mode) {
		assert 	mode == AUTO_RESIZE_OFF ||
				mode == AUTO_RESIZE_NEXT_COLUMN ||
				mode == AUTO_RESIZE_LAST_COLUMN:
				mode;
		this.autoResizeMode = mode;
	}
	
	/** wb_. */
	static class HeaderInfo {
		/** wb_̒l. null */
		Object value;
		/** \(dot). minWidth <= width <= maxWidth */
		int width;
		/** ŏ(dot).0ȏ. ftHg15. */
		int minWidth;
		/** ő啝(dot) 0ȏ ftHgInteger.MAX_VALUE*/
		int maxWidth;
		/** œKȕ(dot).0ȏ. (minWidht <= preferredWidth <= maxWidth)藧 */
		int preferredWidth;
		/** \ʒu(viewIndex). -1̂Ƃ͕\Ȃ */
		int viewPosition;
		/**
		 * wb_쐬܂B
		 * @param value		wb_̒l(null)
		 * @param width		wb_̕\(dot)(0ȏ)
		 * @param viewPosition	wb_̕\ʒu(viewIndex). -1̂Ƃ͕\Ȃ
		 */
		HeaderInfo(Object value, int width, int viewPosition) {
			this.value = value;
			this.minWidth = 15;
			this.maxWidth = Integer.MAX_VALUE;
			this.width = Math.max(minWidth, Math.min(width, maxWidth));
			this.preferredWidth = width;
			this.viewPosition = viewPosition;
		}
		void setWidth(int newWidth) {
//			this.width = Math.max(minWidth, Math.min(newWidth, maxWidth));
			width = newWidth;
		}
		void setPreferredWidth(int newWidth) {
			//this.preferredWidth = Math.max(minWidth, Math.min(newWidth, maxWidth));
			this.preferredWidth = newWidth;
		}
		void setMinWidth(int newWidth) {
			assert newWidth <= maxWidth: newWidth;
//			this.minWidth = Math.max(0, newWidth);
//			if (width < minWidth) width = minWidth;
//			if (preferredWidth < minWidth) preferredWidth = minWidth;
			this.minWidth = newWidth;

		}
		void setMaxWidth(int newWidth) {
			assert minWidth <= newWidth:  newWidth;
//			this.maxWidth = newWidth;
//			if (maxWidth < width) width = maxWidth;
//			if (maxWidth < preferredWidth) preferredWidth = maxWidth;
			this.maxWidth = newWidth;
		}
	}
}
