/*
 * 쐬: 2007/02/11
 */
package net.sourceforge.swingx.jspread;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpreadHeader.HeaderInfo;

/**
 * wb_̕}EXɂĕύX.
 * ́AJSpreadHeaderListenerϏČĂ΂B
 * @author Asan
 */
public class JSpreadHeaderResizeListener {
	private static Logger logger = Logger.getLogger(JSpreadHeaderResizeListener.class);

	final JSpreadHeaderPane pane;
	final JSpread spread;
	int resizingViewIndex;
	
	JSpreadHeaderResizeListener(JSpread spread, JSpreadHeaderPane pane) {
		assert spread != null;
		assert pane != null;		
		this.spread = spread;
		this.pane = pane;
	}
	
	void mousePressed(MouseEvent e) {
		switch (pane.orientation) {
		case JSpread.COLUMN:
			resizingViewIndex = getResizePosition(spread.sheet.colHeader, e.getX());
			break;
		case JSpread.ROW:
			resizingViewIndex = getResizePosition(spread.sheet.rowHeader, e.getY());
			break;
		default:
			assert false: pane.orientation;
		}
	}
	/** R|[lgŃ}EX̃{^ăhbOƌĂяo܂B */
	public void mouseDragged(MouseEvent e) {
		logger.debug(e);
		if (e.isConsumed()) return;
//		JSpreadSheet sheet = spread.getSheet();

//		int new_w;
//		switch (pane.orientation) {
//		case JSpread.ROW:
//			int startRow = 0;
//			new_w = e.getY() - 
//				(sheet.rowHeader.getPoint(resizingViewIndex) - sheet.rowHeader.getPoint(startRow));
//			if (new_w < 0) break;
//			changeWidth(sheet.rowHeader, resizingViewIndex, new_w);
//			spread.Ĕzu();
//			pane.repaint();
//			break;
//		case JSpread.COLUMN:
//			int startCol = 0;
//			new_w = e.getX() - 
//				(sheet.colHeader.getPoint(resizingViewIndex) - sheet.colHeader.getPoint(startCol));
//			if (new_w < 0) break;
//			changeWidth(sheet.colHeader, resizingViewIndex, new_w);
//			spread.Ĕzu();
//			pane.repaint();
//			break;
//		default:	
//			assert false;
//		}
	}
	// TODO:AUTO_RESIZE_NEXT_COLUMN, ...ȂǂɑΉ邱
	private void changeWidth(JSpreadHeader header, int pos, int new_width) {
		int index;
		switch (header.autoResizeMode) {
		case JSpread.AUTO_RESIZE_OFF:
			index = header.getDataIndex(pos);
			header.getInfo(index).setWidth(new_width);
			break;
		case JSpread.AUTO_RESIZE_NEXT_COLUMN:
			if (pos == header.getViewCount()-1) break;
			index = header.getDataIndex(pos);
			header.getInfo(index).setWidth(new_width);
			break;
		case JSpread.AUTO_RESIZE_LAST_COLUMN:
			break;
		default:
			assert false: header.autoResizeMode;
		}
	}
	
	public void mouseReleased(MouseEvent e) {
		if (e.isConsumed()) return;
		JSpreadSheet sheet = spread.getSheet();

		// V߂
		int new_w = (pane.orientation == JSpread.ROW) ?
					e.getY() - sheet.rowHeader.getPoint(resizingViewIndex):
					e.getX() - sheet.colHeader.getPoint(resizingViewIndex);

		if (new_w < 0) return;
		System.out.println("new_w="+new_w+" resizingViewIndex="+resizingViewIndex);
		// ATCY/sIĂꍇȂI/sɂB
		if (spread.getHeaderSelection(pane.orientation, resizingViewIndex)) {
			int[] viewIndexList = spread.getHeaderSelections(pane.orientation);
			int[] newWidthList = new int[viewIndexList.length];
			for (int i=0; i<viewIndexList.length; i++) {
				newWidthList[i] = new_w;
			}
			requestResize(viewIndexList, newWidthList);
		}
		else {
			requestResize(new int[]{resizingViewIndex}, new int[]{new_w});
		}
		spread.Ĕzu();
		e.consume();
	}

    /** R|[lgŃ}EX{^NbN (Ă痣) ƂɌĂяo܂B*/ 
	public void mouseClicked(MouseEvent e) {
		if (e.isConsumed()) return;
		// {^Ń_uNbNƂAwb_̕œKȕɂB
		JSpreadSheet sheet = spread.getSheet();
		if (e.getClickCount() == 2 && e.getButton()==MouseEvent.BUTTON1) {
			logger.debug(e);
			
			switch (pane.orientation) {
			case JSpread.ROW:
				if (! sheet.allowAutoRowHeaderResize) return;
				int pos = getResizePosition(sheet.rowHeader, e.getY());
				if (pos == -1) break;	// EłȂꍇ͉Ȃ
				int rowDataIndex = sheet.rowHeader.getDataIndex(pos);
				// \Ă邻ׂ̗̂ẴZɂāAœKȃTCY߂
				int width = spread.headerController.getPreferredWidth(pane.orientation, rowDataIndex);
				// ̍sIĂAIĂ邷ׂĂ̍s̕ςB
				if (sheet.getHeaderSelection(pane.orientation, pos)) {
					// IĂ邷ׂĂ̍s̕ςB
					int[] viewIndexList = spread.getHeaderSelections(pane.orientation);
					int[] newWidthList = new int[viewIndexList.length];
					for (int i=0; i<newWidthList.length; i++) {
						newWidthList[i] = width;
					}
					requestResize(viewIndexList, newWidthList);
				}
				else {
					// ̍sIĂȂA̍sςB
					requestResize(new int[] {pos}, new int[] {width});
				}
				spread.Ĕzu();
				e.consume();
				break;
			case JSpread.COLUMN:
				if (! sheet.allowAutoColHeaderResize) return;
				pos = getResizePosition(sheet.colHeader, e.getX());
				if (pos == -1) break;	// EłȂꍇ͉Ȃ
				int colDataIndex = sheet.colHeader.getDataIndex(pos);
				// \Ă邻ׂ̗̂ẴZɂāAœKȃTCY߂
				width = spread.headerController.getPreferredWidth(pane.orientation, colDataIndex);
				// ̍sIĂAIĂ邷ׂĂ̍s̕ςB
				if (sheet.getHeaderSelection(pane.orientation, pos)) {
					// IĂ邷ׂĂ̍s̕ςB
					int[] viewIndexList = spread.getHeaderSelections(pane.orientation);
					int[] newWidthList = new int[viewIndexList.length];
					for (int i=0; i<newWidthList.length; i++) {
						newWidthList[i] = width;
					}
					requestResize(viewIndexList, newWidthList);
				}
				else {
					// ̍sIĂȂA̍sςB
					requestResize(new int[] {pos}, new int[] {width});
				}
				spread.Ĕzu();
				e.consume();
				break;
			case JSpread.CORNER:
				break;
			default:	assert false;
			}
		}
	}
	/**
	 * w肵viewIndex̕ύXB
	 * KvƂ̕ɂȂƂ͌ȂB
	 *
	 * @param viewIndexList
	 * @param newWidthList
	 * @return
	 */
	public boolean requestResize(int[] viewIndexList, int[] newWidthList) {
		assert viewIndexList != null;
		assert newWidthList != null;
		assert viewIndexList.length == newWidthList.length:
			"vfႤ "+viewIndexList.length + " " + newWidthList.length;
		assert viewIndexList.length > 0: viewIndexList.length;
		
		JSpreadHeader header = (pane.orientation == JSpread.ROW) ? 
								spread.sheet.rowHeader:
								spread.sheet.colHeader;

		// vminWidth,maxWidthɎ߂B
		int[] newWidthList2 = new int[newWidthList.length];
		HeaderInfo[] info_list = new HeaderInfo[newWidthList.length];
		int newWidthList2total = 0;
		for (int i=0; i<newWidthList.length; i++) {
			int dataIndex = header.getDataIndex(viewIndexList[i]);
			info_list[i] = header.getInfo(dataIndex);
			newWidthList2[i] = minmax(newWidthList[i], 
					info_list[i].minWidth, info_list[i].maxWidth);
			newWidthList2total += newWidthList2[i];
		}
		
		// TCY[hOFFȂ΁A㉺`FbNvǂ̃TCYɂȂB
		if (header.autoResizeMode == JSpread.AUTO_RESIZE_OFF) {
			for (int i=0; i<newWidthList.length; i++) {
				info_list[i].width = newWidthList2[i];
			}	
			// TODO:wb_yC̕ςȂĂ悢H
			return true;
		}
		
		// Ώۂ̃J߂
		ArrayList IndexList = new ArrayList();
		switch (header.autoResizeMode) {
		case JSpread.AUTO_RESIZE_NEXT_COLUMN:	// ̃J
		{	// ̃ĴAł̃J̎̃J
			int maxIndex = max(viewIndexList);
			if (maxIndex+1 < header.dataIndexList.length) {
				IndexList.add(new Integer(maxIndex+1));
			}
			break;
		}
//		case JSpread.AUTO_RESIZE_SUBSEQUENT_COLUMNS:
//		{	// ̃ĴAł̃Jȍ~
//			int maxIndex = max(viewIndexList);
//			for (int i=maxIndex+1; i<header.dataIndexList.length; i++) {
//				IndexList.add(new Integer(i));
//			}
//			break;
//		}		
		case JSpread.AUTO_RESIZE_LAST_COLUMN:
		{	// ԍŌ̃J
			int maxIndex = max(viewIndexList);
			if (maxIndex+1 < header.dataIndexList.length) {
				IndexList.add(new Integer(header.dataIndexList.length-1));
			}
			break;
		}		
//		case JSpread.AUTO_RESIZE_ALL_COLUMNS:
//			for (int i=0; i<header.dataIndexList.length; i++) {
//				if (! contains(viewIndexList, i)) {
//					IndexList.add(new Integer(i));
//				}
//			}
//			break;
		default:
			assert false: header.autoResizeMode;
		}
		
		// 邱ƂłJȂ΁Avǂ̕ɐݒ肷邱ƂłȂB
		if (IndexList.size() == 0) return false;
		
		// Ŝ̃TCY
		int totalWidth = pane.orientation == JSpread.COLUMN ?
					pane.getWidth(): pane.getHeight();
		//@߂
		int delta = 0;
		for (int i=0; i<info_list.length; i++) {
			delta += (newWidthList2[i] - info_list[i].width);
		}
		System.out.println("Ŝ̃TCY="+totalWidth+" ="+delta);
		long max_width = 0L;
		long min_width = 0L;
		long cur_width = 0L;
		for (int i=0; i<IndexList.size(); i++) {
			int dataIndex = ((Integer) IndexList.get(0)).intValue();
			System.out.println(IndexList.get(i));
			max_width += header.getInfo(dataIndex).maxWidth;
			min_width += header.getInfo(dataIndex).minWidth;
			cur_width += header.getInfo(dataIndex).width;
		}
		System.out.println("󂯓\ȕ="+min_width+" "+max_width+" "+cur_width+" delta="+delta);
		// 󂯓\Ȕ͈͂ɓĂȂB
		if (min_width > cur_width-delta || cur_width-delta > max_width) return false;
		// TODO:󂯓\Ȕ͈͂ɓĂ̂ŁAB
		System.out.println("󂯓\");
		if (IndexList.size() == 1) {
			for (int i=0; i<newWidthList.length; i++) {
				info_list[i].width = newWidthList2[i];
			}	
			int dataIndex = ((Integer) IndexList.get(0)).intValue();
			header.getInfo(dataIndex).width -= delta;
			return true;
		}
		// TODO:vf̎ɂ͓B
		
		
		return false;
	}
	private int minmax(int value, int min, int max) {
		if (value < min) return min;
		if (value > max) return max;
		return value;
	}
	private int max(int[] values) {
		int maxValue = values[0];
		for (int i=0; i<values.length; i++) {
			if (values[i] > maxValue) {
				maxValue = values[i];
			}
		}
		return maxValue;
	}
//	private boolean contains(int[] values, int value) {
//		for (int i=0; i<values.length; i++) {
//			if (values[i] == value) return true;
//		}
//		return false;
//	}
	int getResizePosition(JSpreadHeader header, int x) {
		int pos1 = header.getViewPositionAtPoint(x-5);
		int pos2 = header.getViewPositionAtPoint(x+5);
		//logger.debug("pos1="+pos1+" pos2="+pos2);
		if (pos1 != pos2 && pos1 != -1) {
			return pos1; 
		}
		return -1;
	}
	boolean isSensable(int x, int y) {
		switch (pane.orientation) {
		case JSpread.COLUMN:
			if (! spread.sheet.allowAutoColHeaderResize) return false;
			return getResizePosition(spread.sheet.colHeader, x) != -1;
		case JSpread.ROW:
			if (! spread.sheet.allowAutoRowHeaderResize) return false;
			return getResizePosition(spread.sheet.rowHeader, y) != -1;
		default:
			return false;
		}
	}
	void mouseMoved(MouseEvent e) {
		switch (pane.orientation) {
		case JSpread.COLUMN:
			pane.setCursor(spread.properties.getCursor(JSpread.HEADER_RESIZE_H_CURSOR));
			break;
		case JSpread.ROW:
			pane.setCursor(spread.properties.getCursor(JSpread.HEADER_RESIZE_V_CURSOR));
			break;
		default:
			assert false: pane.orientation;
		}
	}

	Cursor getCursor() {
		switch (pane.orientation) {
		case JSpread.COLUMN:
			return spread.properties.getCursor(JSpread.HEADER_RESIZE_H_CURSOR);
		case JSpread.ROW:
			return spread.properties.getCursor(JSpread.HEADER_RESIZE_V_CURSOR);
		default:
			assert false: pane.orientation;
		}
		return null;
	}
}
