/*
 * 쐬: 2006/04/03
 */
package net.sourceforge.swingx.jspread;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Stroke;
import java.io.IOException;
import java.util.Properties;

import javax.swing.ImageIcon;

public class JSpreadProperty {
	static Properties classProperties = new Properties();
	Properties objectProperties = new Properties();

	static {
		try {
			Cursor headerResizeH = JSpreadUtilities.getCursor(
					"/net/sourceforge/swingx/jspread/Split_H24.png", "header_resize_h", 7, 7);
			Cursor headerResizeV = JSpreadUtilities.getCursor(
					"/net/sourceforge/swingx/jspread/Split_V24.png", "header_resize_v", 7, 7);
			Cursor dividerH = JSpreadUtilities.getCursor(
					"/net/sourceforge/swingx/jspread/DividerH24.png", "divider_h", 7, 7);
			Cursor dividerV = JSpreadUtilities.getCursor(
					"/net/sourceforge/swingx/jspread/DividerV24.png", "divider_v", 7, 7);
			Cursor dividerCross = Cursor.getPredefinedCursor(Cursor.MOVE_CURSOR);
			Cursor cellCursor = JSpreadUtilities.getCursor(
					"/net/sourceforge/swingx/jspread/Cell24.png", "cell", 7, 7);
			classProperties.put(JSpread.HEADER_RESIZE_H_CURSOR, headerResizeH);
			classProperties.put(JSpread.HEADER_RESIZE_V_CURSOR, headerResizeV);
			classProperties.put(JSpread.DIVIDER_H_CURSOR, dividerH);
			classProperties.put(JSpread.DIVIDER_V_CURSOR, dividerV);
			classProperties.put(JSpread.DIVIDER_CROSS_CURSOR, dividerCross);
			classProperties.put(JSpread.CELL_CURSOR, cellCursor);
			classProperties.put(JSpread.EDIT_START_CLICK_COUNT, new Integer(2));
			ImageIcon edit_delete = JSpreadUtilities.getImageIcon("/net/sourceforge/swingx/EditDelete.png");
			ImageIcon edit_cut = JSpreadUtilities.getImageIcon("/net/sourceforge/swingx/EditCut.png");
			ImageIcon edit_copy = JSpreadUtilities.getImageIcon("/net/sourceforge/swingx/EditCopy.png");
			ImageIcon edit_paste = JSpreadUtilities.getImageIcon("/net/sourceforge/swingx/EditPaste.png");
			classProperties.put(JSpread.DELETE_ICON, edit_delete);
			classProperties.put(JSpread.CUT_ICON, edit_cut);
			classProperties.put(JSpread.COPY_ICON, edit_copy);
			classProperties.put(JSpread.PASTE_ICON, edit_paste);
			
			// F
//			Color swingColor0 = new Color(102, 102, 153);
//			Color swingColor1 = new Color(153, 153, 204);
			Color swingColor2 = new Color(204, 204, 255);
//			Color LIGHT_GRAY2 = new Color(0xE0,0xDF,0xE3);
			classProperties.put(JSpread.BACKGROUND_COLOR, Color.LIGHT_GRAY);
			classProperties.put(JSpread.CELL_FOREGROUND_COLOR, new Color(51, 51, 51));
			classProperties.put(JSpread.CELL_BACKGROUND_COLOR, Color.WHITE);
			classProperties.put(JSpread.CELL_SELECT_FOREGROUND_COLOR, Color.BLACK);
			classProperties.put(JSpread.CELL_SELECT_BACKGROUND_COLOR, swingColor2);
			classProperties.put(JSpread.CELL_FOCUS_COLOR, Color.BLACK);
			classProperties.put(JSpread.CELL_FOCUS_STROKE, new BasicStroke(2.0f));
			classProperties.put(JSpread.HEADER_FOREGROUND_COLOR, Color.BLACK);
			classProperties.put(JSpread.HEADER_BACKGROUND_COLOR, JSpread.LIGHT_GRAY2);
			classProperties.put(JSpread.HEADER_SELECT_FOREGROUND_COLOR, Color.BLACK);
			classProperties.put(JSpread.HEADER_SELECT_BACKGROUND_COLOR, JSpread.swingColor1);
			classProperties.put(JSpread.VERTICAL_GRID_COLOR, Color.LIGHT_GRAY);
			classProperties.put(JSpread.HORIZONTAL_GRID_COLOR, Color.LIGHT_GRAY);
			classProperties.put(JSpread.FIX_SPLIT_COLOR, Color.BLACK);

			classProperties.put(JSpread.TAB_SHEET_FONT, new Font("Dialog", Font.PLAIN, 12));
			classProperties.put(JSpread.DIVIDER_WIDTH, new Integer(7));
			classProperties.put(JSpread.CROSS_DOMAIN, new Integer(5));
//			classProperties.put(JSpread.CELL_WIDTH, new Integer(72));
//			classProperties.put(JSpread.CELL_HEIGHT, new Integer(18));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	Object getProperty(String key) {
		assert key != null: key;
		Object value = objectProperties.get(key);
		if (value == null) {
			value = classProperties.get(key);
			assert value != null: key;
		}
		if (value == JSpread.NULL) {
			value = null;
		}
		return value;
	}
	// ȉ̓RrjGXȃ\bh
	Cursor getCursor(String key) {
		return (Cursor) getProperty(key);
	}
	int getInt(String key) {
		return ((Integer) getProperty(key)).intValue();
	}
	Color getColor(String key) {
		return (Color) getProperty(key);
	}
	Stroke getStroke(String key) {
		return (Stroke) getProperty(key);
	}
	Font getFont(String key) {
		return (Font) getProperty(key);
	}
	ImageIcon getImageIcon(String key) {
		return (ImageIcon) getProperty(key);
	}
	
}
