/*
 * 쐬: 2005/10/25
 */
package net.sourceforge.swingx.jspread;

import java.util.ArrayList;
import java.util.Arrays;

public class JSpreadSheet implements JSpreadConstant {
	/** f[^.KׂĂ̗̍s͓BvfɂnullB */
	Object[][] data;
	/** ̃wb_.nulls */
	JSpreadHeader rowHeader;
	/** s̃wb_.nulls */
	JSpreadHeader colHeader;
	/** R[i[̃f[^.nulls */
	Object cornerData;
	/** V[g(nulls) */
	String name;

	/** tH[JX̂Z̕\ʒu(viewIndex) 0..*/
	int focusCol;
	/** tH[JX̂Z̕\ʒu(viewIndex) 0..*/
	int focusRow;
	/** Jg̃Z̕\ʒu(viewIndex)@0..,-1̂ƂsI */
	int curCol;
	/** Jg̃Z̕\ʒu(viewIndex)@0..,-1̂ƂI */
	int curRow;

	/** Z̑I index̐ */
	boolean[][] cellSelection;
	/** ̑I */
	boolean[] rowSelection;
	/** s̑I */
	boolean[] colSelection;
	/** R[i[IĂ邩? */
	boolean cornerSelection;
	/** wb_̋E_uNbNăwb_̕킹邩ǂH*/
	public boolean allowAutoRowHeaderResize = true;
	boolean allowAutoColHeaderResize = true;
	/** TODO:wb_̏ԂύX\H */
	boolean allowRowHeaderReorder = true;
	boolean allowColHeaderReorder = true;
	/** Jwb_\邩ǂH */
	boolean colHeaderVisible = true;
	boolean rowHeaderVisible = true;
	/** TODO:XN[o[̕\̎d. */
//	public int horizontalScrollBarPolicy = JSpread.HORIZONTAL_SCROLLBAR_AS_NEEDED;
//	public int verticalScrollBarPolicy = JSpread.VERTICAL_SCROLLBAR_AS_NEEDED;
//	/** sH(NONE,VERTICAL,HORIZONTAL,BOTĤꂩ) */
//	public int allowSplit = JSpread.NONE;

	JSpreadSheet(JSpread spread, String name, int numRows, int numCols) {
		assert name != null;
		assert numRows >= 0: numRows;
		assert numCols >= 0: numCols;
		this.data = new Object[numRows][numCols];
//		this.rowHeader = new JSpreadHeader(spread, JSpread.ROW, numRows, 32, 18);		// Excel97
		this.rowHeader = new JSpreadHeader(spread, JSpread.ROW, numRows, 32, 15);		// Java5 JTable
//		this.colHeader = new JSpreadHeader(spread, JSpread.COLUMN, numCols, 20, 72);	// Excel97
		this.colHeader = new JSpreadHeader(spread, JSpread.COLUMN, numCols, 16, 72);	// Java5 JTable
		this.cornerData = "";
		this.name = name;
		this.focusCol = this.focusRow = 0;
		this.curCol = this.curRow = 0;
		int numViewRows = rowHeader.getViewCount();
		int numViewCols = colHeader.getViewCount();
		this.cellSelection = new boolean[numViewRows][numViewCols];
		this.rowSelection = new boolean[numViewRows];
		this.colSelection = new boolean[numViewCols];
		this.cornerSelection = false;
	}
	public JSpreadHeader getHeader(int orientation) {
		assert orientation == JSpread.ROW || orientation == JSpread.COLUMN: orientation;
		return orientation == JSpread.ROW ? rowHeader : colHeader;
	}
	/**
	 * rowAcolumn ɈʒuZ̒l擾܂.
	 * @param	rowDataIndex	̃f[^ԍ(dataIndex)(0..*)
	 * @param	colDataIndex	s̃f[^ԍ(dataIndex)(0..*)
	 * @return	l(null)
	 */
	Object getValueAt(int rowDataIndex, int colDataIndex) {
		return this.data[rowDataIndex][colDataIndex];
	}

	/**
	 * rowAcolumn ɈʒuZ̒lݒ肵܂.
	 * @param	value	lBnull
	 * @param	rowDataIndex	̃f[^ԍ(dataIndex)(0..*)
	 * @param	columnDataIndex	s̃f[^ԍ(dataIndex)(0..*)
	 */
	void setValueAt(Object value, int rowDataIndex, int columnDataIndex) {
		this.data[rowDataIndex][columnDataIndex] = value;
	}

	/**
	 * wb_̒l擾܂.
	 * @param	orientation	wb_̎. ROW/COLUMN/CORNER
	 * @param	dataIndex	f[^ԍ(dataIndex)(0..*).CORNEȐꍇ͖B
	 * @return	l(null)
	 */
	Object getHeaderValueAt(int orientation, int dataIndex) {
		assert orientation == ROW || orientation == COLUMN || orientation == CORNER: orientation;
		switch (orientation) {
		case ROW:
			assert 0 <= dataIndex && dataIndex < this.rowHeader.getCount(): dataIndex;
			return this.rowHeader.getValueAt(dataIndex);
		case COLUMN:
			assert 0 <= dataIndex && dataIndex < this.colHeader.getCount(): dataIndex;
			return this.colHeader.getValueAt(dataIndex);
		case CORNER:
			return this.cornerData;
		default:
			assert false: orientation;
		}
		return null;
	}

	/**
	 * wb_̒lݒ肵܂.
	 * @param	value	lBnull
	 * @param	orientation		wb_̎. ROW/COLUMN
	 * @param	dataIndex	f[^ԍ(dataIndex)(0..*)
	 */
	void setHeaderValueAt(Object value, int orientation, int dataIndex) {
		assert orientation == ROW || orientation == COLUMN: orientation;
		if (orientation == ROW) {
			assert 0 <= dataIndex && dataIndex < this.rowHeader.getCount(): dataIndex;
			this.rowHeader.setValueAt(dataIndex, value);
		} else {
			assert 0 <= dataIndex && dataIndex < this.colHeader.getCount(): dataIndex;
			this.colHeader.setValueAt(dataIndex, value);
		}
	}
	
	/**
	 * ̃R[i[̒l擾܂B
	 * @return	l(null)
	 */
	Object getCornerValue() {
		return this.cornerData;
	}

	/**
	 * ̃R[i[̒lݒ肵܂.
	 * @param	value	lBnull
	 */
	void setCornerValue(Object value) {
		this.cornerData = value;
	}
	
	/**
	 * wb_̏c̐Ԃ܂B
	 * @param orientation	wb_̎. ROW/COLUMN
	 * @return	f[^̐(DataIndex)
	 */
	int getCellCount(int orientation) {
		assert orientation == ROW || orientation == COLUMN: orientation;
		return (orientation == ROW) ?
				this.rowHeader.getCount():
				this.colHeader.getCount();
	}
	/**
	 * Z̃TCYݒ肵܂B
	 * ʏ́Ar[̐؂ւȂǁAO傫؂ւꍇɎgp܂B
	 * ̃\bh͂Ȃׂ̏c悤ɓw͂܂A
	 * ̃f[^\ԂȂǂ͖ɂȂ܂B
	 * TCYςȂꍇ͉s܂B
	 * @param rowCount	̐B0ȏ
	 * @param colCount	s̐B0ȏ
	 * @param initValue	l(null)
	 */
	void setCellCount(int newRowCount, int newColCount, Object initValue) {
		assert newRowCount >= 0: newRowCount;
		assert newColCount >= 0: newColCount;
		// TCYςȂƂɂ͉ȂB
		int oldRowCount = this.getCellCount(ROW);
		int oldColCount = this.getCellCount(COLUMN);
		if (newRowCount == oldRowCount && newColCount == oldColCount) {
			return;
		}
		// Vf[^̈pӂAÂf[^Rs[B
		Object[][] newData = new Object[newRowCount][newColCount];
		for (int r=0; r<newRowCount; r++) {
			for (int c=0; c<newColCount; c++) {
				if (r < this.getCellCount(ROW) && c < this.getCellCount(COLUMN)) {
					newData[r][c] = this.getValueAt(r, c);
				} else {
					newData[r][c] = initValue;
				}
			}
		}
		this.data = newData;
		// ̃TCYςƂAwb_̐ςB
		if (newRowCount != this.getCellCount(ROW)) {
			ArrayList headerInfos = new ArrayList();
			JSpreadHeader header = this.rowHeader;
			for (int i=0; i<newRowCount; i++) {
				JSpreadHeader.HeaderInfo info = 
					(i < oldRowCount) ? 
							header.getInfo(i): 
							new JSpreadHeader.HeaderInfo(null, header.defaultWidth, i);
				info.viewPosition = i;	// TODO:я͎cƂł邩H
				headerInfos.add(info);
			}
			header.infos = headerInfos;
			header.makeDataIndexList();
		}
		// s̃TCYςƂAwb_̐ςB
		if (newColCount != this.getCellCount(COLUMN)) {
			ArrayList headerInfos = new ArrayList();
			JSpreadHeader header = this.colHeader;
			for (int i=0; i<newColCount; i++) {
				JSpreadHeader.HeaderInfo info = 
					(i < oldColCount) ?
							header.getInfo(i):
							new JSpreadHeader.HeaderInfo(null, header.defaultWidth, i);
				info.viewPosition = i;	// TODO:я͎cƂł邩H
				headerInfos.add(info);
			}
			header.infos = headerInfos;
			header.makeDataIndexList();
		}
		// IԂTCYύXB
		int numViewRows = rowHeader.getViewCount();
		int numViewCols = colHeader.getViewCount();
		this.cellSelection = new boolean[numViewRows][numViewCols];
		this.rowSelection = new boolean[numViewRows];
		this.colSelection = new boolean[numViewCols];
		this.cornerSelection = false;
		System.out.println(newRowCount+"->"+newRowCount+" viewCount="+rowHeader.getViewCount());
	}

	/**
	 * w肳ꂽꏊɗ/s}܂BdataIndex-1w肷Ɩɒǉ܂B
	 * @param value			Z̒lBnull
	 * @param header		wb_̎. ROW/COLUMN
	 * @param dataIndex		}ꏊB-1̏ꍇAɒǉ܂B
	 * @param count			}s/̐. 1ȏ
	 * @param headerValue	wb_̒lBnull
	 */
	void insertValueAt(Object value, int header, int dataIndex, int count, Object headerValue) {
		assert header != ROW || header != COLUMN: header;
		assert 0 <= dataIndex || dataIndex == -1: dataIndex;
		assert 1 <= count: count;
		int rowCount = this.getCellCount(ROW);
		int colCount = this.getCellCount(COLUMN);
		if (header == ROW) {
			Object[][] newData = new Object[rowCount+count][colCount];
			if (dataIndex != -1) {
				for (int r=0; r<rowCount; r++) {
					if (r < dataIndex) {
						newData[r] = this.data[r];
					} else if (r < dataIndex + count) {
						newData[r] = new Object[colCount];
						Arrays.fill(newData[r], value);
					} else {
						newData[r] = this.data[r-count];
					}
				}
			} else {
				System.arraycopy(this.data, 0, newData, 0, rowCount);
				for (int i=0; i<count; i++) {
					newData[rowCount+i] = new Object[colCount];
					Arrays.fill(newData[rowCount+i], value);
				}
			}
			this.data = newData;
		} else { 
			
		}
		// IԂTCYύXB
		int numViewRows = rowHeader.getViewCount();
		int numViewCols = colHeader.getViewCount();
		this.cellSelection = new boolean[numViewRows][numViewCols];
		this.rowSelection = new boolean[numViewRows];
		this.colSelection = new boolean[numViewCols];
		this.cornerSelection = false;
	}
	
	/** w肳ꂽʒuIB\ʒuŎw */
	boolean getSelection(int viewRow, int viewCol) {
		assert 0<=viewRow && viewRow<rowHeader.getViewCount();
		assert 0<=viewCol && viewCol<colHeader.getViewCount();
		if (cellSelection[viewRow][viewCol]) return true;
		// (curRow,curCol)(focusRow,focusCol)̊ԂH
		if (curRow == -1) {
			// colIȂAcol͈̔͂ɓĂ邩ǂH
			if ((viewCol < curCol) && (viewCol < focusCol)) return false;
			if ((viewCol > curCol) && (viewCol > focusCol)) return false;
			return true;
		}
		if (curCol == -1) {
			// rowIȂArow͈̔͂ɓĂ邩ǂH
			if ((viewRow < curRow) && (viewRow < focusRow)) return false;
			if ((viewRow > curRow) && (viewRow > focusRow)) return false;
			return true;
		}
		if ((viewRow < curRow) && (viewRow < focusRow)) return false;
		if ((viewRow > curRow) && (viewRow > focusRow)) return false;
		if ((viewCol < curCol) && (viewCol < focusCol)) return false;
		if ((viewCol > curCol) && (viewCol > focusCol)) return false;
		return true;
	}
	// TODO:eXgIɍ
	public boolean[] getSelectionArray(int rowcol) {
		assert rowcol == ROW || rowcol == COLUMN: rowcol;
		if (rowcol == ROW) {
			boolean[] result = new boolean[rowHeader.getViewCount()];
			if (curRow == -1) {
				// ׂĂ̗񂪑I
				for (int r=0; r<result.length; r++) {
					result[r] = true;
				}
				return result;
			}
			// 
			for (int r=0; r<result.length; r++) {
				if ((r < curRow && r < focusRow) || (r > curRow && r > focusRow)) {
					for (int c=0; c<colHeader.getViewCount(); c++) {
						if (cellSelection[r][c]) {
							result[r] = true;
							break;
						}
					}
				} else {
					result[r] = true;
				}
			}
			return result;
		} else {
			// TODO:܂
			return null;
		}
	}
	void setSelection(int viewRow, int viewCol, boolean value) {
		assert 0<=viewRow && viewRow<rowHeader.getViewCount();
		assert 0<=viewCol && viewCol<colHeader.getViewCount();
		cellSelection[viewRow][viewCol] = value;
	}
	public void setSelectionAll(boolean value) {
		for (int r=0; r<cellSelection.length; r++) {
			for (int c=0; c<cellSelection[r].length; c++) {
				cellSelection[r][c] = value;
			}
		}
	}

	void setSelection(int row1, int col1, int row2, int col2, boolean value) {
		assert (0 <= row1 && row1 < rowHeader.getViewCount()) || row1 == -1: row1;
		assert (0 <= col1 && col1 < colHeader.getViewCount()) || col1 == -1: col1;
		assert (0 <= row2 && row2 < rowHeader.getViewCount()) || row2 == -1: row2;
		assert (0 <= col2 && col2 < colHeader.getViewCount()) || col2 == -1: col2;
		int rowMin = Math.min(row1, row2);
		int rowMax = Math.max(row1, row2);
		int colMin = Math.min(col1, col2);
		int colMax = Math.max(col1, col2);
		if (col1 == -1 || col2 == -1) {
			colMin = 0;
			colMax = colHeader.getViewCount()-1;
		}
		if (row1 == -1 || row2 == -1) {
			rowMin = 0;
			rowMax = rowHeader.getViewCount()-1;
		}
		for (int r=rowMin; r<=rowMax; r++) {
			for (int c=colMin; c<=colMax; c++) {
				cellSelection[r][c] = value;
			}
		}
	}
	
	/** \ʒu */
	boolean getHeaderSelection(int orientation, int index) {
		assert orientation == JSpread.ROW || 
			orientation == JSpread.COLUMN || 
			orientation == JSpread.CORNER:
			orientation;
		int min, max;
		switch (orientation) {
		case JSpread.ROW:
			if (rowSelection[index]) return true;
			if (curCol != -1) return false;	// sIĂƂɂ͗͑I
			min = Math.min(curRow, focusRow);
			max = Math.max(curRow, focusRow);
			return min <= index && index <= max;
		case JSpread.COLUMN:
			if (colSelection[index]) return true;
			if (curRow != -1) return false;
			min = Math.min(curCol, focusCol);
			max = Math.max(curCol, focusCol);
			return min <= index && index <= max;
		case JSpread.CORNER:
			return cornerSelection;
		default: assert false;
		}
		return false;
	}

	void setHeaderSelectionAll(int orientation, boolean value) {
		assert orientation == JSpread.ROW || orientation == JSpread.COLUMN;
		if (orientation == JSpread.ROW) {
			for (int i=0; i<rowSelection.length; i++) {
				rowSelection[i] = value;
			}
		}
		else {
			for (int i=0; i<colSelection.length; i++) {
				colSelection[i] = value;
			}
		}
	}
	void setCornerSelection(boolean value) {
		cornerSelection = value;
	}
	/** sϏ̃`FbN */
	boolean inv() {
		assert rowHeader != null;
		//rowHeader.inv();
		assert colHeader != null;
		//colHeader.inv();
		assert name != null;
		/** tH[JX̂Z̕\ʒu(viewIndex) 0..*/
		assert 0 <= focusCol && focusCol < colHeader.getViewCount();
		/** tH[JX̂Z̕\ʒu(viewIndex) 0..*/
		assert 0 <= focusRow && focusRow < rowHeader.getViewCount();
		return true;
	}
	public CurrentFocus getCurrentFocus() {
		return new CurrentFocus(focusCol, focusRow, curCol, curRow);
	}
	static class CurrentFocus {
		/** tH[JX̂Z̕\ʒu(viewIndex) 0..*/
		int focusCol;
		/** tH[JX̂Z̕\ʒu(viewIndex) 0..*/
		int focusRow;
		/** Jg̃Z̕\ʒu(viewIndex)@0..,-1̂ƂsI */
		int curCol;
		/** Jg̃Z̕\ʒu(viewIndex)@0..,-1̂ƂI */
		int curRow;
		CurrentFocus(int focusCol, int focusRow, int curCol, int curRow) {
			this.focusCol = focusCol;
			this.focusRow = focusRow;
			this.curCol = curCol;
			this.curRow = curRow;
		}
		public boolean equals(Object obj) {
			CurrentFocus cf = (CurrentFocus) obj;
			return
			this.focusCol == cf.focusCol &&
			this.focusRow == cf.focusRow &&
			this.curCol == cf.curCol &&
			this.curRow == cf.curRow;
		}
		
	}
}
