/*
 * 쐬: 2005/10/10
 */
package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;


public class JSpreadUtilities {
	//private static Logger logger = Logger.getLogger(JSpreadUtilities.class);
	static Graphics2D image_g2 = new BufferedImage(1, 1, BufferedImage.TYPE_4BYTE_ABGR).createGraphics(); 
    /**
     * \̈Ԃ.
     */
	public static Rectangle2D.Float getTextRectangle(Graphics2D g2, String text, Font font) {
		//assert g2 != null: g2;
		assert text != null;
		assert font != null;
		// Graphics2Dw肳ĂȂꍇ́A摜쐬Graphics2D̐ݒlgpČvZB
		if (g2 == null) g2 = image_g2;
		assert text != null && text.length() > 0: text;
		// tHg̃TCYvZ
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout(text, font, frc);
        return new Rectangle2D.Float(0, -tl.getAscent(), 
        		tl.getAdvance(), tl.getAscent()+tl.getDescent());
	}	

	/**
	 * w肵`ɕ\.
	 * sɂ͑ΉĂȂ.
	 * @param g2
	 * @param rect
	 * @param text		s͊܂܂Ȃ
	 * @param font
	 * @param alignmentX
	 * @param alignmentY
	 * @param clipping
	 * TODO:clipping
	 */
    public static void drawText(Graphics2D g2, Rectangle rect, String text, Font font, float alignmentX, float alignmentY, boolean clipping) {
    	assert rect != null;
    	assert text != null: text;
    	assert font != null;
    	assert 0.0f <= alignmentX && alignmentX <= 1.0f: alignmentX;
    	assert 0.0f <= alignmentY && alignmentY <= 1.0f: alignmentY;
    	
    	if (text.length() == 0) return;
    	Rectangle2D.Float textrect = getTextRectangle(g2, text, font);
    	float x = rect.x + (rect.width - textrect.width) * alignmentX;
    	float y = rect.y + (rect.height - textrect.height) * alignmentY;
    	//logger.debug("textrect="+textrect+" x="+x+" y="+y);
    	g2.drawString(text, x, y - textrect.y);
    }

    /**
	 * \[XURL擾.
	 * @param name	"/resources/xxx.png"Ȃ
	 * @return URL
	 */
	public static URL getUrl(String name) {
        return JSpreadUtilities.class.getResource(name);
	}
	public static Cursor getAutoResizeCursor(String resourcename, String cursorname, int x, int y) throws IOException {
		BufferedImage bi = ImageIO.read(JSpreadUtilities.getUrl(resourcename));
		Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(
				bi, new Point(x, y), cursorname);
		return cursor;
	}
	public static Cursor getCursor(String resourcename, String cursorname, int x, int y) throws IOException {
		BufferedImage image = ImageIO.read(JSpreadUtilities.getUrl(resourcename));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getBestCursorSize(image.getWidth(), image.getHeight());
        if (dim.width != image.getWidth() || dim.height != image.getHeight()) {
              BufferedImage newimage = new BufferedImage(dim.width, dim.height, BufferedImage.TYPE_4BYTE_ABGR);
              Graphics2D g2 = (Graphics2D) newimage.getGraphics();
              g2.drawImage(image, 0, 0, new Color(255,0,0,0), null);
              image = newimage;
        }
		Cursor cursor = toolkit.createCustomCursor(image, new Point(x, y), cursorname);
		return cursor;
	}
	
	/**
	 * \[XACR擾.
	 * @param name	"/resources/xxx.png"Ȃ
	 * @return ACR
	 */
	public static ImageIcon getImageIcon(String name) {
        java.net.URL url = JSpreadUtilities.class.getResource(name);
        return new ImageIcon(url);
	}
	/**
	 * w肳ꂽOR|[lgTBKwɂȂĂ΂̉TB
	 * @param comp	
	 * @param name	R|[lg̖O.
	 * @return	R|[lgBȂꍇnullԂB
	 */
	public static JComponent getComponent(JComponent comp, String name) {
		if (name.equals(comp.getName())) return comp;
		for (int i=0; i<comp.getComponentCount(); i++) {
			if (! (comp.getComponent(i) instanceof JComponent)) continue;
			JComponent c = (JComponent) comp.getComponent(i);
			JComponent result = getComponent(c, name);
			if (result != null) return result;
		}
		return null;		
	}
	public static String toString(Rectangle rect) {
		return "Rectangle[x="+rect.x+", y="+rect.y
			+", width="+rect.width+", height="+rect.height+"]";
	}
}
