/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import net.y3n20u.aeszip.AesZipEntry;
import net.y3n20u.aeszip.AesZipOutputStream;

public class AesZipBasicEncrypter {
    private static final int BUFFER_SIZE = 16384;
    private static final String MESSAGE_INVALID_DESTINATION = "'destination' is null or a directory. 'destination' should not be a directory.";
    private static final String MESSAGE_ALREADY_ARCHIVING = "you can not add a file because already archiving.";
    public static int METHOD_DEFAULT = 8;
    private File _destination;
    private FileFilter _fileFilter;
    private final HashMap<String, File> _filesToBeArchived;
    private final HashMap<String, String> _passwords;
    private boolean _inArchiving = false;

    public AesZipBasicEncrypter(File file) {
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException(MESSAGE_INVALID_DESTINATION);
        }
        this._destination = file;
        this._filesToBeArchived = new HashMap();
        this._passwords = new HashMap();
    }

    public void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
    }

    public void add(String string, File file, String string2) {
        if (this._inArchiving) {
            throw new IllegalStateException(MESSAGE_ALREADY_ARCHIVING);
        }
        this._filesToBeArchived.put(string, file);
        this._passwords.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archive() throws IOException {
        this._inArchiving = true;
        AesZipOutputStream aesZipOutputStream = null;
        try {
            aesZipOutputStream = new AesZipOutputStream(new FileOutputStream(this._destination));
            for (String string : this._filesToBeArchived.keySet()) {
                File file = this._filesToBeArchived.get(string);
                byte[] byArray = this._passwords.get(string).getBytes("UTF-8");
                this.archiveImpl(aesZipOutputStream, file, string, byArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        finally {
            if (aesZipOutputStream != null) {
                aesZipOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveImpl(AesZipOutputStream aesZipOutputStream, File file, String string, byte[] byArray) {
        if (this._fileFilter != null && !this._fileFilter.accept(file)) {
            return;
        }
        string = string + (file.isDirectory() && !string.endsWith("/") ? "/" : "");
        AesZipEntry aesZipEntry = new AesZipEntry(string, byArray);
        aesZipEntry.setActualCompressionMethod(METHOD_DEFAULT);
        aesZipEntry.setTime(new Date().getTime());
        try {
            aesZipOutputStream.putNextZipEntry(aesZipEntry);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (file.isDirectory()) {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray2 = new byte[16384];
            int n = inputStream.read(byArray2, 0, 16384);
            while (n != -1) {
                aesZipOutputStream.write(byArray2, 0, n);
                n = inputStream.read(byArray2, 0, 16384);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

