/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import net.y3n20u.aeszip.CommonValues;
import net.y3n20u.aeszip.EncryptionStrengthMode;
import net.y3n20u.aeszip.InvalidFieldException;
import net.y3n20u.aeszip.InvalidMethodException;
import net.y3n20u.rfc2898.Pbkdf2;
import net.y3n20u.util.ByteHelper;

public class AesZipEntry
extends ZipEntry {
    private static final byte[] AES_EXTRA_BYTES = ByteHelper.getBytes("01 99 07 00 02 00 41 45");
    private static final String MESSAGE_SIZE_OVER = "size is too big: {0}";
    private final EncryptionStrengthMode _encryptionStrengthMode;
    private final byte[] _saltValue;
    private final byte[] _encryptionKey;
    private final byte[] _authenticationKey;
    private final byte[] _passwordVerificationValue;
    private int _method = 99;
    private long _relativeOffsetOfLocalFileHeader;

    public AesZipEntry(String string, byte[] byArray) {
        this(string, CommonValues.DEFAULT_ENCRYPT_STRENGTH_MODE, byArray);
    }

    public AesZipEntry(String string, EncryptionStrengthMode encryptionStrengthMode, byte[] byArray) {
        super(string);
        this._encryptionStrengthMode = encryptionStrengthMode;
        this._saltValue = AesZipEntry.generateSaltValue(this._encryptionStrengthMode.getSaltLength());
        int n = this._encryptionStrengthMode.getKeyLength() + this._encryptionStrengthMode.getKeyLength() + 2;
        byte[] byArray2 = new Pbkdf2().deriveKey(byArray, this._saltValue, 1000, n);
        this._encryptionKey = new byte[this._encryptionStrengthMode.getKeyLength()];
        System.arraycopy(byArray2, 0, this._encryptionKey, 0, this._encryptionKey.length);
        this._authenticationKey = new byte[this._encryptionStrengthMode.getKeyLength()];
        System.arraycopy(byArray2, this._encryptionKey.length, this._authenticationKey, 0, this._authenticationKey.length);
        this._passwordVerificationValue = new byte[2];
        System.arraycopy(byArray2, this._encryptionKey.length + this._authenticationKey.length, this._passwordVerificationValue, 0, this._passwordVerificationValue.length);
    }

    @Override
    public long getCompressedSize() {
        long l = super.getCompressedSize();
        if (l < 0L) {
            return -1L;
        }
        long l2 = l + (long)this._encryptionStrengthMode.getSaltLength() + 2L + 10L;
        if (l2 > 0xFFFFFFFFL) {
            throw new InvalidFieldException(MessageFormat.format(MESSAGE_SIZE_OVER, l2));
        }
        return l2;
    }

    @Override
    public void setMethod(int n) {
        if (n != 99) {
            throw new IllegalArgumentException(new InvalidMethodException((short)n));
        }
        this._method = n;
    }

    @Override
    public int getMethod() {
        return this._method;
    }

    @Override
    public byte[] getExtra() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = super.getExtra();
        try {
            if (byArray != null) {
                byteArrayOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.getMethod() != 99) {
            return byteArrayOutputStream.toByteArray();
        }
        try {
            byteArrayOutputStream.write(AES_EXTRA_BYTES);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byteArrayOutputStream.write(this.getStrengthModeValue());
        short s = this.getActualCompressionMethod();
        byteArrayOutputStream.write((byte)(s & 0xFF));
        byteArrayOutputStream.write((byte)(s >>> 8 & 0xFF));
        return byteArrayOutputStream.toByteArray();
    }

    public void setActualCompressionMethod(int n) {
        short s = (short)n;
        if (s != 0 && s != 8) {
            throw new InvalidMethodException(s);
        }
        super.setMethod(n);
    }

    public short getActualCompressionMethod() {
        return (short)super.getMethod();
    }

    public void setRelativeOffsetOfLocalFileHeader(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(MessageFormat.format("the offset must be in [0, {1}], but the argument is {0}.", l, 0xFFFFFFFFL));
        }
        this._relativeOffsetOfLocalFileHeader = l;
    }

    public long getRelativeOffsetOfLocalFileHeader() {
        return this._relativeOffsetOfLocalFileHeader;
    }

    public short getLastModTime() {
        return AesZipEntry.generateTime(super.getTime());
    }

    public short getLastModDate() {
        return AesZipEntry.generateDate(super.getTime());
    }

    public byte getStrengthModeValue() {
        return this._encryptionStrengthMode.getModeValue();
    }

    public byte[] getSaltValue() {
        return this._saltValue;
    }

    public byte[] getEncryptionKey() {
        return this._encryptionKey;
    }

    public byte[] getAuthenticationKey() {
        return this._authenticationKey;
    }

    public byte[] getPasswordVerificationValue() {
        return this._passwordVerificationValue;
    }

    private static byte[] generateSaltValue(int n) {
        byte[] byArray = new byte[n];
        new SecureRandom().nextBytes(byArray);
        return byArray;
    }

    private static short generateTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        if (calendar.get(1) < 1980) {
            return 0;
        }
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        return (short)(n << 11 | n2 << 5 | n3 >> 1);
    }

    private static short generateDate(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        if (n < 1980) {
            n = 1980;
            n2 = 1;
            n3 = 1;
        }
        return (short)(n - 1980 << 9 | n2 + 1 << 5 | n3);
    }
}

