/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

public class ArchiveProgressStatus {
    private final int totalElementCount;
    private final int processedElementCount;
    private final long estimatedSizeTotal;
    private final long processedSizeTotal;
    private final long estimatedSizeCurrent;
    private final long processedSizeCurrent;
    private final String processedSourceName;
    private final String destinationName;

    public ArchiveProgressStatus(int n, int n2, long l, long l2, long l3, long l4, String string, String string2) {
        if (n > 0 && n < n2) {
            throw new IllegalArgumentException();
        }
        if (l > 0L && l < l2) {
            throw new IllegalArgumentException();
        }
        if (l3 > 0L && l3 < l4) {
            throw new IllegalArgumentException(l4 + " / " + l3);
        }
        this.totalElementCount = n;
        this.processedElementCount = n2;
        this.estimatedSizeTotal = l;
        this.processedSizeTotal = l2;
        this.estimatedSizeCurrent = l3;
        this.processedSizeCurrent = l4;
        this.processedSourceName = string == null ? "" : string;
        this.destinationName = string2 == null ? "" : string2;
    }

    public ArchiveProgressStatus(int n, int n2, long l, long l2, long l3, long l4) {
        this(n, n2, l, l2, l3, l4, "", "");
    }

    public ArchiveProgressStatus generateUpdatedStatus(long l) {
        return new ArchiveProgressStatus(this.getTotalElementCount(), this.getProcessedElementCount(), this.getEstimatedSizeTotal(), this.getProcessedSizeTotal() + l, this.getEstimatedSizeCurrent(), this.getProcessedSizeCurrent() + l, this.getProcessedSourceName(), this.getDestinationName());
    }

    public ArchiveProgressStatus generateUpdatedStatusWithNextEntry(long l, String string, String string2) {
        return new ArchiveProgressStatus(this.getTotalElementCount(), this.getProcessedElementCount() + 1, this.getEstimatedSizeTotal(), this.getProcessedSizeTotal(), l, 0L, string, string2);
    }

    public int getTotalElementCount() {
        return this.totalElementCount;
    }

    public int getProcessedElementCount() {
        return this.processedElementCount;
    }

    public long getEstimatedSizeTotal() {
        return this.estimatedSizeTotal;
    }

    public long getProcessedSizeTotal() {
        return this.processedSizeTotal;
    }

    public long getEstimatedSizeCurrent() {
        return this.estimatedSizeCurrent;
    }

    public long getProcessedSizeCurrent() {
        return this.processedSizeCurrent;
    }

    public String getProcessedSourceName() {
        return this.processedSourceName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public double getProgressPercentageTotal() {
        if (this.getEstimatedSizeTotal() < 0L || this.getProcessedSizeTotal() < 0L) {
            return -1.0;
        }
        if (this.getEstimatedSizeTotal() == 0L) {
            return 100.0;
        }
        double d = this.getEstimatedSizeTotal();
        double d2 = this.getProcessedSizeTotal();
        return d2 / d * 100.0;
    }

    public double getProgressPercentageCurrent() {
        if (this.getEstimatedSizeCurrent() < 0L || this.getProcessedSizeCurrent() < 0L) {
            return -1.0;
        }
        if (this.getEstimatedSizeCurrent() == 0L) {
            return 100.0;
        }
        double d = this.getEstimatedSizeCurrent();
        double d2 = this.getProcessedSizeCurrent();
        return d2 / d * 100.0;
    }
}

