# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package Album;

use strict;

use lib '../../extlib';
use lib '../../lib';

use DBI;
use Jcode;
use LWP::UserAgent;
use HTTP::Request::Common qw(POST);
#use XML::RSS;
use AffelioApp;
use HTML::Template;
use Config::Tiny;

our $max_entries = 3000;

##############################################
# コンストラクタ
# AffelioAppを渡します
##############################################

sub new {
	my ($proto, $afap) = @_;
	unless ($afap) { die("Album::new: Error: missing username\n"); }

	my $this = {};
	$this->{afap}  = $afap;
	$this->{tmpfile}= $afap->get_userdata_dir()."/.sqltmp";
	$this->{album_tb}= "album_$afap->{install_name}_entries";
	$this->{image_tb}= "album_$afap->{install_name}_images";
	$this->{comment_tb}= "album_$afap->{install_name}_comments";
	$this->{dbh} = undef;
        # 初期化
	
	unless(-f $this->{tmpfile}) {
	    open(TMP,"> $this->{tmpfile}");
	    close(TMP); 	    
	    $this->{dbh} = $afap->get_userdata_dbh();
		# 日記テーブル
	    my $query;
	    $query="id INTEGER".get_query_primarykey($this)."
			title		TEXT,
			contents	TEXT,
			timestamp	INTEGER,
			update_time	INTEGER,
			user		TEXT,
			afid		TEXT,
			pswd		TEXT,
			ord		INTEGER";
			
	    $this->{dbh}->do("CREATE TABLE $this->{album_tb} ($query)");

		# コメントテーブル

	    $query="pkey INTEGER".get_query_primarykey($this)."
			id		INTEGER,
			user		TEXT,
			afid		TEXT,
			comment		TEXT,
			pswd		TEXT,
			timestamp	INTEGER";
		
	    $this->{dbh}->do("CREATE TABLE $this->{comment_tb} ($query)");


		# 画像テーブル
#
	    $query="pkey INTEGER".get_query_primarykey($this)."
			id		INTEGER,
			image		TEXT,
			title		TEXT,
			user		TEXT,
			afid		TEXT,
			comment		TEXT,
			pswd		TEXT,
			timestamp	INTEGER";

	    $this->{dbh}->do("CREATE TABLE $this->{image_tb} ($query)");

#		$this->{dbh}->disconnect;
	}
	else {
#	    $this->{dbh} = DBI->connect("dbi:SQLite:dbname=".$this->{dbpath})
#			or die("cannot open db: ".$this->{dbpath});
	    $this->{dbh} = $afap->get_userdata_dbh();
        }

	bless $this, $proto;
	return $this;
}

##############################################
# デストラクタ
# DBへの接続を閉じます
##############################################

sub DESTROY {
	my $this = shift;
	$this->{dbh}->disconnect;
}


##############################################
# addAlbum
# 日記に新しいエントリを追加します。
##############################################

sub addAlbum {
	my ($this, $title, $contents, $user, $afid, $time) = @_;
	unless ($time) { $time = time; }

#	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($time);
#	$year += 1900; $mon += 1;
  	my $id = $this->getColumn("SELECT MAX(id) FROM $this->{album_tb}");
	$title = $this->validate($title);
	$user = $this->validate($user);
#	$contents = $this->validate_entry($id, $title, $contents);
	$contents = $this->validate($contents);

	# 二重投稿を防ぐ
#	my @same = $this->getall("SELECT id FROM $this->{album_tb} WHERE title = $title AND contents = $contents");
#	if($#same >= 0) { return; }

	$this->{dbh}->do("INSERT INTO $this->{album_tb} (title, contents, timestamp, update_time, user, afid, pswd, ord) VALUES ($title, $contents, $time, $time, $user, '$afid', '', '')");
  	$id = $this->getColumn("SELECT MAX(id) FROM $this->{album_tb}");

        my $data_dir=$this->{afap}->get_userdata_dir()."/";
  	$data_dir.= $id;
      	if (!-d $data_dir){
        	mkdir $data_dir, 0777;
        }
  	$data_dir.= "/thumbnail";
      	if (!-d $data_dir){
	  	mkdir $data_dir, 0777;
        }
}

##############################################
# addImage
# アルバムDBに新しい画像データを追加します。
##############################################

sub addImage {
	my ($this, $id, $title, $user, $afid, $comment, $image) = @_;
	my $time = time;

#	my $id = $this->getID;
	$title = $this->validate($title);
	$comment = $this->validate($comment);
	$image = $this->validate($image);
	$user = $this->validate($user);

	# 二重投稿を防ぐ
#	my @same = $this->getall("SELECT id FROM $this->{image_tb} WHERE title = '$title' AND comment = '$comment'");
#	if($#same >= 0) { return; }
	my @same = $this->getall("SELECT id FROM $this->{image_tb} WHERE id = $id AND image = $image");
	if($#same > 0) {
	$this->{dbh}->do("UPDATE $this->{image_tb} SET title = $title, comment=$comment, user=$user, afid='$afid', time=$time WHERE id = $id AND image=$image");
        }else{
	$this->{dbh}->do("INSERT INTO $this->{image_tb} (id, image, title, user, afid, comment, pswd, timestamp) VALUES ($id, $image, $title, $user, '$afid', $comment, '', $time)");
      	}
}



##############################################
# updateEntry
# 指定したIDのエントリを更新します
##############################################

sub updateEntry {
	my ($this, $id, $title, $contents) = @_;
	$title = $this->validate($title);
	$contents = $this->validate($contents);
  	my $time = time;
	$this->{dbh}->do("UPDATE $this->{album_tb} SET title = $title, contents = $contents, update_time=$time WHERE id = $id");
}

##############################################
# updateImage
# 指定した画像情報を更新します
##############################################

sub updateImage {
	my ($this, $id, $title, $comment, $image) = @_;
	$title = $this->validate($title);
	$comment = $this->validate($comment);
	$image = $this->validate($image);
  	my $time = time;
	$this->{dbh}->do("UPDATE $this->{image_tb} SET title = $title, comment = $comment WHERE id = $id AND image=$image");
}

##############################################
# updateTimestamp
# 指定したIDのupdate_timeを更新します
##############################################

sub updateTimestamp {
	my ($this, $id) = @_;
  	my $time = time;
	$this->{dbh}->do("UPDATE $this->{album_tb} SET update_time=$time WHERE id = $id");
}


##############################################
# removeAlbum
# 指定したIDのエントリとそれに対するコメントを削除します
##############################################

sub removeAlbum {
	my ($this, $id) = @_;
        my @ret = $this->getall("SELECT * FROM $this->{image_tb} WHERE id = $id");
	$this->{dbh}->do("DELETE FROM $this->{album_tb} WHERE id = $id");
	$this->{dbh}->do("DELETE FROM $this->{comment_tb} WHERE id = $id");
	$this->{dbh}->do("DELETE FROM $this->{image_tb} WHERE id = $id");
        my $data_dir=$this->{afap}->get_userdata_dir()."/".$id."/";
       	my $thumb_dir=$data_dir."thumbnail/";
  	foreach(@ret){
    		unlink($thumb_dir.$_->{image});
    		unlink($data_dir.$_->{image});
        }
	if (-d $thumb_dir){
      		rmdir $thumb_dir;
      	}
	if (-d $data_dir){
     		rmdir $data_dir;
      	}
}

##############################################
# removeImage
# 指定した画像情報を削除します。
##############################################

sub removeImage {
	my ($this, $id, @pkey) = @_;
        my $data_dir=$this->{afap}->get_userdata_dir()."/".$id."/";
       	my $thumb_dir=$data_dir."thumbnail/";
  	my @ret;
  	foreach(@pkey){
		@ret = $this->getall("SELECT * FROM $this->{image_tb} WHERE id = $id AND pkey=$_");
		$this->{dbh}->do("DELETE FROM $this->{image_tb} WHERE id = $id AND pkey=$_");
          	
  		unlink($data_dir.$ret[0]->{image});
	  	unlink($thumb_dir.$ret[0]->{image});
  	}
}

##############################################
# removeComment
# 指定したコメント情報を削除します。
##############################################

sub removeComment {
	my ($this, $id, @pkey) = @_;
  	foreach(@pkey){
		$this->{dbh}->do("DELETE FROM $this->{comment_tb} WHERE id = $id AND pkey=$_");
      	}
}


##############################################
# getEntry
# 指定したIDのエントリの内容を取得します
##############################################

sub getEntry {
	my ($this, $id) = @_;
	my @ret = $this->getall("SELECT * FROM $this->{album_tb} WHERE id = $id");
	return $ret[0];
}

##############################################
# getImage
# 指定したIDとimageの内容を取得します
##############################################

sub getImage {
	my ($this, $id, $pkey) = @_;
	my @ret = $this->getall("SELECT * FROM $this->{image_tb} WHERE id = $id AND pkey=$pkey");
	return $ret[0];
}
sub getAllImage {
	my ($this, $id) = @_;
	return $this->getall("SELECT * FROM $this->{image_tb} WHERE id = $id");
}

sub checkImagefile {
	my ($this, $id, $image) = @_;
	my @ret = $this->getall("SELECT * FROM $this->{image_tb} WHERE id = $id AND image='$image'");
	return $ret[0];
}

##############################################
# getNewestEntries
# 日時に関係なく最新のエントリを取得します。
##############################################

sub getNewestEntries {
	my ($this, $num) = @_;
	unless ($num) { $num = 5; }
	return $this->getall("SELECT * FROM $this->{album_tb} ORDER BY update_time DESC LIMIT $num");
}

##############################################
# getNewestAlbumId
# 最新アルバムのIDを取得。
##############################################

sub getNewestAlbumId {
  	my ($this) = @_;
  	my @ret = $this->getall("SELECT MAX(id) as id FROM $this->{album_tb}");
  	return $ret[0];
}

##############################################
# getAllEntries
# すべてのエントリを取得します。
##############################################

sub getAllEntries {
	my ($this) = @_;
	return $this->getall("SELECT * FROM $this->{album_tb} ORDER BY update_time DESC");
}


##############################################
# addComment
# 指定したIDのエントリにコメントをつけます
##############################################

sub addComment {
	my ($this, $id, $user, $afid, $comment) = @_;
	my $time = time;
	$user = $this->validate($user);
	$comment = $this->validate($comment);
	
	# 二重投稿を防ぐ
	my @same = $this->getall("SELECT id FROM $this->{comment_tb} WHERE user = $user AND comment = $comment");
	if($#same >= 0) { return; }
	
	$this->{dbh}->do("INSERT INTO $this->{comment_tb} (id, user, afid, comment, pswd, timestamp) VALUES ($id, $user, '$afid', $comment, '', $time)");
}


##############################################
# getComments
# 指定したIDのエントリに対するコメントを取得します
##############################################

sub getComments {
	my ($this, $id) = @_;
	return $this->getall("SELECT * FROM $this->{comment_tb} WHERE id = $id ORDER BY timestamp");
}

##############################################
# getCommentsNo
# 指定したIDのエントリに対するコメント数を取得します
##############################################

sub getCommentsNo {
	my ($this, $id) = @_;
	return $this->getColumn("SELECT COUNT(*) FROM $this->{comment_tb} WHERE id = $id");
}

sub getColumn {
	my ($this, $query) = @_;
	my $sth = $this->{dbh}->prepare($query);
	$sth->execute;
	my $num;
	$sth->bind_columns(undef, \$num);
	$sth->fetch;
	$sth->finish;
	if($num) {
		return $num;
	}
	else {
		return 0;
	}
}


##############################################
# getRSS
# 指定したエントリー分のRDFを取得します
##############################################

#sub getRSS {
#	my ($this, $entno) = @_;
#	unless ($entno) { $entno = 10; }

#	my $rss = new XML::RSS (version => '1.0');
#	$rss->channel(
#		title	=> "$this->{afap}->{af}->{user__nickname}'s Diary",
#		link	=> "$this->{afap}->{af}->{site__web_root}/apps/diary/list_diary.pl",
#		description => "$this->{afap}->{af}->{user__nickname}'s Affelio Diary",
#		dc => {
#			creator	=> $this->{afap}->{af}->{user__nickname}
#		}
#	);

#	my @entries = $this->getNewestEntries($entno);
#	foreach(@entries) {
#		my $time = $_->{timestamp};
#		my ($sec, $min, $hour, $mday, $mon, $year) = localtime($time);
#		$year += 1900; $mon += 1;
#		my $contents = $_->{contents};
#		$contents =~ s/<br \/>/\n/g;
#		$rss->add_item(
#			title		=> $_->{title},
#			link		=> "$this->{afap}->{af}->{site__web_root}/apps/diary/list_diary.pl?year=$year&amp;month=$mon&amp;day=$mday",
#			description	=> $contents,
#			dc => {
#				date	=> sprintf("%4d-%02d-%02dT%02d:%02d+09:00", $year, $mon, $mday, $hour, $min),
#				creator	=> $this->{afap}->{af}->{nickname},
#			},
#			trackback => {
#				ping => $this->{afap}->{af}->{site__web_root}."/apps/diary/tb/tb.cgi/$_->{id}",
#			}
#		);
#	}
	
#	return $rss->as_string;
#}


##############################################
# getTrackbacks
# 指定したエントリーのトラックバックを取得します
##############################################

sub getTrackbacks {
	my ($this, $id) = @_;
	local (*IN);

	unless( -e  "data/$id" . ".xml") { return (); }
	
	open(IN, "data/$id" . ".xml");
	my @data = <IN>;
	close(IN);

	my @ret;
	for my $i (0 .. $#data) {
		if($data[$i] =~ /^<item>/) {
			my $title = $data[$i];
			my $link  = $data[++$i];
			my $description = $data[++$i];

			$title =~ s/^<item><title>([^>]+)<\/title>/$1/;
			$link =~ s/^<link>([^>]+)<\/link>/$1/;
			$description =~ s/^<description>([^>]+)<\/description>/$1/;

			push @ret, { TITLE => $title, LINK => $link, DESCRIPTION => $description };
		}
	}
	return @ret;
}


##############################################
# getTrackbacksNo
# 指定したエントリーのトラックバックの数のみ取得します
##############################################

sub getTrackbacksNo {
	my ($this, $id) = @_;
	local (*IN);

	unless( -e  "./data/$id".".xml") { return 0; }
	
	open(IN, "./data/$id".".xml");
	my @data = <IN>;
	close(IN);

	my $num = 0;
	foreach(@data) {
		if($_ =~ /<item>/) { $num++; }
	}
	
	return $num;
}


##############################################
# getURLDescription
# トラックバックURLを知らせるためのRDFを出力します
##############################################

sub getURLDescription {
	my ($this, $id) = @_;
	
	my ($entry) = $this->getall("SELECT * FROM $this->{album_tb} WHERE id = $id");
	my $tmpl = new HTML::Template(filename => "./templates/tpingrdf.tmpl");
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($entry->{timestamp});
	$year += 1900; $mon += 1;
	
	$tmpl->param(
		TITLE => $entry->{title},
		TURL => "$this->{afap}->{af}->{site__web_root}/apps/diary/tb/tb.cgi/$id",
		IDENT => "$this->{afap}->{af}->{site__web_root}/apps/diary/show_diary.cgi?id=$id",
		DESCRIPTION => $entry->{contents},
		CREATOR => $this->{afap}->{af}->{user__nickname},
		DATE => sprintf("%4d-%02d-%02dT%02d:%02d+09:00", $year, $mon, $mday, $hour, $min),
	);

	return $tmpl->output;
}

# 日記に振るユニークなIDを取得する
#sub getID {
#	local (*F);
#	my $count = 0;

#	open(F, "+< $idfile");
#	flock(F, 2);
#	$count = <F>;
#	$count++;
#	seek(F, 0, 0);
#	print F $count;
#	flock(F, 8);
#	close(F);

#	return $count;
#}

# トラックバックPINGを自動的に飛ばす
sub validate_entry {
	my ($this, $id, $title, $contents) = @_;
	my @urls = $contents =~ /(s?https?:\/\/[-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/g;

	foreach(@urls) {
		my $url = $this->discover_tb($_);
		if($url) {
			my %form = (
				title => $title, 
				excerpt => $contents, 
				url => "$this->{afap}->{af}->{site__web_root}/apps/album/show_album.cgi?id=$id",
				blog_name => "$this->{afap}->{af}->{user__nickname}のAffelioアルバム",
			);
			my $req = POST($url, [%form]);
			my $ua = new LWP::UserAgent;
			my $res = $ua->request($req);
			my $str = $res->as_string;
		}
	}

	return $this->validate($contents);
}

# タグ、カンマ、改行の除去
sub validate {
	my ($this, $str) = @_;

	$str =~ s/'/&quot;/g;
	$str =~ s/"/&quot;/g;
	$str =~ s/</&lt;/g;
	$str =~ s/>/&gt;/g;
	$str =~ s/\r\n/<br \/>/g;
	$str =~ s/[\r\n]/<br \/>/g;
	$str =~ s/(s?https?:\/\/[-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/<a href="$1">$1<\/a>/g;
	$str = $this->{dbh}->quote($str);
	return $str;
}

# クエリに合致するすべてのカラムを取得
sub getall {
	my ($this, $query) = @_;

	my $sth = $this->{dbh}->prepare($query);
	$sth->execute;

	my @ret;
	while(my $row = $sth->fetchrow_hashref) {
		push @ret, $row;
	}
	$sth->finish;

	return @ret;
}

# 指定した月のカレンダーをとってくる
sub weekly_days {
	my ($this, $year, $mon) = @_;
	my @weeks;
	my @mday  = (31,31,28,31,30,31,30,31,31,30,31,30,31);
	if (($year % 4 == 0) and ($year % 100) or ($year % 400 == 0)) { $mday[2]  = 29 };
	
	my $lastday = $mday[$mon];
	@mday = (1 .. $mday[$mon]);
	if($mon < 3){ $mon += 12; $year--; }
	my $first_day = ($year+int($year/4)-int($year/100)+int($year/400)+int((13*$mon+8)/5)+1)% 7;

	my $day = 1;
	for my $week (0 .. 7) {
		my @days;
		for(my $i = 0; $i < 7; $i++) {
			push @days, 
			(($week == 0 and $i < $first_day) or ($day > $lastday)) ? 
			'' : $day++;
		}
		$weeks[$week] = \@days;
	}
	
	return @weeks;
}

# 張られたURLに対してトラックバックPINGURLを取得します
# 参考： http://lowlife.jp/yasusii/stories/8.html

sub discover_tb {
	my ($this, $url) = @_;
	my $ua = LWP::UserAgent->new;
	$ua->agent('TrackBack/1.0');  
	$ua->parse_head(0);   
	$ua->timeout(15);
	my $req = HTTP::Request->new(GET => $url);
	my $res = $ua->request($req);
	return unless $res->is_success;
	my $c = $res->content;
	(my $url_no_anchor = $url) =~ s/#.*$//;
	my $item;
	while ($c =~ m!(<rdf:RDF.*?</rdf:RDF>)!sg) {
		my $rdf = $1;
		my($perm_url) = $rdf =~ m!dc:identifier="([^"]+)"!;  
			next unless $perm_url eq $url || $perm_url eq $url_no_anchor;
		if ($rdf =~ m!trackback:ping="([^"]+)"!) {
			return $1;
		} elsif ($rdf =~ m!about="([^"]+)"!) {
			return $1;
		}
	}
}

sub get_query_primarykey {
    my ($this) = @_;
    my $DBConfig = Config::Tiny->new();
    $DBConfig = Config::Tiny->read("$this->{afap}->{af}->{site__user_dir}/db.cfg");
    my $db_type = $DBConfig->{db}->{type};
    my $query;

    if ($db_type eq "sqlite"){
	$query = " PRIMARY KEY,";
    }elsif ($db_type eq "mysql"){
	$query = " AUTO_INCREMENT PRIMARY KEY,";
    }
    return $query;
}

1;
