#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

our $mymode="owner";
require './common/header.pl';
unless ($afap->get_visitor_info("type") eq "self"){
	&errorExit("あなたはこのページにアクセスする権限がありません")
        }

my $tmpl = HTML::Template->new(filename => "./templates/add_album.tmpl");

my $title = $afap->{cgi}->param("title");
my $contents = $afap->{cgi}->param("contents");
my $user = $afap->get_visitor_info("nickname");
my $afid = $afap->get_visitor_info("afid");

$tmpl->param(TITLE => $title);
$tmpl->param(CONTENTS => $contents);

# 投稿
if($afap->{cgi}->param("submit")) {
	$tmpl->param(SUBMIT => "1");
	$album->addAlbum($title, $contents, $user, $afid);
  	my $ret = $album->getNewestAlbumId;
        $tmpl->param(ID => $ret->{id});
}

# 確認
elsif($afap->{cgi}->param("confirm")) {
	$tmpl->param(CONFIRM => "1");
}

# 編集画面
else {
	$tmpl->param(EDIT => "1");
}
print $tmpl->output;

require './common/footer.pl';
