#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require './common/header.pl';
use File::Basename;
my $id = $afap->{cgi}->param("id");
my $entry = $album->getEntry($id);
my $edit = 0;
my $save_file=0;

# 本人（編集可）
if($afap->check_access("add_image")) {
    $edit = 1;
}

my $tmpl = HTML::Template->new(filename => "./templates/show_album.tmpl");

my $col_num=4;

my ($sec, $min, $hour, $mday, $mon, $year) = localtime($entry->{timestamp});
my ($up_sec, $up_min, $up_hour, $up_mday, $up_mon, $up_year) = localtime($entry->{update_time});
$mon+=1;
$year+=1900;
$up_mon+=1;
$up_year+=1900;

# アルバム情報
$tmpl->param(
  	YEAR	=> $year,
  	MONTH	=> $mon,
  	DAY	=> $mday,
  	UP_YEAR	=> $up_year,
	UP_MONTH=> $up_mon,
	UP_DAY	=> $up_mday,
	TITLE	=> $entry->{title},
	CONTENTS=> $entry->{contents},
	ID	=> $id,
  	EDITABLE=> $edit,
);

#画像の登録処理
if ($afap->{cgi}->param("image_upload")){
 	my $filehandle=$cgi->param("uploadingfile");#ファイル名(ハンドル)を取得
  	if ($filehandle){
  		fileparse_set_fstype("MSDOS"); #IE対策。うまく動かないかも？！
  		my $basename  = basename($filehandle,"");
  		if ($basename =~ /^[a-zA-Z0-9\.\-\_]{1,32}$/ ){#ファイル名チェック
			my $fname=$afap->get_userdata_dir().'/'.$id.'/'.$basename;
#保存するファイル名を指定
			my $thumb_fname=$afap->get_userdata_dir().'/'.$id.'/thumbnail/'.$basename;
#保存するファイル名を指定
                  	my $chkFile = $album->checkImagefile($id,$basename);
#                  	if(-e $fname){
                  	if ($chkFile->{image} eq $basename){#同名ファイルが存在
                          unless ($afap->{cgi}->param("rewrite")){
				$tmpl->param(EXIST_SAMEFILE => 1);
		          	$tmpl->param(UPLOAD_IMAGE => $basename);
                          }else{#上書き （未実装）
				$save_file=2;
                          }
                        }else{
				$save_file=1;
                        }

                  	if ($save_file){
				#ファイルの保存
				open (OUT,">$fname") or die  "Can't make serverside file!\n";
	  			while ($bytesread = read($filehandle,$buffer,1024)){
	    				print OUT $buffer;
				}
				close(OUT);

	          		(eval 'use Image::Magick; 1;' ) ? ( $tmpl->param(IMAGEMAGICK => 0) ) : ( $tmpl->param(IMAGEMAGICK =>1) );                  
	          		my $image = Image::Magick->new;
				$image->Read( $fname );
				$image->Resize( geometry=>"100x100" );
				$image->Set( quality=>75 );
				$image->Write( $thumb_fname );

		  		my $title = $afap->{cgi}->param("title");
				my $comment = $afap->{cgi}->param("comment");
	    			$user = $afap->get_visitor_info("nickname");
	    			$afid = $afap->get_visitor_info("afid");

		    		if(!$user){
		                  	$user = '';
		                  	$afid = '';
		                }
                          	if ($save_file=1){
                            		$album->addImage($id, $title, $user, $afid, $comment, $basename);
                                }elsif($save_file=2){
                            		$album->updateImage($id, $title, $comment, $basename);
                                }
				$album->updateTimestamp($id);
		          	$tmpl->param(DONE_UPLOAD => 1);
		          	$tmpl->param(UPLOAD_IMAGE => $basename);
                        }
                }else{
	          	$tmpl->param(ERR_FILENAME => 1);
                }
  	}
        else{
     	  	$tmpl->param(NO_FILENAME => 1);
      	}
}

# サムネイルの表示
my @image_files;
my @image_row;
@image_filelist=$album->getAllImage($id);
if ($#image_filelist>=0){
	$tmpl->param(HAS_IMAGE => 1);
        for (my $i=0; $i<($#image_filelist+1)%$col_num; $i++){
              	push @image_filelist, "";
        }

      	for (my $i=0; $i<($#image_filelist+1)/$col_num; $i++){
		$i_num=$i*$col_num;
      		for (my $j=0; $j<$col_num; $j++){
			push @image_files,
       			{
	                        IMAGE => $image_filelist[$i_num+$j]->{image},
       				ID2 => $id,
                          	PKEY =>  $image_filelist[$i_num+$j]->{pkey},
#                      		PICT=> $i_num+$j
       			};
      		}
		push @image_row,
              	{IMG => [@image_files[$i_num..($i_num+($col_num-1))]]};

       	}
	$tmpl->param(THUMBNAIL => \@image_row);
}

# コメント
if($album->getCommentsNo($id) > 0) {
	$tmpl->param(HAS_COMMENTS => 1);
      	my $user_uri;
	my @comments_param;
	my @comments = $album->getComments($id);
	foreach(@comments) {
		my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{timestamp});
		$mon += 1;
          	if ($_->{user} eq ''){
            		$user_uri="ななしさん";
          	}else{
            		$user_uri='<A HREF="'.$afap->get_site_info("web_root").'/outgoing.cgi?dest_url='.$_->{afid}.'">'.$_->{user}."</A>";
          	}
		push @comments_param,
		{
			UNAME => $user_uri,
			COMMENT_TIME => "$mon月$mday日$hour:$min",
			COMMENT => $_->{comment}
		};
	}
	$tmpl->param(COMMENTS => \@comments_param);
}

if($afap->check_access("write_comment")){
    $tmpl->param("comment_write" => "true");
}


# トラックバックURLの通知

print $album->getURLDescription($id);

print $tmpl->output;

require './common/footer.pl';
