#!/usr/bin/perl
# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require('init.pl');

if (-f "$diary->{datadir}url") {
	print $diary->getRedirection('external_blog.cgi');
	exit;
}

print $diary->get_HTML_header;

my $user = $afap->{cgi}->param("user");
my $edit = 0;

if($afap->check_access("write_diary")) {
    $user = $afap->get_owner_info("nickname");
    $edit = 1;
}

my $tmpl = HTML::Template->new(filename => "./templates/list_diary.tmpl");
#$tmpl->param(NICKNAME => $afap->get_owner_info("nickname"));

my @entries_param;
my $year  = $afap->{cgi}->param("year");
my $month = $afap->{cgi}->param("month");
my $day   = $afap->{cgi}->param("day");
my @entries;

if($year and $month){
	@entries = $diary->getEntries($year, $month, $day);
	if($day and $#entries == 0) {
		my ($tid) = @entries;
		print $diary->getURLDescription($tid->{id});
	}
}
else {
	@entries = $diary->getNewestEntries;
}

my $i = 0;
foreach(@entries) {
	my ($sec, $min, $hour) = localtime($_->{timestamp});
	push @entries_param,
	{
		MONTH	=>	$_->{month},
		DAY	=>	$_->{day},
		#TIME	=>	sprintf("%02d:%02d", $hour, $min),
		TITLE	=>	$_->{title},
		CONTENTS=>	$_->{contents},
		COMMENT_NO =>	$diary->getCommentsNo($_->{id}),
		TRACKBACKS =>	$diary->getTrackbacksNo($_->{id}),
		ID	=>	$_->{id},
		IMAGES	=>	$diary->getUploadedImages($_->{id}, 300, 300),
		EDITABLE=>	$edit
	};
}
$tmpl->param(ENTRIES => \@entries_param, EDITABLE => $edit);

$tmpl->param(install_title => $afap->get_app_info("install_title"));

print $tmpl->output;

print $diary->get_HTML_footer;
