#!/usr/bin/perl
# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require 'init.pl';
print $diary->get_HTML_header;

my $id = $afap->{cgi}->param('id') or $diary->errorExit("記事番号が指定されていません");

$diary->errorExit("存在しない記事です") unless $diary->existsEntry($id);

my $entry = $diary->getEntry($id);

my $tmpl = HTML::Template->new(filename => "./templates/show_diary.tmpl");

# 日記
$tmpl->param(
	ID	=> $entry->{id},
	MONTH	=> $entry->{month},
	DAY	=> $entry->{day},
	TITLE	=> $entry->{title},
	CONTENTS=> $entry->{contents},
	IMAGES	=> $diary->getUploadedImages($entry->{id}, 300, 300),
);

# コメント
if($diary->getCommentsNo($id) > 0) {
	$tmpl->param(HAS_COMMENTS => 1);
	my @comments_param;
	my @comments = $diary->getComments($id);
	foreach(@comments) {
		my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{timestamp});
		$mon += 1;

		push @comments_param,
		{
			UNAME => $_->{user},
			COMMENT_TIME => "$mon月$mday日$hour:$min",
			COMMENT => $_->{comment}
		};
	}
	$tmpl->param(COMMENTS => \@comments_param);
}

if($afap->check_access("write_comment")){
    $tmpl->param("comment_write" => "true");
}

# トラックバックURLの通知
print $diary->getURLDescription($id);

print $tmpl->output;

print $diary->get_HTML_footer;
