# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ManageApplication.pm,v 1.3 2005/07/01 02:00:07 slash5234 Exp $

package Affelio::App::Admin::ManageApplication;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);

    use Exporter;
    @Affelio::App::Admin::ManageApplication::ISA = "Exporter";
    @Affelio::App::Admin::ManageApplication::EXPORT = qw (manage_top show_app save_permission);

    #####################################################################
    #save_permission
    #####################################################################
    sub save_permission{
    	my $af = shift;                 #arg(1) AF
	my $q  = shift;                 #arg(2) CGI
	my $app_name = shift;           #arg(e) app_name

	#formhead_num_action_types
	#formdata_pid(\n)_(n)
	my $num_action_types = $q->param("formhead_num_action_types");
	my $pid_list = $q->param("formhead_pid_list");
	my @pids = split('[\s]+', $pid_list);
	
	my @type_array = 
	    @{$af->{am}->{apps}->{$app_name}->{action_types}};
	unshift(@type_array, "DF_access");
	unshift(@type_array, "DF_visibility");

	foreach my $pid (@pids){
	    my $type_count=0;
	    for($type_count=0; $type_count<$num_action_types; $type_count++){
		
		my $param_name = "formdata_pid" . $pid . "_" . $type_count;
		my $param_value = $q->param($param_name);
		if($param_value ne ""){
		    $param_value = 1;
		}else{
		    $param_value = 0;
		}
		debug_print("ManageApp:save: [$pid]:[$type_array[$type_count]]  = [$param_value]");

		$af->{am}->update_permission($app_name,
					     $pid,
					     $type_array[$type_count],
					     $param_value);
	    }

	} #for each

    }
    #####################################################################
    #show_app
    #####################################################################
    sub show_app{
	my $af = shift;                 #arg(1) AF
	my $app_name = shift;           #arg(2) app_name
	my $output_ref = shift;         #arg(3) ref of %output_data; 

	debug_print("ManageApp::show_app: start.");
	
	$output_ref->{"install_name"} = $app_name;
	$output_ref->{"install_title"} 
	= $af->{am}->{apps}->{$app_name}->{install_title};

	#######################
	#Headers
	#######################
	my @headers=();
	$output_ref->{"headers"} = \@headers;

	push(@headers, {header => '<AF_M text="DF_visibility">'});
	push(@headers, {header => '<AF_M text="DF_access">'});

	my $type_desc_array = 
	    $af->{am}->{apps}->{$app_name}->{action_types_desc};

	my $count=0;
	foreach my $desc (@{$type_desc_array}){
	    debug_print("ManageApp::show_app: header=[$desc]");
	    push(@headers, {header => "$desc"});
	    $count++;
	}
	$output_ref->{"num_action_types"} = $count + 2; #gotta inlude DF 2s.

	#######################
	#Permission data
	#######################
	my @groups=();
	$output_ref->{"groups"} = \@groups;

	#prepare application permission table
	$af->{am}->prepare_app_perm_table($app_name);

	#Retrieve table
	my $result= $af->{am}->get_all_permission($app_name);

	##################
	#For each group...
	##################
	my $pid_list="";
	while( (my ($pid, $type, $target_id, @perms) 
		= $result->fetchrow_array)){
	    
	    debug_print("ManageApp::show_app: data[$pid] $type, $target_id, @perms");
	    my %this_group=();
	    push(@groups, \%this_group);

	    #######################
	    #Group name
	    if($pid==1){
		$this_group{group_name} = "<B><I>" . 
		    $af->{lh}->maketext("_VISITOR_TYPE_F1") . "</I></B>";
	    }elsif($pid==2){
		$this_group{group_name} = "<B><I>" . 
		    $af->{lh}->maketext("_VISITOR_TYPE_F2") . "</I></B>";
	    }elsif($pid==3){
		$this_group{group_name} = "<B><I>" . 
		    $af->{lh}->maketext("_VISITOR_TYPE_PB") . "</I></B>";
	    }elsif($type eq "g"){
		my $query = "select group_name from AFuser_CORE_group where gid=$target_id";
		my $sth = $af->{db}->prepare($query) or die $af->{db}->errstr;
		$sth->execute() or die $af->{db}->errstr;
		my @tmp_array = $sth->fetchrow_array;
		$this_group{group_name} = $tmp_array[0];
	    } #if

	    #######################
	    #Values
	    my @data_array=();
	    $this_group{data_array} = \@data_array;

	    my $count=0;
	    foreach my $val (@perms){

		my $chk_name = "formdata_pid" . $pid . "_" . $count;
		push(@data_array, {value => $val,
				   checkbox_name => $chk_name});
		$count++;
	    }

	    $pid_list .= "$pid ";
	} #while (for each group)

	$output_ref->{"pid_list"} = $pid_list;

    }


    #####################################################################
    #manage_top
    #####################################################################
    sub manage_top{
	my $af = shift;                 #arg(1) AF
	my $output_ref = shift;         #arg(2) ref of %output_data; 

	my @applications=();

	my $install_name;
	my $app;
	while (($install_name, $app) = each(%{$af->{am}->{apps}})){

	    push(@applications, {install_title => $app->{install_title},
				 install_name => $app->{install_name},
				 #
				 editlink_URL  => "$af->{site__web_root}/admin.cgi?mode=access_control_apps&mode2=show_app&app_name=$app->{install_name}",
				 app_URL  => "$af->{site__web_root}/apps/$app->{install_name}/$app->{guest_index}",
				 #
				 app_name  => $app->{app_name},
				 app_version  => $app->{app_version}
			     });	    
	}

	$output_ref->{"applications"} = \@applications;
    }


}#package
1;
