# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ShowProfile.pm,v 1.3 2005/07/01 02:00:06 slash5234 Exp $

package Affelio::App::ShowProfile;
{
    use strict;

    use lib("../../../extlib/");
    use lib("../../../lib");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Time; qw( get_timestamp);
    use Affelio::misc::NetMisc; qw( get_remote_host);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);
    use Affelio::App::FriendRoutines;

    use Exporter;
    @Affelio::App::ShowProfile::ISA = "Exporter";
    @Affelio::App::ShowProfile::EXPORT = qw (show_profile);


    #######################################################################
    #show_profile
    #######################################################################    
    sub show_profile{
	my $af = shift;
	my $output_data_ref = shift;
	my $viewers_mode = shift;
	my $viewers_id = shift;

	debug_print("ShowProfile::show_profile: start view_mode=[$viewers_mode], viewer_id=[$viewers_id]");

	#Get summarized permission list for the given user
	my @list 
	    =  get_summed_permission_list($af, $viewers_id, $viewers_mode);
	debug_print("ShowProfile::show_profile: Got summarized permission...");
	debug_print("ShowProfile::show_profile: \t[@list]");

	#@list containts...
	# $list[0] = perm for nickname      ...aid=0
	# $list[1] = perm for 1st element   ...aid=1
	# $list[2] = ...

	my $attributes = $af->{pm}->get_attribute_table();

	my @row=();
	while(@row = $attributes->fetchrow_array){

	    debug_print("ShowProfile: aid[$row[0]] attr[$row[1]] show? =$list[$row[0]]");

	    if($list[$row[0]] eq "1"){
		$$output_data_ref{"flg_$row[1]"} 
		= "true";

		$$output_data_ref{"profile_$row[1]"} 
		= $af->{'user__' . $row[1]};
	    }
	}

	$$output_data_ref{"profile_intromesg1"} =~ s/\n\n/<P>/g;
	$$output_data_ref{"profile_intromesg1"} =~ s/\n/<BR>/g;

	$$output_data_ref{"profile_intromesg2"} =~ s/\n\n/<P>/g;
	$$output_data_ref{"profile_intromesg2"} =~ s/\n/<BR>/g;

    }

}
1;
