# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# $Id: ProfileManager.pm,v 1.4 2005/07/01 02:00:08 slash5234 Exp $

package Affelio::Managing::ProfileManager;
{
    use strict;
    use lib("../../../extlib");    
    use DBI;
    use Jcode;
    use Error qw(:try);
    use lib("../../");
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::exception::DBException;
    
    #######################################################################
    #Constructor
    #######################################################################
    sub new{
	my $class = shift;
	my $af = shift;
	my $mode = shift;

	debug_print("ProfileManager::new: start.");

	my $self = {af => $af,
		    mode => $mode
		    };

	bless $self, $class;

	#Load profile
	if($mode ne "init"){
	    $self->load_profile();
	}

	debug_print("ProfileManager::new: end.");
	return $self;
    }

    
    #######################################################################
    #save_profile
    #######################################################################
    sub save_profile{
	my $self = shift;
	my $af = $self->{af};

	#Write down user__* variables
	foreach my $key (sort keys %$af){
	    if($key =~ /user__/){
		my $key2 = $key;
		$key2 =~ s/user__//g;
		debug_print("ProfileManager::save_profile: $key2 = $af->{$key}");
		if($af->{$key} ne ""){
		    try{
			save_profile_value($self, $key2, $af->{$key});
		    }catch Affelio::exception::DBException with {
			my $e = shift; 
			throw $e;
		    };
		}
	    }
	} 

	return("");
    }

    sub save_profile_value{
	my $self = shift;
	my $af = $self->{af};
	my $attribute = shift;
	my $value = shift;

	debug_print("ProfileManager::save_profile_value: ($attribute) = ($value)");

	my $query = "SELECT * FROM AFuser_CORE_prof where attribute = '$attribute'";
	my $sth1;
	eval{
	    $sth1 = $af->{db}->prepare($query);
	    $sth1->execute;
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	}

	my @result= $sth1->fetchrow_array();
	if(@result==()){
	    my $query2 = 'insert into AFuser_CORE_prof(attribute, value) values (?,?)';
	    my $sth2;
	    eval{
		$sth2 = $af->{db}->prepare($query2);
		$sth2->execute($attribute, $value);
	    };
	    if($@){
		throw Affelio::exception::DBException($af->{db}->errstr);
	    }

	}else{
	    my $query3 = "update AFuser_CORE_prof set value = '$value' where attribute = '$attribute'";

	    my $sth3;
	    eval{
		$sth3 = $af->{db}->prepare($query3);
		$sth3->execute;
	    };
	    if($@){
		throw Affelio::exception::DBException($af->{db}->errstr);
	    }
	}
    }


    #######################################################################
    #load_profile
    #######################################################################    
    sub load_profile{
	my $self = shift;
	my $af = $self->{af};
	
	debug_print("ProfileManager::load_profile: start.");
	
	my $SQL_profattr;

	try{
	    $SQL_profattr = load_profile_table($self);
	}catch Affelio::exception::DBException with {
	    my $e = shift; 
	    throw $e;
	};
	
	my $attribute=""; my $value="";
	while( ($attribute, $value) = $SQL_profattr->fetchrow_array){
	    $af->{"user__$attribute"} = $value;
	    debug_print("ProfileManager::load_profile: user__$attribute = " 
			. $af->{"user__$attribute"});
	}
	
	debug_print("ProfileManager::load_profile: end.");
	return("");
    }

    ########################################################################
    #load_profile_table
    #   returns SQL_result (attribute, value)  x records
    ########################################################################
    sub load_profile_table{
	my $self = shift;
	my $af = $self->{af};

	my $sth;
	my $query = 'SELECT * FROM AFuser_CORE_prof';

	eval{
	    $sth = $af->{db}->prepare($query);
	    $sth->execute(); 
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	};

	return($sth);
    }

    ########################################################################
    #get_attribute_table
    #   returns SQL_result   (aid, name, type)  x records
    ########################################################################
    sub get_attribute_table{
	my $self = shift;
	my $af = $self->{af};

	##############################
	#retrieve all friend records from DB
	my $query = 'SELECT * FROM AFuser_CORE_prof_attr';
	my $sth;

	eval{
	    $sth = $af->{db}->prepare($query);
	    $sth->execute;
	};
	if($@){
	    throw Affelio::exception::DBException($af->{db}->errstr);
	};

	return($sth);
    }



}#package
1;
