# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: WhatsNewManager.pm,v 1.3 2005/07/01 02:00:08 slash5234 Exp $

package Affelio::Managing::WhatsNewManager;
{
    use strict;
    use lib("../../../extlib");    
    use DBI;
    use Jcode;
    use lib("../../");
    use Affelio::misc::CGIError;
    use Affelio::misc::Time qw(get_timestamp);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Debug qw(debug_print);

    #######################################################################
    #Constructor
    #######################################################################
    sub new{
	my $class = shift;
	my $af = shift;

	debug_print("WhatsNewManager::new: start.");

	my $self = {af => $af
		    };

	bless $self, $class;

	debug_print("WhatsNewManager::new: end.");
	return $self;
    }

    #WhatsNewManager looks up each application directory
    #to get the whole list of message types.

    ########################################################################
    #retrieve_message
    ########################################################################
    #sub SQL_result get_all_group_list
    #  result (mid,timestamp,msg_title,msg_type,msg_from,msg_body,readflag)
    sub retrieve_all_messages{
	my $self = shift;

	debug_print("MM::retrieve: start");
	my $af = $self->{af};

	##############################
	#retrieve all friend records from DB
	my $sth = $af->{db}->prepare(q{SELECT * FROM AFuser_CORE_message}) or die $af->{db}->errstr;
	$sth->execute;

	debug_print("MM::retrieve: end");
	return($sth);
    }

    #######################################################################
    #post_message 
    #  arg1 SenderName:   (app_name)
    #  arg2 Title: (UTF-8)
    #  arg3 Type: (Ascii)
    #  arg4 Body: (free text including URL)
    #######################################################################
    sub post_message{
	my $self = shift;
	my $from = shift;    #1
	my $title = shift;          #2
	my $type = shift;           #3
	my $body = shift;           #4

	my $af = $self->{af};

	Affelio::misc::Debug::debug_print("MM::post_message: start.");

#	$body = Affelio::misc::Encoding::db_encode($body);
#	$title = Affelio::misc::Encoding::db_encode($title);
#	$from = Affelio::misc::Encoding::db_encode($from);

        #mid,timestamp,msg_title,msg_type,msg_from,msg_body,readflag

	##############################
	#Get existing max ID
	my $sth = $af->{db}->prepare(q{SELECT max(mid) FROM AFuser_CORE_message}) or die $af->{db}->errstr;
	$sth->execute;
	my @row = $sth->fetchrow_array;
	my $maxid = $row[0];
	if(defined($row[0])){
	    $maxid = $row[0];
	}else{
	    $maxid = 0;
	}
	my $newid = $maxid+1;
	Affelio::misc::Debug::debug_print("MM::post_message: newid = $newid");

	my $cur_time = Affelio::misc::Time::get_timestamp();

	Affelio::misc::Debug::debug_print("MM::post_message: Writing to DB...");
	Affelio::misc::Debug::debug_print("MM::post_message: [$body]");

	##############################
	#Insert a new record
	my $str1 = "insert into AFuser_CORE_message(mid, timestamp, msgtitle, msgtype, msgfrom, msgbody, readflag) values ($newid, '$cur_time', '$title', '$type', '$from', '$body', 0)";
	$sth = $af->{db}->prepare($str1) or die $af->{db}->errstr;
	$sth->execute or  die $af->{db}->errstr;

	Affelio::misc::Debug::debug_print("MM::post_message: end.");

	return("");
    }

}#package
1;
