# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Sanitizer.pm,v 1.3 2005/07/01 02:00:10 slash5234 Exp $

use strict;

package Affelio::misc::Sanitizer;

use Exporter;
@Affelio::misc::Sanitizer::ISA = "Exporter";
@Affelio::misc::Sanitizer::EXPORT = qw (escape_filename sanitize_URL sanitize_HTML sanitize_number);

#########################################################################

sub escape_filename {
    my $forbedden = '\\\/\*\?\|"<>:,;% ';
    my ($filename) = @_;
    $filename =~ s/([$forbedden])/'%' . unpack('H2', $1)/eg;
    return $filename;
}

#########################################################################

# Sanitize in HTML::Template template files.
# 
#   ESCAPE="HTML"
#   ESCAPE="URL"
#

#########################################################################

sub sanitize_number {
    my $num = shift;
    $num =~ s/\D//g;
    
    return($num);
}

sub sanitize_URL {
    my $url = shift;
    
    # --- http://www.ietf.org/rfc/rfc2396.txt ---
    # uric = reserved | unreserved | escaped
    # reserved = ";" | "/" | "?" | ":" | "@" | "&" | "=" | "+" | "$" | ","
    # unreserved = alphanum | mark
    # mark = "-" | "_" | "." | "!" | "~" | "*" | "'" | "(" | ")"
    # escaped = "%" hex hex
    
    return '' if($url =~ m|[^;/?:@&=+\$,A-Za-z0-9\-_.!~*'()%]|);
  
    # --- http://www.ietf.org/rfc/rfc2396.txt ---
    # scheme = alpha *( alpha | digit | "+" | "-" | "." )
  
    if($url =~ /^([A-Za-z][A-Za-z0-9+\-.]*):/) {
          my $scheme = lc($1);
          my $allowed = 0;
          $allowed = 1 if($scheme eq 'http');
          $allowed = 1 if($scheme eq 'https');
          $allowed = 1 if($scheme eq 'mailto');
          return '' if(not $allowed);
     }
 
     $url =~ s/&/&amp;/g;         # & -> &amp;
     $url =~ s/'/&#39;/g;         # ' -> &#39;
  
     return $url;
}

#########################################################################

sub sanitize_HTML{
    my $str = shift;

    if( $$str ne "" ){
        $$str =~ s/&/&amp;/g;
        $$str =~ s/</&lt;/g;
        $$str =~ s/>/&gt;/g;
        $$str =~ s/"/&quot;/g;
    }
}

#########################################################################
