#!/usr/bin/perl 

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: setup.cgi,v 1.12 2005/07/04 01:14:01 slash5234 Exp $

use strict;

use CGI qw(-unique_headers);
$CGI::DISABLE_UPLOADS = 1;
$CGI::POST_MAX = 102_400;
use Cwd;
use DBI;
use lib("./extlib");
use HTML::Template;
use lib("./lib");
use Affelio;
use Affelio::misc::MyCrypt;
use Affelio::misc::L10N;
use Affelio::misc::Debug qw(debug_print);

############################################################################
#Main
############################################################################
my $g_username="";
my $g_password="";
my $g_nickname="";
my $g_email="";
my $g_crypted_password="";
my $cgi = new CGI;
my $g_fsroot = cwd();
my $g_webroot = $cgi->self_url();
my $g_lh = "";
my $g_locale =""; 
my $g_actionurl="";
my $g_btn_name_accept="";
my $g_err="";
my $g_msg="";
my $g_img="";
my $g_title="";
my $TMPL_FILE="";
my %output_data=();

$g_webroot =~ s|/setup\.cgi.*||;
$g_locale = $cgi->param("locale");

my $g_stage = $cgi->url_param("stage");
if($g_stage eq "") { $g_stage =0};

if($g_locale ne ""){
    load_locale($g_locale);
}

############################################
if($g_stage ==0){
    show_0();

}elsif($g_stage ==10){
    show_10();


}elsif($g_stage ==30){
    show_30();

}elsif($g_stage ==50){
    show_50();

}elsif($g_stage ==100){
    $g_err= check_50();
    if($g_err ne ""){
	show_50();
    }else{
	show_100();
    }

}elsif($g_stage ==200){
    $g_err= check_100();
    if($g_err ne ""){
	show_100();
    }else{
	show_200();
    }

}elsif($g_stage ==350){
    $g_err= check_200();
    if($g_err ne ""){
	show_200();
    }else{
	show_350();
    }

}elsif($g_stage ==400){
    $g_err= check_350();
    if($g_err ne ""){
	show_350();
    }else{
	show_400();
    }

}elsif($g_stage==500){
    $g_err= check_400();
    if($g_err ne ""){
	show_400();
    }else{
	show_500();
    }
}

#########################################
#HTML::Template processing
#########################################
%output_data = ("msg", $g_msg,
		"title", $g_title,
		"btn_name_accept", $g_btn_name_accept,
		"err_msg", $g_err,
		"tmpl_path", "$g_webroot/templates/default/owner_side",
		"locale", $g_locale,
		"action_url", $g_actionurl,
		"img_filename", $g_img
		);

my $tmpl = new HTML::Template( filename => $TMPL_FILE,
			       die_on_bad_params => 0);
foreach my $data_key (keys(%output_data)) {
    $tmpl->param($data_key => $output_data{$data_key});
} 
my $out_msg =  $tmpl->output;

#########################################
#<AF_M> L10N Template processing
#########################################
$out_msg = translate_templateL10N_for_setup($out_msg);

print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
print $out_msg;
exit(1);




############################################################################
#Sub routines
############################################################################
sub show_0{
    $TMPL_FILE = "$g_fsroot/templates/default/owner_side/setup_0.tmpl";
    $g_title ="";
    $g_msg="";
    $g_img= "0.gif";
    $g_actionurl="setup.cgi?stage=10";
}

sub show_10{
    $TMPL_FILE = "$g_fsroot/templates/default/owner_side/setup_1.tmpl";
    $g_title= $g_lh->maketext("_SETUP_title_10");
    $g_msg= $g_lh->maketext("_SETUP_msg_10");
    $g_img= "10.jpg";
    $g_actionurl="setup.cgi?stage=30";
}

#########################################
sub show_30{
    $TMPL_FILE = "$g_fsroot/templates/default/owner_side/setup_1.tmpl";
    $g_title= $g_lh->maketext("_SETUP_title_30");
    $g_msg= $g_lh->maketext("_SETUP_msg_30");
    $g_img= "30.jpg";
    $g_btn_name_accept="true";
    $g_actionurl="setup.cgi?stage=50";
}

#########################################
sub show_50{
    $TMPL_FILE = "$g_fsroot/templates/default/owner_side/setup_1.tmpl";
    $g_title= $g_lh->maketext("_SETUP_title_50");
    $g_msg= msg_50();
    $g_img= "50.jpg";
    $g_actionurl="setup.cgi?stage=100";
}

sub msg_50{
    my $msg = $g_lh->maketext("_SETUP_msg_50_1");
    $msg .= '<blockquote>';
    $msg .= check_module("CGI");
    $msg .= check_module("CGI::Session");
    $msg .= check_module("LWP");
    $msg .= check_module("URI");
    $msg .= check_module("DBI");
    $msg .= $g_lh->maketext("_SETUP_msg_50_3");
    $msg .= check_module("DBD::SQLite");
    $msg .= check_module("DBD::mysql");
    $msg .= '</blockquote>';
    $msg .= $g_lh->maketext("_SETUP_msg_50_2");
}

sub check_50{
    my $err=0;
    my $err_msg="";

    $err += load_module("CGI");
    $err += load_module("CGI::Session");
    $err += load_module("LWP");
    $err += load_module("URI");
    $err += load_module("DBI");
#    my $err_sqlite = load_module("DBD::SQLite");
#    my $err_mysql  = load_module("DBD::mysql");

    if($err < 0){
	$err_msg = $g_lh->maketext("_SETUP_check_50_err1");
    }
    return $err_msg;
}

#########################################
sub show_100{
    $TMPL_FILE = "$g_fsroot/templates/default/owner_side/setup_1.tmpl";
    $g_title= $g_lh->maketext("_SETUP_title_100");
    $g_msg= $g_lh->maketext("_SETUP_msg_100");
    $g_img= "100.jpg";
    $g_actionurl="setup.cgi?stage=200";
}

sub check_100{
    my $err_msg="";

    if(! -e "affelio.cfg"){
	$err_msg .= $g_lh->maketext("_SETUP_check_100_err1");
    }else{
	if(! -r "affelio.cfg"){
	    $err_msg .= $g_lh->maketext("_SETUP_check_100_err2");
	}
	if(! -w "affelio.cfg"){
	    $err_msg .= $g_lh->maketext("_SETUP_check_100_err3");
	}
    }
    if(! -w "userdata"){
	$err_msg .= $g_lh->maketext("_SETUP_check_100_err4",  "userdata");
    }
    if(! -r "userdata"){
	$err_msg .= $g_lh->maketext("_SETUP_check_100_err5",  "userdata");
    }
    if(! -w "session"){
	$err_msg .= $g_lh->maketext("_SETUP_check_100_err4",  "session");
    }
    if(! -r "session"){
	$err_msg .= $g_lh->maketext("_SETUP_check_100_err5",  "session");
    }
    if(! -w "skins"){
	$err_msg .= $g_lh->maketext("_SETUP_check_100_err4",  "skins");
    }
    if(! -r "skins"){
	$err_msg .= $g_lh->maketext("_SETUP_check_100_err5",  "skins");
    }
    if(! -w "templates_dyn"){
	$err_msg .= $g_lh->maketext("_SETUP_check_100_err4",  "templates_dyn");
    }
    if(! -r "templates_dyn"){
	$err_msg .= $g_lh->maketext("_SETUP_check_100_err5",  "templates_dyn");
    }
    if($err_msg ne ""){
	return $err_msg;
    }

    #make userdata/xxxxx session/yyyy directories
    srand(time ^ ($$ + ($$ << 15)));
    #userdata
    my $dir1 = Affelio::misc::MyCrypt::generate_password();
    mkdir("userdata/$dir1", 0777);
    my $dir2 = Affelio::misc::MyCrypt::generate_password();
    mkdir("session/$dir2", 0777);

    return("");
}

#########################################
sub show_200{
    $TMPL_FILE = "$g_fsroot/templates/default/owner_side/setup_1.tmpl";
    $g_title= $g_lh->maketext("_SETUP_title_200");
    $g_msg= msg_200();
    $g_img= "200.jpg";
    $g_actionurl="setup.cgi?stage=350";
}

sub msg_200{
    my $sendmail_path="";
    if(-f "/usr/sbin/sendmail"){
	$sendmail_path = "/usr/sbin/sendmail";
    }
    if(-f "/usr/lib/sendmail"){
	$sendmail_path = "/usr/lib/sendmail";
    }

    my $msg = $g_lh->maketext("_SETUP_msg_200");
    $msg .= '<P><TABLE BORDR="0"><TR><TD>Sendmail:&nbsp;</TD>';
    $msg .= '<TD><INPUT TYPE="text" NAME="sendmail_path" SIZE="40" VALUE="';
    $msg .= $sendmail_path;
    $msg .= '"></TD></TR>';
    $msg .= '</TABLE>';
    return($msg);
}

sub check_200{
    my $err_msg="";

    my $sendmail_path = $cgi->param("sendmail_path");
    if(-f $sendmail_path){
    }else{
	$err_msg .= $g_lh->maketext("_SETUP_check_200_err1", $sendmail_path);
	return $err_msg;
    }

    open(OUT, "> affelio.cfg");
    print OUT "[site_config]\n";
    print OUT "fs_root=$g_fsroot\n";
    print OUT "web_root=$g_webroot\n";
    print OUT "char_set =$g_locale\n";
    print OUT "template =default\n";
    print OUT "\n";
    print OUT "[command]\n";
    print OUT "sendmail=$sendmail_path\n";
    close OUT;

    chmod 0444, 'affelio.cfg';

    return("");
}

#########################################
sub show_350{
    $TMPL_FILE = "$g_fsroot/templates/default/owner_side/setup_1.tmpl";
    $g_title= $g_lh->maketext("_SETUP_title_350");
    $g_msg= $g_lh->maketext("_SETUP_msg_350");
    $g_img= "350.jpg";
    $g_actionurl="setup.cgi?stage=400";
}

sub check_350{
    my $db_type = $cgi->param("dbtype");
    my $db_dbname ="";
    my $db_username ="";
    my $db_password = "";
    my $db_hostname ="";
    my $db_port ="";

    if((!$db_type) || ($db_type eq "")){
	return("invlalid input.");
    }
    if($db_type eq "mysql"){
	if(load_module("DBD::mysql") < 0){
	    return("Perl module not found.");
	}
	$db_dbname = $cgi->param("mysql_dbname");
	$db_username = $cgi->param("mysql_username");
	$db_password = $cgi->param("mysql_password");
	$db_hostname = $cgi->param("mysql_hostname");
	$db_port     = $cgi->param("mysql_port");
    }else{
	if(load_module("DBD::SQLite") < 0){
	    return("Perl module not found.");
	}
    }

    my $userdata_dir="";
    my $dir;
    opendir(DIR, "./userdata");
    while (defined($dir = readdir(DIR))) {
	if(($dir ne '.') && ($dir ne '..') 
	   && ($dir ne 'default') && ($dir ne 'CVS')){
	    $userdata_dir = "./userdata/$dir";
	}
    }
    closedir(DIR);

    #Generate login.cfg file
    open(OUT, "> $userdata_dir/db.cfg");
    print OUT "[db]\n";
    print OUT "type=$db_type\n";
    print OUT "dbname=$db_dbname\n";
    print OUT "username=$db_username\n";
    print OUT "password=$db_password\n";
    print OUT "hostname=$db_hostname\n";
    print OUT "port=$db_port\n";
    print OUT "[appdb]\n";
    print OUT "type=$db_type\n";
    print OUT "dbname=$db_dbname\n";
    print OUT "username=$db_username\n";
    print OUT "password=$db_password\n";
    print OUT "hostname=$db_hostname\n";
    print OUT "port=$db_port\n";
    close OUT;

    return("");
}

#########################################
sub show_400{
    $TMPL_FILE = "$g_fsroot/templates/default/owner_side/setup_1.tmpl";
    $g_title= $g_lh->maketext("_SETUP_title_400");
    $g_msg= $g_lh->maketext("_SETUP_msg_400");
    $g_img= "400.jpg";
    $g_actionurl="setup.cgi?stage=500";
}

sub check_400{
    $g_username = $cgi->param("username");
    $g_password = $cgi->param("password");
    $g_nickname = $cgi->param("nickname");
    $g_email = $cgi->param("email");

    ##########################################################
    #Input check
    ##########################################################
    my @salts = ( "A".."Z", "a".."z", "0".."9", ".", "/" );
    my $salt = $salts[int(rand(64))] . $salts[int(rand(64))];
    $g_crypted_password = crypt($g_password, $salt);

    ##########################################################
    #Determine userdata/..../ directory
    ##########################################################
    my $userdata_dir="";
    my $dir;
    opendir(DIR, "./userdata");
    while (defined($dir = readdir(DIR))) {
	if(($dir ne '.') && ($dir ne '..') 
	   && ($dir ne 'default') && ($dir ne 'CVS')){
	    $userdata_dir = "./userdata/$dir";
	}
    }
    closedir(DIR);

    ##########################################################
    #Copy files
    ##########################################################
    #Copy default face JPEG file 
    system("cp -f defaults/profile_face.jpg $userdata_dir/profile_face.jpg");
    system("chmod 666 $userdata_dir/profile_face.jpg");

    #Copy default preference file
    system("cp -f defaults/preference.cfg $userdata_dir/preference.cfg");

    #Generate login.cfg file
    open(OUT, "> $userdata_dir/login.cfg");
    print OUT "[auth]\n";
    print OUT "username=$g_username\n";
    print OUT "password=$g_crypted_password\n";
    close OUT;

    ##########################################################
    #Load Affelio
    ##########################################################
    my $cfg_dir = ".";
    my $af = new Affelio(ConfigDir => $cfg_dir,
			 Mode => "init");
    my $dbh = $af->{db};

    ##########################################################
    #Database initialization
    ##########################################################

    ################################
    #profile DB
    ################################
    my $create_tbl_cmd = <<EOT;
CREATE TABLE AFuser_CORE_prof(attribute TEXT, value TEXT) 
EOT
    if(!$dbh->do($create_tbl_cmd)){
	die $dbh->errstr;
    }

    $af->{user__nickname} = $g_nickname;
    $af->{user__email1} = $g_email;

    $af->{pm}->save_profile();

    debug_print("saved profile");

    ################################
    #profile attribute DB
    ################################
    $create_tbl_cmd = <<EOT;
CREATE TABLE AFuser_CORE_prof_attr(aid INTEGER, name TEXT, type INTEGER)
EOT
    if(!$dbh->do($create_tbl_cmd)){
	die $dbh->errstr;
    }

    my $sth = $dbh->prepare(q{insert into AFuser_CORE_prof_attr(aid, name, type) values (?,?,?)}) or die $dbh->errstr;

    open(FIN, "$cfg_dir/defaults/AFuser_CORE_prof_attr.csv");
    while(my $line=<FIN>){
	chomp($line);
	my ($aid, $name, $type) = split(',', $line);
	#print "$aid - $name - $type\n";
	
	$sth->execute($aid, $name, $type) or die $af->{db}->errstr;
    }
    close(FIN);

    ################################
    #friends DB
    ################################
    $create_tbl_cmd = <<EOT;
CREATE TABLE AFuser_CORE_friends(uid INTEGER PRIMARY KEY, af_id CHAR(255), nickname TEXT, timestamp TEXT, password TEXT, intro TEXT, option_pid INTEGER, lastupdated TEXT, f2list TEXT)
EOT
    if(!$dbh->do($create_tbl_cmd)){
	die $dbh->errstr;
    }

    ################################
    #erasedfriends DB
    ################################
    $create_tbl_cmd = <<EOT;
CREATE TABLE AFuser_CORE_erasedfriends(uid INTEGER PRIMARY KEY, af_id CHAR(255), timestamp TEXT)
EOT
    if(!$dbh->do($create_tbl_cmd)){
	die $dbh->errstr;
    }

    ################################
    #friendsfriends DB
    ################################
    $create_tbl_cmd = <<EOT;
CREATE TABLE AFuser_CORE_friendsfriends(uid INTEGER PRIMARY KEY, af_id CHAR(255), nickname TEXT, timestamp TEXT, f1list TEXT)
EOT
    if(!$dbh->do($create_tbl_cmd)){
	die $dbh->errstr;
    }

    ################################
    #group DB
    ################################
    $create_tbl_cmd = <<EOT;
CREATE TABLE AFuser_CORE_group(gid INTEGER, group_name TEXT, members TEXT, option_pid INTEGER)
EOT
    if(!$dbh->do($create_tbl_cmd)){
	die $dbh->errstr;
    }

    ################################
    #Permission DB
    ################################
    $create_tbl_cmd = <<EOT;
CREATE TABLE AFuser_CORE_permission(pid INTEGER, type TEXT, target_id  TEXT, 
EOT
    chop($create_tbl_cmd);
    for(my $i=0; $i<=63; $i++){
	$create_tbl_cmd .= " attr$i INT,";
    }
    chop($create_tbl_cmd);
    $create_tbl_cmd .= ")";
    debug_print("setup: create [$create_tbl_cmd]");
    if(!$dbh->do($create_tbl_cmd)){
	die $dbh->errstr;
    }

    ################################
    #tmp_recvd_hs
    ################################
    $create_tbl_cmd = <<EOT;
CREATE TABLE AFuser_SNS_tmp_recvd_hs(sessionid TEXT, timestamp TEXT, af_id CHAR(255), nickname TEXT, DH_key_str TEXT)
EOT
    if(!$dbh->do($create_tbl_cmd)){
	die $dbh->errstr;
    }

    ################################
    #tmp_sent_hs
    ################################
    $create_tbl_cmd = <<EOT;
CREATE TABLE AFuser_SNS_tmp_sent_hs(sessionid TEXT, timestamp TEXT, af_id CHAR(255), nickname TEXT, DH_key_str TEXT)
EOT
    if(!$dbh->do($create_tbl_cmd)){
	die $dbh->errstr;
    }

    ################################
    #message
    ################################
    $create_tbl_cmd = <<EOT;
CREATE TABLE AFuser_CORE_message(mid INTEGER PRIMARY KEY, timestamp TEXT, msgtitle TEXT, msgtype TEXT, msgfrom TEXT, msgbody TEXT, readflag INTEGER)
EOT
    if(!$dbh->do($create_tbl_cmd)){
	die $dbh->errstr;
    }

    $dbh->disconnect;

    ##########################################################
    #Setting Initial Values ...
    ##########################################################
    undef($af);
    $af = new Affelio(ConfigDir => $cfg_dir);

    ################################
    #Set permission to F1
    ################################
    #                 n names  b i  intro   email     url     im
    my @flag_array = (1,1,1,1, 1,1, 1,1,    0,0,0,0, 1,1,1,1, 0,0,0,0,0,0, 1);
    $af->{perm}->add_permission("f", "f1", \@flag_array); 

    ################################
    #Set permission to F2
    ################################
    #                 n names  b i  intro   email     url     im
    my @flag_array = (1,0,0,0, 0,1, 1,1,    0,0,0,0, 1,1,1,1, 0,0,0,0,0,0, 1);
    $af->{perm}->add_permission("f", "f2", \@flag_array); 

    ################################
    #Set permission to PB
    ################################
    #                 n names  b i  intro   email     url     im
    my @flag_array = (1,0,0,0, 0,0, 1,0,    0,0,0,0, 0,0,0,0, 0,0,0,0,0,0, 0);
    $af->{perm}->add_permission("f", "pb", \@flag_array); 

    ################################
    #Make a new group "dear_friend"
    ################################
    my $gid = $af->{gm}->add_group($g_lh->maketext("_SETUP_group_dear_friend"));


    #####################################
    #Set permission to group "dear_friend"
    #####################################
    #                 n names  b i  intro   email     url     im
    my @flag_array = (1,1,1,1, 1,1, 1,1,    1,1,1,1, 1,1,1,1, 1,1,1,1,1,1, 1);
    $af->{perm}->add_permission("g", $gid, \@flag_array); 


    ##########################################################
    #Others...
    ##########################################################

    ################################
    #Copy default template files
    ################################
    system("cp -fr defaults/af_templates/$g_locale ./$af->{site__user_dir}/af_templates");

    ################################
    #Rebuild templates_dyn
    ################################
    use Affelio::App::Admin::EditTemplates qw(rebuild);
    Affelio::App::Admin::EditTemplates::rebuild($af);

    ################################
    #Finally, "chmod"
    ################################
    system("chmod -R 777 ./$af->{site__user_dir}");

    return("");
}

#########################################
sub show_500{
    $TMPL_FILE = "$g_fsroot/templates/default/owner_side/setup_1.tmpl";
    $g_title= $g_lh->maketext("_SETUP_title_500");
    $g_msg= $g_lh->maketext("_SETUP_msg_500", $g_webroot);
    $g_img= "500.jpg";
    $g_actionurl="";
}


#########################################
#Perl module
#########################################
sub check_module{
    my $mod_name = shift;
    my $mod_ver="";
    my $err=0;
    
    $err = load_module($mod_name);
    if ($err < 0) {
	return( $g_lh->maketext("_SETUP_err_module_notfound", $mod_name) );
    } else {
	$mod_ver = $mod_name->VERSION;
	return( $g_lh->maketext("_SETUP_module_found", $mod_name, $mod_ver) );
    }
}

sub load_module{
    my $mod_name = shift;

    $mod_name =~ s!::!/!g;
    eval {
	require "$mod_name.pm";
    };
    if($@){
	return -1;
    }else{
	return 0;
    }
}

#########################################
#Locale
#########################################
sub load_locale{
    my $locale_name = shift;
    $g_lh = Affelio::misc::L10N->get_handle(($locale_name));
    die "Couldn't make a language handle. \n$@" unless $g_lh;
}

sub translate_templateL10N_for_setup {
    #my $af=shift;
    my $mesg = shift;

    my $tag_body ="";
    my $text_value="";
    my $param_value="";

    while( $mesg =~ /<AF_M ([^>]+)>/ ){
        $tag_body = $1;

        $tag_body =~ /text(\s*)=(\s*)["']([^"']*)["'](\s*)param(\s*)=(\s*)["']([^"']*)["']/;
        $text_value=$3;
        $param_value=$7;
        if($text_value eq ""){
            $tag_body =~ /text(\s*)=(\s*)["']([^"']*)["']/;
	    $text_value=$3;
        }

        #print "[$tag_body]\n";
        #print "[$text_value]\n";
        #print "[$param_value]\n";

        my $sbst = $g_lh->maketext($text_value, $param_value);

        $mesg =~ s/<AF_M $tag_body>/$sbst/g;
    }

    return($mesg);
}


