#!/usr/bin/perl 

use strict;

use CGI qw(-unique_headers);
use Cwd;
use DBI;
use lib("./extlib");
use HTML::Template;
use Error qw(:try);
use lib("./lib");
use Affelio;
use Affelio::misc::MyCrypt;
use Affelio::misc::Debug qw(debug_print);

############################################################################
#Main
############################################################################
my $g_username="";
my $g_password="";
my $g_nickname="";
my $g_email="";
my $g_crypted_password="";
my $q = new CGI;
my $g_fsroot = cwd();
my $g_webroot = $q->self_url();

if($q->url_param("mode") eq "go"){
################################
#Start Affelio
################################
my $af;
try{
    $af = new Affelio(ConfigDir => ".");
}catch Error with{
    my $e = shift;
    error($q, "Affelio load error.\n" . $e->stacktrace);
};

################################
#Copy default template files
################################
my $g_locale = $af->{site__locale};
try{
    system("cp -fr defaults/af_templates/$g_locale/*.aftmpl ./$af->{site__user_dir}/af_templates/");
}catch Error with{
    my $e = shift;
    error($q, "Could not copy default templates.\n" . $e->stacktrace);
};

################################
#Rebuild templates_dyn
################################
try{
    use Affelio::App::Admin::EditTemplates qw(rebuild);
    Affelio::App::Admin::EditTemplates::rebuild($af);
}catch Error with{
    my $e = shift;
    error($q, "Could not rebuild templates.\n" . $e->stacktrace);
};

print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
print 'OK. Successfuly done.<P><B>Delete this CGI immediately!!</B>';
exit(1);


}else{
    print "Content-type: text/html; charset=UTF-8\n";
    print "Pragma: no-cache", "\n\n"; 
    print '<HTML><B>Upgrade Affelio from 0.9.5.4 to 1.0RC1</B><P><FORM ACTION="upgrade-0954-10RC1.cgi?mode=go" method=POST><INPUT TYPE="submit" VALUE="Go"></FORM></HTML>';
    exit(1);
}

