# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ja.pm,v 1.5 2005/08/24 16:03:09 higefuku Exp $

package Album::L10N::ja;
{
    use strict;
    use lib("../../../../extlib");
    use lib("../../");
    use Album::L10N;
    use Album::L10N::en_us;
    #
    use vars qw(@ISA %Lexicon);

    sub encoding { "UTF-8" }

    @ISA = qw(Album::L10N::en_us);

    %Lexicon = (
		##########################################################
		#Example
		##########################################################
		'_example_ENCODING_DUMMY' =>'あうほげほげ',
		'_example_check_200_err1' => '[_1] にsendmailが検出できません!',
		##########################################################
		#Add pairs...
		##########################################################
		#行末は全部カンマ入ります（全体で一つの連想配列）
		'Comment' => 'コメント',
		'Add new album' => 'アルバムを追加する',
		'Edit caption' => '説明文の編集',
		'Edit album information' => 'アルバム情報の編集',
		'Edit picture infomation' => '画像情報の編集',
		'Delete comments and images' => '画像とコメントの削除',
		'Delete pictures' => '画像の削除',
		'Delete Comments' => 'コメントの削除',
		'Delete selected pictures' => 'チェックされた画像を削除',
		'Delete selected comments' => 'チェックされたコメントを削除',
		'No image' => '画像が登録されていません。',
		'Delete the album' => 'アルバムの削除',
		'Do you really delete this album?' => '本当に削除しますか？',
		'Edit the caption' => 'コメントの編集',
		'release' => '掲載',
		'update' => '更新',
		'Please write your comment' => 'コメントをお書きください',
		'Confirm' => '確認画面',
		'Submit' => '登録',
		'Yes' => 'はい',
		'No' => 'いいえ',
		'Add new picture' => '画像のアップロード',
		'Write a caption' => 'タイトルとコメントを書く',
		'Title' => 'タイトル',
		'Caption' => 'コメント',
		'Return' => '戻る',
		'Return to index' => '一覧に戻る',
		'Add new album with following information.' => '以下の内容でアルバムを追加します',
		'New album was created.' => 'アルバムを追加しました',
		'Please add your pictures.' => '次にアルバムに画像を登録してください',
		'Continue' => '次へ',
		'Upload' => 'アップロード',
		' was uploaded' => 'をアップロードしました',
		' is already exist.' => 'はすでに存在しています',
		'If you want overwrite it, you have to delete it before.' => '上書きする場合は、一旦既存ファイルを削除してから再度アップロードしてください。',
		'Cannot create thumbnail. please install ImageMagick module.' => 'サムネイルの作成ができません。ImageMagickモジュールが必要です。',
		'Select a picture.' => 'ファイルを選択してください。',
		'Please use English one byte characters.' => 'ファイル名は半角英数でお願いします。',
		'Your name' => '投稿者',
		'Thank you for your comment.' => 'コメントを書き込みました。',
		'Submit following comment' => '以下の内容でコメントします。',
		'Your comment was updated.' => '内容を変更しました。',
		'Access Control Panel' => 'アクセス制御を管理する',
		'Access denied' => 'あなたにはこのページにアクセスする権限がありません',
		'Error' => 'エラー',
		'mode' => 'モード',
		'Current Login' => '現在のログイン',
		'Current mode' => '現在のモード',
		'Login ID' => 'ログインID',
		'Password' => 'パスワード',
		'Login' => 'ログイン',
		'Logout' => 'ログアウト',
		'The image was deleted.' => '画像を削除しました。',
		'The comment was deleted.' => 'コメントを削除しました。',
		'The album was deleted.' => 'アルバムを削除しました。',
		'Information was updated.' => '内容を更新しました。',
		'Update' => '更新',
		'Entry' => '登録',
		
		##########################################################
		'_AUTO' => 1,
		);
}
1;

