#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;
use lib("../../extlib");
use lib("../../lib");
use HTML::Template;
use CGI;
use Cwd;
use File::Basename;
use AffelioApp;
use Album;

##############################################
# Initialize AFAP & put header
##############################################
our $cgi = new CGI();
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(), cgi => $cgi);
our $album = new Album($afap);

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
# put HTML Header
print $afap->get_HTML_header("Affelio Photo Album");
# check access
unless ($afap->check_access("DF_access")) {
    $album->errorExit('<AF_M text="Access denied">');
}

##############################################
# Image Viewer
##############################################
if ($cgi->param("mode") eq "image_view"){
    my $id = $afap->{cgi}->param("id");
    my $afid = $afap->get_visitor_info("afid");
    my $pkey=$afap->{cgi}->param("pkey");
    my $entry = $album->getEntry($id);
    my $image_data = $album->getImage($id,$pkey);
    my $tmpl = HTML::Template->new(filename => "./templates/image_view.tmpl");

#Content Owner can edit it
    if($afap->check_access("add_image")){
	if($image_data->{afid} eq $afid || $afap->get_visitor_info("type") eq "self") {
	    $tmpl->param(EDIT_COMMENT => 1);
        }
    }

# Album info
    $tmpl->param(
		 TITLE	=> $entry->{title},
		 ID	=> $id,
		 PKEY	=> $pkey,
		 );

    my $user_uri='';
    if ($image_data->{user} eq ''){
	$user_uri="ȂȂ";
    }else{
	$user_uri='<A HREF="'.$afap->get_site_info("web_root").'/outgoing.cgi?dest_url='.$image_data->{afid}.'">'.$image_data->{user}."</A>";
    }
    
    $tmpl->param(IMAGE_OWNER => $user_uri);
    if ($image_data->{title}){
	$tmpl->param(HAS_TITLE => '1');
	$tmpl->param(IMAGE_TITLE => $image_data->{title});
    }
    if ($image_data->{comment}){
	$tmpl->param(HAS_COMMENT => '1');
	$tmpl->param(IMAGE_COMMENT => $image_data->{comment});
    }
    if ($image_data->{image}){
	$tmpl->param(HAS_IMAGE => '1');
	$tmpl->param(IMAGE => $image_data->{image});
    }

#show image
    my @image_files;
    my @image_row;
    my @image_filelist=$album->getAllImage($id);
    my $i=0;
    my $max=$#image_filelist;
    foreach(@image_filelist){
	if ($_->{pkey} eq $pkey){
	    if ($i>0){
		$tmpl->param(
			     HAS_PREV => 1,
			     PREV_IMAGE=> $image_filelist[$i-1]->{pkey}
			     );
	    }
	    if ($i<$max){
		$tmpl->param(
			     HAS_NEXT => 1,
			     NEXT_IMAGE=> $image_filelist[$i+1]->{pkey}
			     );
	    }
	}
	$i++;
    }      

    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();

##############################################
# Edit a caption (Image Viewer)
##############################################
}elsif ($cgi->param("mode") eq "edit_caption"){
    my $id = $afap->{cgi}->param("id");
    my $afid = $afap->get_visitor_info("afid");
    my $pkey = $afap->{cgi}->param("pkey");
    my $image_data = $album->getImage($id,$pkey);

# owner can edit it
    if($afap->check_access("add_image")){
	unless($image_data->{afid} eq $afid || $afap->get_visitor_info("type") eq "self") {
	    $album->errorExit('<AF_M text="Access denied">');
        }
    }

    my $tmpl = HTML::Template->new(filename => "./templates/edit_caption.tmpl");
    
    $tmpl->param(ID => $id, PKEY => $pkey);

# done edit
    if($afap->{cgi}->param("edit")) {
	$album->updateImage($id, $afap->{cgi}->param("title"),
			    $afap->{cgi}->param("comment"),
			    $image_data->{image});
	$tmpl->param(DONE => "1");
    }

# edit comment
    elsif ($afap->{cgi}->param("comment_edit")){
	$tmpl->param(EDIT => "1");
	my $entry = $album->getImage($id,$pkey);
	$entry->{comment} =~ s/<br \/>/\n/g;
	$tmpl->param(
		     TITLE => $entry->{title}, 
		     COMMENT => $entry->{comment},
		     PKEY => $entry->{pkey},
		     );
    }
    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();

##############################################
# Write a comment (Thumbnail Viewer)
##############################################
}elsif ($cgi->param("mode") eq "write_comment"){
    unless ($afap->check_access("write_comment")){
	$album->errorExit('<AF_M text="Access denied">');
    }

    my $comment = $afap->{cgi}->param('comment');
    my $tmpl = HTML::Template->new(filename => "./templates/write_comment.tmpl");
    my $id = $afap->{cgi}->param('id') or exit;
    my $user = $afap->get_visitor_info("nickname");
    my $afid = $afap->get_visitor_info("afid");
    my $user_uri="";
     
    if(!$user){
	 $user = "";
	 $user_uri = 'Guest';
	 $afid="";
     }
    else{
	$user_uri='<A HREF="'.$afap->get_site_info("web_root").'/outgoing.cgi?dest_url='.$afid.'">'.$user."</A>"; 
    }

# confirm comment
    if($afap->{cgi}->param('comment_confirm')) {
	$tmpl->param(CONFIRM => "1", COMMENT => $comment, ID => $id, USER_NAME => $user_uri);
    }
    
# submit comment
    elsif($afap->{cgi}->param('comment_commit')) {
	$album->addComment($id, $user, $afid, $comment);
	$album->updateTimestamp($id);
	$tmpl->param(COMMIT => "1", ID => $id);
    }

    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();

##############################################
# Default (Show Thumbnails)
##############################################
}else{
    my $id = $afap->{cgi}->param("id");
    my $entry = $album->getEntry($id);
    my $edit = 0;
    my $save_file=0;

    if($afap->check_access("add_image")) {
	$edit = 1;
    }

    my $tmpl = HTML::Template->new(filename => "./templates/album.tmpl");
    my $col_num=4;

    my ($sec, $min, $hour, $mday, $mon, $year) = localtime($entry->{timestamp});
    my ($up_sec, $up_min, $up_hour, $up_mday, $up_mon, $up_year) = localtime($entry->{update_time});
    $mon+=1;
    $year+=1900;
    $up_mon+=1;
    $up_year+=1900;
    
# Album info
    $tmpl->param(
		 YEAR	=> $year,
		 MONTH	=> $mon,
		 DAY	=> $mday,
		 UP_YEAR	=> $up_year,
		 UP_MONTH=> $up_mon,
		 UP_DAY	=> $up_mday,
		 TITLE	=> $entry->{title},
		 CONTENTS=> $entry->{contents},
		 ID	=> $id,
		 EDITABLE=> $edit,
		 );
    
# upload image
    if ($afap->{cgi}->param("image_upload")){
	my $filehandle=$cgi->param("uploadingfile"); #Get file handle 
  	if ($filehandle){
	    fileparse_set_fstype("MSDOS"); #For IE user
	    my $basename  = basename($filehandle,"");
	    if ($basename =~ /^[a-zA-Z0-9\.\-\_]{1,32}$/ ){ #Check Filename
		my $fname=$afap->get_userdata_dir().'/'.$id.'/'.$basename;
		my $thumb_fname=$afap->get_userdata_dir().'/'.$id.'/thumbnail/'.$basename;
		my $chkFile = $album->checkImagefile($id,$basename);
		if ($chkFile->{image} eq $basename){
		    unless ($afap->{cgi}->param("rewrite")){
			$tmpl->param(EXIST_SAMEFILE => 1);
			$tmpl->param(UPLOAD_IMAGE => $basename);
		    }else{#override(not yet)
			      $save_file=2;
			  }
		}else{
		    $save_file=1;
		}
		
		if ($save_file){
		    # Save file
		    open (OUT,">$fname") or die  "Can't make serverside file!\n";
		    while (my $bytesread = read($filehandle,my $buffer,1024)){
			print OUT $buffer;
		    }
		    close(OUT);
		    
		    (eval 'use Image::Magick; 1;' ) ? ( $tmpl->param(IMAGEMAGICK => 0) ) : ( $tmpl->param(IMAGEMAGICK =>1) );                  
		    my $image = Image::Magick->new;
		    $image->Read( $fname );
		    $image->Resize( geometry=>"100x100" );
		    $image->Set( quality=>75 );
		    $image->Write( $thumb_fname );
		    
		    my $title = $afap->{cgi}->param("title");
		    my $comment = $afap->{cgi}->param("comment");
		    my $user = $afap->get_visitor_info("nickname");
		    my $afid = $afap->get_visitor_info("afid");
		    
		    if(!$user){
			$user = '';
			$afid = '';
		    }
		    if ($save_file=1){
			$album->addImage($id, $title, $user, $afid, $comment, $basename);
		    }elsif($save_file=2){
			$album->updateImage($id, $title, $comment, $basename);
		    }
		    $album->updateTimestamp($id);
		    $tmpl->param(DONE_UPLOAD => 1);
		    $tmpl->param(UPLOAD_IMAGE => $basename);
		}
	    }else{
		$tmpl->param(ERR_FILENAME => 1);
	    }
  	}
        else{
	    $tmpl->param(NO_FILENAME => 1);
      	}
    }
    
#Show thumbnail
    my @image_files;
    my @image_row;
    my @image_filelist=$album->getAllImage($id);
    if ($#image_filelist>=0){
	$tmpl->param(HAS_IMAGE => 1);
        for (my $i=0; $i<($#image_filelist+1)%$col_num; $i++){
	    push @image_filelist,
	    {
		image => "",
		pkey => "",
	    }
        }
	
      	for (my $i=0; $i<($#image_filelist+1)/$col_num; $i++){
	    my $i_num=$i*$col_num;
	    for (my $j=0; $j<$col_num; $j++){
		push @image_files,
		{
		    IMAGE => $image_filelist[$i_num+$j]->{image},
		    ID2 => $id,
		    PKEY =>  $image_filelist[$i_num+$j]->{pkey},
		};
	    }
	    push @image_row,
	    {IMG => [@image_files[$i_num..($i_num+($col_num-1))]]};
	    
       	}
	$tmpl->param(THUMBNAIL => \@image_row);
    }
    
# Show Comment
    if($album->getCommentsNo($id) > 0) {
	$tmpl->param(HAS_COMMENTS => 1);
      	my $user_uri;
	my @comments_param;
	my @comments = $album->getComments($id);
	foreach(@comments) {
	    my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{timestamp});
	    $mon += 1;
	    if ($_->{user} eq ''){
		$user_uri="Guest";
	    }else{
		$user_uri='<A HREF="'.$afap->get_site_info("web_root").'/outgoing.cgi?dest_url='.$_->{afid}.'">'.$_->{user}."</A>";
	    }
	    push @comments_param,
	    {
		UNAME => $user_uri,
		COMMENT_TIME => "$mon/$mday/$hour:$min",
		COMMENT => $_->{comment}
	    };
	}
	$tmpl->param(COMMENTS => \@comments_param);
    }
    
    if($afap->check_access("write_comment")){
	$tmpl->param("comment_write" => "true");
    }
    
    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();
}


