# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use lib("../../extlib");
use HTML::Template;
use CGI;
use Cwd;
#
use lib("../../lib");
use AffelioApp;
#
use Album;

our $cgi = new CGI();

#Initialize AFAP
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(),
			   cgi => $cgi);

if(our $mymode eq "owner"){
    $afap->set_owner_mode();
}

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 

# put HTML Header
print $afap->get_HTML_header("Affelio Photo Album");
# check access
unless ($afap->check_access("DF_access")) {
    &errorExit('<AF_M text="Access denied">');
}

our $album = new Album($afap);

#Show Error
sub errorExit {
	my $msg = shift;
  	my $affelio_id = AffelioApp::get_visitor_info("afid");
 	my $visitor_type=AffelioApp::get_visitor_info("type");

if($visitor_type eq ""){
    $visitor_type="pb";
}
	my $tmpl = HTML::Template->new(filename => "./templates/error.tmpl");
	$tmpl->param(V_TYPE => $visitor_type);
	$tmpl->param(AF_ID => $affelio_id);
	$tmpl->param(MSG => $msg);

	print $afap->{af}->translate_templateL10N( $tmpl->output );
	require ("./common/footer.pl");
	exit;
}

##########################################################################
1;
