#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;
use lib("../../extlib");
use lib("../../lib");
use HTML::Template;
use CGI;
use Cwd;
use AffelioApp;
use Album;


#Initialize AFAP
our $cgi = new CGI();
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(), cgi => $cgi);
our $album = new Album($afap);

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
# put HTML Header
print $afap->get_HTML_header("Affelio Photo Album");
# check access
unless ($afap->check_access("DF_access")) {
    $album->errorExit('<AF_M text="Access denied">');
}

my $user = $afap->{cgi}->param("user");

my $tmpl;
###############################################################
# Owner can add album
    my $edit = 0;
    if ($afap->get_visitor_info("type") eq "self"){
	$edit = 1;
    }

    $tmpl = HTML::Template->new(filename => "./templates/index.tmpl");
    my @entries_param;
    my @entries;
    my @images;
    @entries = $album->getAllEntries;
    $tmpl->param(install_title => $afap->get_app_info("install_title"), EDITABLE => $edit);

    foreach(@entries) {
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{update_time});
  	$mon+=1;
  	$year+=1900;
        @images = $album->getAllImage($_->{id});

	push @entries_param,
	{
		MONTH	=>	$mon,
		DAY	=>	$mday,
		#TIME	=>	sprintf("%02d:%02d", $hour, $min),
		TITLE	=>	$_->{title},
		CONTENTS=>	$_->{contents},
		COMMENT_NO =>	$album->getCommentsNo($_->{id}),
		ID	=>	$_->{id},
                IMAGE	=>	$images[0]->{image},
	};
    }
    $tmpl->param(ENTRIES => \@entries_param);
    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();
