#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;
use lib("../../extlib");
use lib("../../lib");
use HTML::Template;
use CGI;
use Cwd;
use AffelioApp;
use Album;


##############################################
#Initialize AFAP & put header
##############################################
our $cgi = new CGI();
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(), cgi => $cgi);
our $album = new Album($afap);

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
# put HTML Header
print $afap->get_HTML_header("Affelio Photo Album");
# check access
unless ($afap->get_visitor_info("type") eq "self"){
    $album->errorExit('<AF_M text="Access denied">');
}

##############################################
# Add new album
##############################################
if ($cgi->param("mode") eq "add_album"){
    my $tmpl = HTML::Template->new(filename => "./templates/owner/add_album.tmpl");
    my $title = $afap->{cgi}->param("title");
    my $contents = $afap->{cgi}->param("contents");
    my $user = $afap->get_visitor_info("nickname");
    my $afid = $afap->get_visitor_info("afid");

    $tmpl->param(TITLE => $title, CONTENTS => $contents);

    if($afap->{cgi}->param("submit")) {
	$tmpl->param(SUBMIT => "1");
	$album->addAlbum($title, $contents, $user, $afid);
  	my $ret = $album->getNewestAlbumId;
        $tmpl->param(ID => $ret->{id});
    }
# Confirm information
    elsif($afap->{cgi}->param("confirm")) {
	$tmpl->param(CONFIRM => "1");
    }
# Edit infomation
    else {
	$tmpl->param(EDIT => "1");
    }

    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();

##############################################
# Delete the album
##############################################
}elsif ($cgi->param("mode") eq "delete_album"){
    my $tmpl = HTML::Template->new(filename => "./templates/owner/delete_album.tmpl");
    my $id = $afap->{cgi}->param("id");
    $tmpl->param(ID => $id);

# done delete
    if($afap->{cgi}->param("delete")) {
	$album->removeAlbum($id);
	$tmpl->param(DONE => "1", DONE_LABEL => '<AF_M text="The album was deleted">');
    }
# confirm
    elsif($afap->{cgi}->param("delete_confirm")) {
	$tmpl->param(DELETE_CONFIRM => "1");
    }
    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();

##############################################
# Update album infomation (Title and caption) 
##############################################
}elsif ($cgi->param("mode") eq "edit_album_caption"){
    my $tmpl = HTML::Template->new(filename => "./templates/owner/edit_album_caption.tmpl");
    my $id = $afap->{cgi}->param("id");
    $tmpl->param(ID => $id);
# done edit
    if($afap->{cgi}->param("edit")) {
	$album->updateEntry($id, $afap->{cgi}->param("title"), $afap->{cgi}->param("contents"));
	$tmpl->param(DONE => "1", DONE_LABEL => '<AF_M text="Information was updated.">');
    }
    
# comment edit
    elsif ($afap->{cgi}->param("comment_edit")){
	$tmpl->param(EDIT => "1");
	my $entry = $album->getEntry($id);
	$entry->{contents} =~ s/<br \/>/\n/g;
	$tmpl->param(
		     TITLE => $entry->{title}, 
		     CONTENTS => $entry->{contents},
		     );
    }
    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();

##############################################
# Manage Contents (Show thumbnail and comments)
##############################################
}elsif ($cgi->param("mode") eq "manage_album_content"){
    my $tmpl = HTML::Template->new(filename => "./templates/owner/manage_album.tmpl");
    my $id = $afap->{cgi}->param("id");
    $tmpl->param(ID => $id);
# image edit
#    if ($afap->{cgi}->param("image_arrange")){
#	$tmpl->param(ARRANGE => "1");

# show thumbnails
	my $col_num=4;
	my @image_files;
	my @image_row;
	my @image_filelist=$album->getAllImage($id);
	if ($#image_filelist>=0){
	    $tmpl->param(HAS_IMAGE => 1);
	    for (my $i=0; $i<($#image_filelist+1)%$col_num; $i++){
		push @image_filelist,
		{
		    image => "",
		    pkey => "",
		}
	    }

	    for (my $i=0; $i<($#image_filelist+1)/$col_num; $i++){
		my $i_num=$i*$col_num;
      		for (my $j=0; $j<$col_num; $j++){
		    push @image_files,
		    {
			IMAGE => $image_filelist[$i_num+$j]->{image},
			ID2 => $id,
			PKEY=> $image_filelist[$i_num+$j]->{pkey}
		    };
      		}
		push @image_row,
              	{IMG => [@image_files[$i_num..($i_num+($col_num-1))]]};
	    }
	    $tmpl->param(THUMBNAIL => \@image_row);
	}

# comment
	if($album->getCommentsNo($id) > 0) {
	    $tmpl->param(HAS_COMMENTS => 1);
	    my @comments_param;
	    my @comments = $album->getComments($id);
	    foreach(@comments) {
		my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{timestamp});
		$mon += 1;
		push @comments_param,
		{
		    UNAME => $_->{user},
		    COMMENT_TIME => "$mon/$mday/$hour:$min",
		    COMMENT => $_->{comment},
		    PKEY=> $_->{pkey}
		};
	    }
	    $tmpl->param(COMMENTS => \@comments_param);
	}
#    }
    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();

##############################################
# Delete Comments
##############################################
}elsif ($cgi->param("mode") eq "delete_comment"){
    my $tmpl = HTML::Template->new(filename => "./templates/owner/delete_comment.tmpl");
    my $id = $afap->{cgi}->param("id");
    my @pkey = $afap->{cgi}->param("delete_comment");
#Done
    if($afap->{cgi}->param("delete")) {
	$album->removeComment($id,@pkey);
	$tmpl->param(ID => "$id");
	$tmpl->param(DONE => "1");
    }
    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();

##############################################
# Delete Images
##############################################
}elsif ($cgi->param("mode") eq "delete_image"){
    my $tmpl = HTML::Template->new(filename => "./templates/owner/delete_image.tmpl");
    my $id = $afap->{cgi}->param("id");
    my @pkey = $afap->{cgi}->param("delete_image");
# Done
    if($afap->{cgi}->param("delete")) {
	$album->removeImage($id,@pkey);
	$tmpl->param(ID => "$id");
	$tmpl->param(DONE => "1");
    }
    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();

##############################################
# Default (Owner mode)
##############################################
}else{
    my $tmpl = HTML::Template->new(filename => "./templates/owner/owner.tmpl");
    $tmpl->param(access_control_URL => $afap->get_URL("access_control"));

    my @entries_param;
    my $year  = $afap->{cgi}->param("year");
    my $month = $afap->{cgi}->param("month");
    my $day   = $afap->{cgi}->param("day");
    my @entries;
    my @images;
    @entries = $album->getAllEntries;;

    my $i = 0;
    foreach(@entries) {
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{update_time});
  	$mon+=1;
  	$year+=1900;
        @images = $album->getAllImage($_->{id});

	push @entries_param,
	{
		MONTH	=>	$mon,
		DAY	=>	$mday,
		#TIME	=>	sprintf("%02d:%02d", $hour, $min),
		TITLE	=>	$_->{title},
		CONTENTS=>	$_->{contents},
		ID	=>	$_->{id},
                IMAGE	=>	$images[0]->{image},
		EDITABLE=>	1
	};
    }
    $tmpl->param(ENTRIES => \@entries_param, EDITABLE => 1);
    $tmpl->param(install_title => $afap->get_app_info("install_title"));
    print $album->translate_templateL10N( $tmpl->output );
    print $afap->get_HTML_footer();
}
