# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ja.pm,v 1.1 2005/12/19 06:46:28 higefuku Exp $

package bb::L10N::ja;
{
    use strict;
    use lib("../../../../extlib");
    use lib("../../");
    use bb::L10N;
    use bb::L10N::en_us;
    #
    use vars qw(@ISA %Lexicon);

    sub encoding { "UTF-8" }

    @ISA = qw(bb::L10N::en_us);

    %Lexicon = (
		##########################################################
		#Example
		##########################################################
		'_example_ENCODING_DUMMY' =>'あうほげほげ',
		'_example_check_200_err1' => '[_1] にsendmailが検出できません!',
		##########################################################
		#Add pairs...
		##########################################################
		#行末は全部カンマ入ります（全体で一つの連想配列）
		'General settings' => '一般設定',
		'Edit category' => 'カテゴリの追加／編集',
		'Spam filter' => 'スパムフィルター',
		'Permission setting' => 'パーミッション設定',
		'Access control' => 'アクセスコントロール',
		'Under Construction' => '実装中・・・',
		'Add category' => 'カテゴリの追加',
		'Prevent a SPAM' => 'スパム対策',
		'Add keyword' => 'キーワードの追加',
		'remove keyword' => 'キーワードの削除',
		'Please make a new category.' => 'カテゴリがありません。カテゴリを追加してください。',
		'Add new category' => 'カテゴリの新規作成',
		'Add new category with following information.' => '以下の内容でカテゴリを作成します。',
		'New category was created.' => 'カテゴリが追加されました。',
		'Return to owner page.' => 'オーナーページトップに戻る。',
		'Add forum' => 'フォーラムの新規作成',
		'Add new forum' => 'フォーラムの新規作成',
		'description' => '説明',
		'Add new forum with following information.' => '以下の内容でフォーラムを作成します。',
		'Return to top page.' => 'トップページへ戻る。',
		'New forum was created.' => 'フォーラムが追加されました。',
		'Add topic' => 'トピックの新規作成',
		'Please make a new topic.' => 'トピックがありません。新しいトピックを作成してください。',
		'Add new topic' => 'トピックの作成',
		'Status' => '状態',
		'Default' => '通常',
		'Sticky' => '注目',
		'Announcement' => '重要なお知らせ',
		'Add new topic with following information.' => '以下の内容でトピックを作成します。',
		'New Topic was created.' => '新しいトピックが追加されました。',
		'Subject' => 'タイトル',
		'Nickname' => 'ニックネーム',
		'Add new comment with following information.' => '以下の内容でコメントを投稿します。',
		'Return to the topic.' => 'トピックに戻る。',
		'Return to the forum.' => 'フォーラムに戻る。',
		'Please input data correctly.' => 'データを正しく入力してください。',
		'Max number of topics' => 'トピック数の上限',
		'Max number of comments' => '返信コメント数の上限',
		'Number of topics in a page' => '１ページに表示するトピック数',
		'Number of comments in a page' => '１ページに表示するコメント数',
		'Max length of a subject' => 'タイトルの最大長',
		'Max length of a comment' => '本文の最大長',
		'E-mail for update information' => '更新通知用メールアドレス',
		'Comment' => 'コメント',
		'Description' => '説明',
		'User name' => 'ユーザー名',
		'Edit caption' => '説明文の編集',
		'Delete Comments' => 'コメントの削除',
		'Delete selected comments' => 'チェックされたコメントを削除',
		'Edit the caption' => 'コメントの編集',
		'update' => '更新',
		'Please write your comment' => 'コメントをお書きください',
		'Confirm' => '確認画面',
		'Submit' => '登録',
		'Yes' => 'はい',
		'No' => 'いいえ',
		'Title' => 'タイトル',
		'Caption' => 'コメント',
		'Return' => '戻る',
		'Continue' => '次へ',
		' is already exist.' => 'はすでに存在しています',
		'Your name' => '投稿者',
		'Thank you for your comment.' => 'コメントを書き込みました。',
		'Submit following comment' => '以下の内容でコメントします。',
		'Your comment was updated.' => '内容を変更しました。',
		'Access denied' => 'あなたにはこのページにアクセスする権限がありません',
		'Error' => 'エラー',
		'mode' => 'モード',
		'Current Login' => '現在のログイン',
		'Current mode' => '現在のモード',
		'Login ID' => 'ログインID',
		'Password' => 'パスワード',
		'Login' => 'ログイン',
		'Logout' => 'ログアウト',
		'The comment was deleted.' => 'コメントを削除しました。',
		'Information was updated.' => '内容を更新しました。',
		'Update' => '更新',
		'Entry' => '登録',
	'Author' => '作成者',
	'Delete' => '削除',
	'Edit' => '編集',
	'Moderator' => '担当',
	'Edit the topic' => 'トピックの編集',
	'Action' => '行動',
	'Lock or Unlock' => 'リプライ禁止／解除',
	'The topic was updated.' => 'トピックが更新されました。',
	'The topic was locked.' => 'トピックはリプライ禁止に設定されました。',
	'The topic was unlocked.' => 'トピックのリプライ禁止は解除されました。',
	'Error: Unknown access.' => 'アクセスエラー：トップページよりアクセスしなおしてください。',
	'Please input a title.' => 'タイトルを入力してください。',
	'Please input a description.' => '内容を入力してください。',
	'Please input your nickname.' => 'ニックネームを入力してください。',
	'Please input a password.' => 'パスワードを入力してください。',
	'Please input your comment.' => 'コメントを入力してください。',
	'Please input more than 4 characters as your password.' => 'パスワードは英数字で４文字以上を入力してください。',
	'Please use alphameric characters as your password.' => 'パスワードには半角英数字を用いてください（記号不可）。',
	'(Alphameric characters)' => '(半角英数)',
	'Delete your comment' => 'コメントの削除',
	'Deleted' => 'このコメントは削除されました。',
	'A forum of the proposed name already exists.' => '指定したタイトルのフォーラムはすでに存在しています。',
	'A topic of the proposed name already exists.' => '指定したタイトルのトピックはすでに存在しています。',
	'A category of the proposed name already exists.' => '指定したタイトルのカテゴリーはすでに存在しています。',
	'A same comment already exists.' => '同じコメントをすでに投稿しています。',
	'Your message was quarantined as suspected spam.' => '禁止キーワードが含まれています。',
	'This topic was cloesd. Please make a new topic.' => 'このトピックは終了しました。新しいトピックを作成してください。',
	'This forum was cloesd. Please make a new forum.' => 'このフォーラムは終了しました。新しいトピックを作成してください。',
	'This topic is locked.' => 'このトピックはロックされています。',

		##########################################################
		'_AUTO' => 1,
		);
}
1;

