#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;
use lib("../../extlib");
use lib("../../lib");
use HTML::Template;
use CGI;
use Cwd;
use AffelioApp;
use bb;


#Initialize AFAP
our $cgi = new CGI();
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(), cgi => $cgi);
our $bb = new bb($afap);
my $tmpl;

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
# put HTML Header
print $afap->get_HTML_header("Affelio BB");
# check access
unless ($afap->check_access("super")||$afap->check_access("user")) {
	$bb->errorExit('<AF_M text="Access denied">');
}

########### Init BB ####################################################
my $mode = $afap->{cgi}->param("mode");
my $action = $afap->{cgi}->param("action");
my $t_id = $afap->{cgi}->param("t_id");
$bb->errorExit('<AF_M text="Please specify the Topic.">') if ($t_id =~ /\D/ || $t_id eq "");
my $reply_title = $afap->{cgi}->param("reply_title");
my $comment = $afap->{cgi}->param("comment");
my $pb_user = ($afap->get_visitor_info("type") eq "pb") ? "1" : "0";
my $pwd = $afap->{cgi}->param("pwd");
my $user_name = $afap->{cgi}->param("user_name");
my $afid = $afap->{cgi}->param("afid");
my $icon = $afap->{cgi}->param("icon");
if ($pb_user eq "0"){
	$user_name = $afap->get_visitor_info("nickname");
	$afid = $afap->get_visitor_info("afid");
}
$bb->errorExit('<AF_M text="This topic is locked.">') if ($bb->getColumn("SELECT lock FROM $bb->{topic_tb} WHERE topic_id=$t_id"));

########### Add new comment  ####################################################
if ($mode eq "new_comment"){
	$bb->errorExit('<AF_M text="Please input a subject.">') if($reply_title eq "");
	$bb->errorExit('<AF_M text="Please input your comment.">') if($comment eq "");
	if ($pb_user){
		$bb->errorExit('<AF_M text="Please input your nickname.">') if($user_name eq "");
		$bb->errorExit('<AF_M text="Please input a password.">') if($pwd eq "");
	}
	$tmpl = HTML::Template->new(filename => "./templates/comment.tmpl");
	$tmpl->param(
		NEW => "1",
		T_ID => $t_id,
		TITLE => $reply_title,
		COMMENT => $comment,
		USER => $user_name,
		AFID => $afid,
	);

########### Confirm comment  ####################################################
}elsif ($mode eq "confirm_comment"){
	$bb->errorExit('<AF_M text="Please input a subject.">') if($reply_title eq "");
	$bb->errorExit('<AF_M text="Please input your comment.">') if($comment eq "");
	if ($pb_user){
		$bb->errorExit('<AF_M text="Please input your nickname.">') if($user_name eq "");
		$bb->checkPwd($pwd);
	}
	if (-f "./resource/face/owner.gif"){
	$icon = "owner.gif" if ($afap->get_visitor_info("type") eq "self" && $icon eq "");
    }
	$tmpl = HTML::Template->new(filename => "./templates/comment.tmpl");
	$tmpl->param(
		CONFIRM => "1",
		T_ID => $t_id,
		PB_USER => $pb_user,
		TITLE => $reply_title,
		COMMENT_SHOW => $bb->escape($comment),
		COMMENT => $comment,
		USER => $user_name,
		AFID => $afid,
		PWD => $pwd,
		ICON => $icon,
	);

########### Submit comment  ####################################################
}elsif ($mode eq "submit_comment"){
	$bb->errorExit('<AF_M text="Please input a subject.">') if($reply_title eq "");
	$bb->errorExit('<AF_M text="Please input your comment.">') if($comment eq "");
	if ($pb_user){
		$bb->errorExit('<AF_M text="Please input your nickname.">') if($user_name eq "");
		$bb->errorExit('<AF_M text="Please input a password.">') if($pwd eq "");
	}
	$bb->addComment($t_id, $reply_title, $user_name, $afid, $comment, $pwd, $icon);

	$tmpl = HTML::Template->new(filename => "./templates/comment.tmpl");
	$tmpl->param(
		SUBMIT => "1",
		T_ID => $t_id,
	);
########### delete comment  ####################################################
}elsif ($mode eq "delete_comment"){
	my $r_id = $afap->{cgi}->param("r_id");
	$bb->errorExit('<AF_M text="Please specify the comment.">') if ($r_id =~ /\D/ || $r_id eq "");
	$tmpl = HTML::Template->new(filename => "./templates/comment.tmpl");
	#Do delete
	if ($action eq "do_delete"){
		my $reply = $bb->getReply($t_id, $r_id);
		if ($afap->get_visitor_info("type") eq "self"){
			$bb->deleteReply($t_id, $r_id);
		}else{
			if($pb_user eq "0") {
				if ($reply->{pwd} eq "" && $reply->{afid} eq $afid){
					$bb->deleteReply($t_id, $r_id);
				}else{
					$bb->errorExit('<AF_M text="Authentication error.">');
				}
			} elsif($reply->{pwd} ne ""){
				if ($pb_user){
					$bb->errorExit('<AF_M text="Please input your nickname.">') if($user_name eq "");
					$bb->checkPwd($pwd);	  
				}
				if (crypt($pwd,$reply->{pwd}) eq $reply->{pwd}){
					$bb->deleteReply($t_id, $r_id);		
				}else{
					$bb->errorExit('<AF_M text="Authentication error.">');
				}
			}
		}

		$tmpl->param(
			DONE_DELETE => "1",
			T_ID => $t_id,
		);
	# Delete mode (no action)
	}else{
		my $reply = $bb->getReply($t_id, $r_id);
		if ($afap->get_visitor_info("type") eq "self"){
			$tmpl->param(PWD => "0");
		}else{
			if ($pb_user eq "0"){
				if ($reply->{pwd} eq "" && $reply->{afid} eq $afid){
					$tmpl->param(PWD => "0");
				} else{
					$bb->errorExit('<AF_M text="Authentication error.">');
				}
			}elsif($reply->{pwd} ne ""){
				$tmpl->param(PWD => "1");
			}
		}

		$tmpl->param(
			CONFIRM_DELETE => "1",
			T_ID => $t_id,
			R_ID => $r_id,
			USER => $reply->{user},
			TITLE => $reply->{title},
			COMMENT => $reply->{comment},
			AFID => $reply->{afid},
		);
	}
} else {
	$bb->errorExit('<AF_M text="Error: Unknown access.">');
}

print $bb->translate_templateL10N( $tmpl->output );
print $afap->get_HTML_footer();
