#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;
use lib("../../extlib");
use lib("../../lib");
use HTML::Template;
use CGI;
use Cwd;
use AffelioApp;
use bb;


#Initialize AFAP
our $cgi = new CGI();
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(), cgi => $cgi);
our $bb = new bb($afap);
my $tmpl;

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
# put HTML Header
print $afap->get_HTML_header("Affelio BB");
# check access
unless ($afap->check_access("super")) {
    $bb->errorExit('<AF_M text="Access denied">');
}

########### Init BB ####################################################
my $mode = $afap->{cgi}->param("mode");
my $action = $afap->{cgi}->param("action");
my $c_id = $afap->{cgi}->param("c_id");
$bb->errorExit('<AF_M text="Please specify the category.">') if ($c_id =~ /\D/);
my $title = $afap->{cgi}->param("title");
my $description = $afap->{cgi}->param("description");
my $status = $afap->{cgi}->param("status");
my $user = $afap->{cgi}->param("user");
my $afid = $afap->{cgi}->param("afid");
my $pwd = $afap->{cgi}->param("pwd");
my $pb_user = ($afap->get_visitor_info("type") eq "pb") ? "1" : "0";
if ($pb_user eq "0"){
	$user = $afap->get_visitor_info("nickname");
	$afid = $afap->get_visitor_info("afid");
}
my $status_edit = $afap->check_access("super") ? "1" : "0";

########### Add new forum  ####################################################
if ($mode eq "add_forum"){
	$tmpl = HTML::Template->new(filename => "./templates/forum.tmpl");
	$tmpl->param(
		NEW			=> "1",
		C_ID		=> $c_id,
		TITLE		=> $title,
		DESCRIPTION	=> $description,
		PB_USER		=> $pb_user,
		AFID		=> $afid,
		USER		=> $user
	);
########### Confirm forum info ####################################################
}elsif ($mode eq "confirm_forum"){
	$bb->errorExit('<AF_M text="Please input a title.">') if ($title eq "");
	$bb->errorExit('<AF_M text="Please input a description.">') if ($description eq "");
	$bb->errorExit('<AF_M text="Please input your nickname.">') if ($user eq "");
	$bb->checkPwd($pwd) if ($pb_user eq "1");
	$tmpl = HTML::Template->new(filename => "./templates/forum.tmpl");
	$tmpl->param(
		CONFIRM		=> "1",
		C_ID		=> $c_id,
		TITLE		=> $title,
		DESCRIPTION_SHOW=> $bb->escape($description),
		DESCRIPTION	=> $description,
		PB_USER		=> $pb_user,
		AFID		=> $afid,
		PWD			=> $pwd,
		USER		=> $user
	);
########### Submit forum  ####################################################
}elsif ($mode eq "submit_forum"){
	$bb->errorExit('<AF_M text="Please input a title.">') if ($title eq "");
	$bb->errorExit('<AF_M text="Please input a description.">') if ($description eq "");
	$bb->errorExit('<AF_M text="Please input your nickname.">') if ($user eq "");
	$bb->errorExit('<AF_M text="Please input a password.">') if ($pwd eq "" && $pb_user);

	my $forum_id = $bb->addForum($c_id, $title, $description, $user, $afid, $pwd);
	$bb->updateCategoryInfo($c_id, $user, $afid);
	$tmpl = HTML::Template->new(filename => "./templates/forum.tmpl");
	$tmpl->param(
		DONE	=> "1",
		F_ID	=> $forum_id,
		MSG	=> "New forum was created.",
    );
########### edit forum  ####################################################
}elsif ($mode eq "edit_forum"){
	my $f_id = $afap->{cgi}->param("f_id");
	$bb->errorExit('<AF_M text="Please specify the forum.">') if ($f_id =~ /\D/ || $f_id eq "");
	$tmpl = HTML::Template->new(filename => "./templates/forum.tmpl");
	my $forum = $bb->getForum($f_id);
	my $auth=0;
	if ($action ne ""){
		if ($afap->get_visitor_info("type") eq "self"){
			$auth=1;
		}else{
			if($pb_user eq "0") {
				if ($forum->{pwd} eq "" && $forum->{afid} eq $afid){
					$auth=1;
				}else{
					$bb->errorExit('<AF_M text="Authentication error.">');
				}
			} elsif($forum->{pwd} ne ""){
				if ($pb_user){
					$bb->errorExit('<AF_M text="Please input your nickname.">') if($user eq "");
					$bb->checkPwd($pwd);	  
				}
				if (crypt($pwd,$forum->{pwd}) eq $forum->{pwd}){
					$auth=1;
				}else{
					$bb->errorExit('<AF_M text="Authentication error.">');
				}
			}
		}
		# Do update
		if($action eq "do_update"){
			$bb->updateForum($f_id, $title, $description, $user, $afid) if ($auth);
			$tmpl->param(
				DONE => "1",
				F_ID => $f_id,
				MSG => "The forum was updated.",
			);
		}
	# Edit mode (no action)
	}else{
		my $can_delete="";
		if ($afap->get_visitor_info("type") eq "self"){
			$tmpl->param(PWD => "0");
			$can_delete = 1;
		}else{
			if ($pb_user eq "0"){
				if ($forum->{pwd} eq "" && $forum->{afid} eq $afid){
					$tmpl->param(PWD => "0");
				} else {
					$bb->errorExit('<AF_M text="Authentication error.">');
				}
			}elsif($forum->{pwd} ne ""){
				$tmpl->param(PWD => "1");
			}
		}
		$forum->{description} =~ s/<br[^>]*>/\n/g;
		$tmpl->param(
			EDIT => "1",
			F_ID => $f_id,
			USER => $forum->{user},
			TITLE => $forum->{title},
			DESCRIPTION => $forum->{description},
			AFID => $forum->{afid},
		);
	}
}else {
	$bb->errorExit('<AF_M text="Error: Unknown access.">');
}

print $bb->translate_templateL10N( $tmpl->output );
print $afap->get_HTML_footer();
