#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;
use lib("../../extlib");
use lib("../../lib");
use HTML::Template;
use CGI;
use Cwd;
use AffelioApp;
use bb;

#Initialize AFAP
our $cgi = new CGI();
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(), cgi => $cgi);
our $bb = new bb($afap);
my $tmpl;

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
# put HTML Header
print $afap->get_HTML_header("Affelio BB");
# check access
unless ($afap->check_access("DF_access")) {
    $bb->errorExit('<AF_M text="Access denied">');
}

########### Show Category,Forum List ####################################################
my %pref = $bb->getPreference;
my @categories_param;
my @categories;
my @forums_param;
my @forums;
my $i=0;
my $j=0;
$tmpl = HTML::Template->new(filename => "./templates/index.tmpl");

@categories = $bb->getAllCategories;
$tmpl->param(
	PAGE_TITLE => $pref{'title'},
	EDITABLE => $afap->check_access("super"), 
	HAS_CATEGORY=>$#categories+1
);

foreach(@categories) {
	@forums = $bb->getAllForums($_->{category_id});
	
	foreach(@forums) {
		my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{update_time});
		$mon+=1;
		$year+=1900;
		push @forums_param,
		{
			F_ID	=>	$_->{forum_id},
			TITLE	=>	$_->{title},
			DESCRIPTION =>  $_->{description},
			USER	=>	$_->{user},
			AFID	=>	$bb->getUserURI($_->{afid}),
			TOPICS  =>  $_->{topics},
			POSTS  =>  $_->{posts},
			YEAR	=>	$year,
			MONTH	=>	$mon,
			DAY	=>	$mday,
			TIME	=>	sprintf("%02d:%02d", $hour, $min),
			LAST_USER =>$_->{last_user},
			LAST_AFID =>$bb->getUserURI($_->{last_afid}),
		};
		$j++;
	}

	push @categories_param,
	{
		FORUM => [@forums_param[$i..($j-1)]],
		TITLE	=>	$_->{title},   
		HAS_FORUM => $#forums+1,
	};
	$i=$j;
}
$tmpl->param(CATEGORIES =>\@categories_param);

########### Show 'add forum' button ####################################################
my @select_list;
foreach(@categories) {
	push @select_list,
	{
		C_ID	=>	$_->{category_id},
		TITLE	=>	$_->{title},
	};
}
$tmpl->param(SELECT_LIST =>\@select_list);

########### Output html ####################################################
print $bb->translate_templateL10N( $tmpl->output );
print $afap->get_HTML_footer();
