#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;
use lib("../../extlib");
use lib("../../lib");
use HTML::Template;
use CGI;
use Cwd;
use AffelioApp;
use bb;

##############################################
#Initialize AFAP & put header
##############################################
our $cgi = new CGI();
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(), cgi => $cgi);
our $bb = new bb($afap);
my $tmpl;

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
# put HTML Header
print $afap->get_HTML_header("Affelio BB");
# check access
unless ($afap->get_visitor_info("type") eq "self"){
    $bb->errorExit('<AF_M text="Access denied">');
}
my $mode = $afap->{cgi}->param("mode");
my $action = $afap->{cgi}->param("action");

########### Add Category  ####################################################
if ($mode eq "add_category"){
    if ($afap->get_visitor_info("type") eq "self"){
	my $title=$afap->{cgi}->param("title");
	$tmpl = HTML::Template->new(filename => "./templates/owner/add_category.tmpl");
	$tmpl->param(
	    EDIT => "1",
	    TITLE => $title,
	    USER => $afap->get_visitor_info("nickname"),
	);
    }else{
	$bb->errorExit('<AF_M text="Access denied">');
    }
########### Confirm Category  ####################################################
}elsif ($mode eq "confirm_category"){
    if ($afap->get_visitor_info("type") eq "self"){
	my $title = $afap->{cgi}->param("title");
	$tmpl = HTML::Template->new(filename => "./templates/owner/add_category.tmpl");
	$tmpl->param(
	    CONFIRM => "1",
	    TITLE => $title,
	    USER => $afap->get_visitor_info("nickname"),
	);
    }else{
	$bb->errorExit('<AF_M text="Access denied">');
    }

########### Submit Category  ####################################################
}elsif ($mode eq "submit_category"){
    if ($afap->get_visitor_info("type") eq "self"){
	my $title = $afap->{cgi}->param("title");
	my $user = $afap->get_visitor_info("nickname");
	my $afid = $afap->get_visitor_info("afid");
	#insert entry to DB

	$bb->addCategory($title, $user, $afid);
#	my $ret = $bb->getNewestCategoryId;

	$tmpl = HTML::Template->new(filename => "./templates/owner/add_category.tmpl");
	$tmpl->param(
	    SUBMIT => "1",
#	    ID => $ret->{e_id},
	);
    }else{
	$bb->errorExit('<AF_M text="Access denied">');
    }

########### Category List ####################################################
}elsif ($mode eq "list_category"){
    $tmpl = HTML::Template->new(filename => "./templates/owner/list_category.tmpl");
    $tmpl->param(access_control_URL => $afap->get_URL("access_control"));
    my @entries_param;
    my @entries;
    @entries = $bb->getAllCategories;
    $tmpl->param(has_category => '0');
    if (@entries > 0 ){
	$tmpl->param(has_category=>'1');
	foreach(@entries) {
	    push @entries_param,
	    {
		TITLE	=>	$_->{title},
		ID	=>	$_->{category_id},
	    };
	}
	$tmpl->param(ENTRIES => \@entries_param);
    }
}elsif ($mode eq "spam"){
########### Prevent a SPAM comment ####################################################
    $tmpl = HTML::Template->new(filename => "./templates/owner/spam.tmpl");
    $tmpl->param(access_control_URL => $afap->get_URL("access_control"));

    if ($action eq "add_spam_key"){
	my $spam_key = $afap->{cgi}->param("spam_key");
	$bb->addSpamkey($spam_key) if ($spam_key ne "");
    }elsif ($action eq "remove_spam_key"){
	my $spam_id = $afap->{cgi}->param("spam_keys");
	$bb->removeSpamkey($spam_id);
    }
    my @key_list;
    my @spam_keys;
    @spam_keys = $bb->getAllSpamkeys;
    $tmpl->param(HAS_KEY => '0');
    if (@spam_keys > 0 ){
	$tmpl->param(HAS_KEY=>'1');
	foreach(@spam_keys) {
	    push @key_list,
	    {
		S_ID => $_->{spam_id},
		KEYWORD	=>	$_->{keyword},
	    };
	}
	$tmpl->param(KEY_LIST => \@key_list);
    }

##############################################
# Default (Owner mode)
##############################################
}else{
    $tmpl = HTML::Template->new(filename => "./templates/owner/admin_general.tmpl");
    $tmpl->param(access_control_URL => $afap->get_URL("access_control"));
    if ($action eq "update"){
	my $title = $afap->{cgi}->param("title");
	my $email = $afap->{cgi}->param("email");
	my $max_topics = $afap->{cgi}->param("max_topics");
	my $max_comments = $afap->{cgi}->param("max_comments");
	my $num_topics = $afap->{cgi}->param("num_topics");
	my $num_comments = $afap->{cgi}->param("num_comments");
	my $max_sbjlen = $afap->{cgi}->param("max_sbjlen");
	my $max_textlen = $afap->{cgi}->param("max_textlen");

	$bb->updatePreference($title,$email,$max_topics,$max_comments,$num_topics,$num_comments,$max_sbjlen,$max_textlen);
    }
    my %pref = $bb->getPreference;

    $tmpl->param(TITLE => $pref{"title"},
		 EMAIL => $pref{"email"},
		 MAX_TOPICS => $pref{"max_topics"},
		 MAX_COMMENTS => $pref{"max_comments"},
		 NUM_TOPICS => $pref{"num_topics"},
		 NUM_COMMENTS => $pref{"num_comments"},
		 MAX_SBJLEN => $pref{"max_sbjlen"},
		 MAX_TEXTLEN => $pref{"max_textlen"},
		);
}
print $bb->translate_templateL10N( $tmpl->output );
print $afap->get_HTML_footer();
