#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;
use lib("../../extlib");
use lib("../../lib");
use HTML::Template;
use CGI;
use Cwd;
use AffelioApp;
use bb;


#Initialize AFAP
our $cgi = new CGI();
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(), cgi => $cgi);
our $bb = new bb($afap);
my $tmpl;

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
# put HTML Header
print $afap->get_HTML_header("Affelio BB");
# check access

unless ($afap->check_access("super")||$afap->check_access("user")) {
    $bb->errorExit('<AF_M text="Access denied">');
}

########### Init BB  ####################################################
my $mode = $afap->{cgi}->param("mode");
my $action = $afap->{cgi}->param("action");
my $f_id = $afap->{cgi}->param("f_id");
$bb->errorExit('<AF_M text="Please specify the forum.">') if ($f_id =~ /\D/);
my $title = $afap->{cgi}->param("title");
my $description = $afap->{cgi}->param("description");
my $status = $afap->{cgi}->param("status");
my $user = $afap->{cgi}->param("user");
my $afid = $afap->{cgi}->param("afid");
my $pwd = $afap->{cgi}->param("pwd");
my $pb_user = ($afap->get_visitor_info("type") eq "pb") ? "1" : "0";
if ($pb_user eq "0"){
	$user = $afap->get_visitor_info("nickname");
	$afid = $afap->get_visitor_info("afid");
}
my $status_edit = $afap->check_access("super") ? "1" : "0";

########### Add new topic  ####################################################
if ($mode eq "add_topic"){
	$tmpl = HTML::Template->new(filename => "./templates/topic.tmpl");
	$tmpl->param(
		NEW			=>	"1",
		F_ID		=>	$f_id,
		TITLE		=>	$title,
		DESCRIPTION	=>	$description,
		STATUS_EDIT	=>	$status_edit,
		PB_USER		=>	$pb_user,
		AFID		=>	$afid,
		USER		=>	$user
    );
########### Confirm topic  ####################################################
}elsif ($mode eq "confirm_topic"){
	$bb->errorExit('<AF_M text="Please input a title.">') if ($title eq "");
	$bb->errorExit('<AF_M text="Please input a description.">') if ($description eq "");
	$bb->errorExit('<AF_M text="Please input your nickname.">') if ($user eq "");
	$bb->checkPwd($pwd) if ($pb_user eq "1");
	my $status_str;
	if ($status eq "0"){
		$status_str = '<AF_M text="Default">';
	}elsif ($status eq "1"){
		$status_str = '<AF_M text="Sticky">';
	}elsif ($status eq "2"){
		$status_str = '<AF_M text="Announcement">';
	}    

	$tmpl = HTML::Template->new(filename => "./templates/topic.tmpl");
	$tmpl->param(
		CONFIRM		=>	"1",
		F_ID		=>	$f_id,
		TITLE		=>	$title,
		DESCRIPTION_SHOW=>	$bb->escape($description),
		DESCRIPTION	=>	$description,
		STATUS		=>	$status,
		STATUS_STR	=>	$status_str,
		STATUS_EDIT	=>	$status_edit,
		PB_USER		=>	$pb_user,
		AFID		=>	$afid,
		PWD			=>	$pwd,
		USER		=>	$user
	);
########### Submit topic  ####################################################
}elsif ($mode eq "submit_topic"){
	$bb->errorExit('<AF_M text="Please input a title.">') if ($title eq "");
	$bb->errorExit('<AF_M text="Please input a description.">') if ($description eq "");
	$bb->errorExit('<AF_M text="Please input your nickname.">') if ($user eq "");
	$bb->errorExit('<AF_M text="Please input a password.">') if ($pwd eq "" && $pb_user);

	my $icon="";
	$status=0 if (!$afap->check_access("super"));
	my $topic_id=$bb->addTopic($f_id, $title, $description, $icon,$user, $afid, $pwd, $status);

	my $current_forum = $bb->getForum($f_id);
	$bb->updateCategoryInfo($current_forum->{category_id}, $user, $afid);
	$bb->createReplyTable($topic_id);

	$tmpl = HTML::Template->new(filename => "./templates/topic.tmpl");
	$tmpl->param(
		DONE	=>	"1",
		T_ID	=>	$topic_id,
		MSG		=>	"New Topic was created.",
	);

########### Edit topic mode ####################################################
}elsif ($mode eq "edit_topic"){
	my $t_id = $afap->{cgi}->param("t_id");
	$bb->errorExit('<AF_M text="Please specify the topic.">') if ($t_id =~ /\D/ || $t_id eq "");
	$tmpl = HTML::Template->new(filename => "./templates/topic.tmpl");
	my $topic = $bb->getTopic($t_id);
	my $auth=0;
	if ($action ne ""){
		if ($afap->get_visitor_info("type") eq "self"){
			$auth=1;
		}else{
			if($pb_user eq "0") {
				if ($topic->{pwd} eq "" && $topic->{afid} eq $afid){
					$auth=1;
				}else{
					$bb->errorExit('<AF_M text="Authentication error.">');
				}
			} elsif($topic->{pwd} ne ""){
				if ($pb_user){
					$bb->errorExit('<AF_M text="Please input your nickname.">') if($user eq "");
					$bb->checkPwd($pwd);	  
				}
				if (crypt($pwd,$topic->{pwd}) eq $topic->{pwd}){
					$auth=1;
				}else{
					$bb->errorExit('<AF_M text="Authentication error.">');
				}
			}
		}
		# Do update
		if($action eq "do_update"){
			$bb->updateTopic($t_id, $title, $description, $topic->{icon}, $user, $afid,  $status, $topic->{lock}) if ($auth);
			$tmpl->param(
				DONE => "1",
				T_ID => $t_id,
				MSG => "The topic was updated.",
			);
		# Lock/unlock topic
		}elsif($action eq "lock"){
			$bb->updateTopic($t_id, $topic->{title}, $topic->{description}, $topic->{icon}, $user, $afid,  $topic->{status}, abs($topic->{lock}-1)) if ($auth);
			if ($topic->{lock}){
				$tmpl->param(MSG=>"The topic was unlocked.");
			}else{
				$tmpl->param(MSG=>"The topic was locked.");
			}
			$tmpl->param(
				DONE => "1",
				T_ID => $t_id,
			);
		# Confirm delete topic
		}elsif($action eq "confirm_delete"){
			$bb->errorExit('<AF_M text="Authentication error.">') if ($afap->get_visitor_info("type") ne "self");
			$tmpl->param(
				CONFIRM_DELETE => "1",
				T_ID => $t_id,
				F_ID => $f_id,
				MSG => "Realy?",
			);
		# Do delete
		}elsif($action eq "do_delete"){
			$bb->errorExit('<AF_M text="Authentication error.">') if ($afap->get_visitor_info("type") ne "self");
			$bb->deleteTopic($t_id,$f_id);
			$tmpl->param(
				DONE => "1",
				T_ID => $t_id,
				MSG => "The topic was removed.",
			);
		}
	# Edit topic (no action)
	}else{
		my $can_delete = "";
		if ($afap->get_visitor_info("type") eq "self"){
			$tmpl->param(PWD => "0");
			$can_delete = 1;
		}else{
			if ($pb_user eq "0"){
				if ($topic->{pwd} eq "" && $topic->{afid} eq $afid){
					$tmpl->param(PWD => "0");
				} else {
					$bb->errorExit('<AF_M text="Authentication error.">');
				}
			}elsif($topic->{pwd} ne ""){
				$tmpl->param(PWD => "1");
			}
		}
		$topic->{description} =~ s/<br[^>]*>/\n/g;
		$tmpl->param(
			EDIT => "1",
			T_ID => $t_id,
			F_ID => $f_id,
			USER => $topic->{user},
			TITLE => $topic->{title},
			DESCRIPTION => $topic->{description},
			AFID => $topic->{afid},
			SUPER => $afap->check_access("super"),
			STATUS => $topic->{status},
			CAN_DELETE => $can_delete,
		);
	}
}else {
	$bb->errorExit('<AF_M text="Error: Unknown access.">');
}

print $bb->translate_templateL10N( $tmpl->output );
print $afap->get_HTML_footer();
