#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;
use lib("../../extlib");
use lib("../../lib");
use HTML::Template;
use CGI;
use Cwd;
use AffelioApp;
use bb;


#Initialize AFAP
our $cgi = new CGI();
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(), cgi => $cgi);
our $bb = new bb($afap);
my $tmpl;

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
# put HTML Header
print $afap->get_HTML_header("Affelio BB");
# check access
unless ($afap->check_access("DF_access")) {
	$bb->errorExit('<AF_M text="Access denied">');
}

########### Init BB ####################################################

my $f_id = $afap->{cgi}->param("f_id");
$bb->errorExit('<AF_M text="Please specify the forum.">') if ($f_id =~ /\D/);
my $pb_user = ($afap->get_visitor_info("type") eq "pb") ? "1" : "0";
my $afid;
$afid = $afap->get_visitor_info("afid") if ($pb_user eq "0");
my %pref = $bb->getPreference;
$tmpl = HTML::Template->new(filename => "./templates/view_forum.tmpl");
my @topic_list;
my @topics;
my $icon;
my $last_user;
my $last_afid;
my $current_forum = $bb->getForum($f_id);
my $category = $bb->getColumn("SELECT title FROM $bb->{category_tb} WHERE category_id=$current_forum->{category_id}");
my $can_add="";
my $can_edit="";
my $opt_msg="";
$can_add=1 if ($afap->check_access("super") || $afap->check_access("user"));  

if ($pb_user eq "0"){
	if ($current_forum->{pwd} eq "" && $current_forum->{afid} eq $afid){
		$can_edit = 1;
	} 
}elsif($current_forum->{pwd} ne ""){
	$can_edit = 1;
}
$can_edit=1 if ($afap->get_visitor_info("type") eq "self");

########### Get Topic List ####################################################
@topics = $bb->getAllTopics($f_id);
if ($#topics+1 >= int($bb->getColumn("SELECT value FROM $bb->{pref_tb} WHERE key = 'max_topics'"))){
	$can_add = "";
	$opt_msg = '<AF_M text="This forum was cloesd. Please make a new forum.">';
}

########### Get current time ####################################################
my ($sec, $min, $hour, $mday, $mon, $year) = localtime($current_forum->{timestamp});
$mon+=1;
$year+=1900;

########### Set forum info ####################################################
$tmpl->param(
	PAGE_TITLE	=>	$pref{"title"},
	F_ID		=>	$f_id,
	CATEGORY	=>	$category,
	FORUM_NAME	=>	$current_forum->{title},
	FORUM_DESCRIPTION => $current_forum->{description},
	AFID		=>	$bb->getUserURI($current_forum->{afid}),
	MODERATOR	=>	$current_forum->{user},
	YEAR		=>	$year,
	MONTH		=>	$mon,
	DAY			=>	$mday,
	TIME		=>	sprintf("%02d:%02d", $hour, $min),
	CAN_ADD		=>	$can_add, 
	CAN_EDIT	=>	$can_edit,
	OPT_MSG		=>	$opt_msg,
	HAS_TOPIC	=>	$#topics+1
);

########### Set Topic List ####################################################
foreach(@topics) {
	my $abst=$_->{description};
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{update_time});
	$mon+=1;
	$year+=1900;
	if($_->{status} == 1){
		$icon="sticky";
	}elsif($_->{status} == 2){
		$icon="announce";
	}else{
		$icon="normal";
	}
	if ($_->{lock} == 1){
		$icon.="_lock";
	}
	$icon.=".gif";
	if ($_->{posts}<1) {
		$last_user=$_->{user};
		$last_afid=$_->{afid};
	}
	if (length($_->{description})>50){
		$abst = substr($_->{description},0,49)."...";
	}

	push @topic_list,
	{
		T_ID		=>	$_->{topic_id},
		TITLE		=>	$_->{title},
		ABST		=>	$abst,
		POSTS		=>	$_->{posts},
		USER		=>	$_->{user},
		AFID		=>	$bb->getUserURI($_->{afid}),
		VIEWS		=>	$_->{view},
		YEAR		=>	$year,
		MONTH		=>	$mon,
		DAY			=>	$mday,
		TIME		=>	sprintf("%02d:%02d", $hour, $min),
		LAST_USER	=>	$_->{last_user},
		LAST_AFID	=>	$bb->getUserURI($_->{last_afid}),
		ICON		=>	$icon,
	};
}

$tmpl->param(TOPIC_LIST => \@topic_list);

########### Output html ####################################################
print $bb->translate_templateL10N( $tmpl->output );
print $afap->get_HTML_footer();
