#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;
use lib("../../extlib");
use lib("../../lib");
use HTML::Template;
use CGI;
use Cwd;
use AffelioApp;
use bb;


#Initialize AFAP
our $cgi = new CGI();
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(), cgi => $cgi);
our $bb = new bb($afap);
my $tmpl;

# put Content-type
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
# put HTML Header
print $afap->get_HTML_header("Affelio BB");
# check access
unless ($afap->check_access("DF_access")) {
    $bb->errorExit('<AF_M text="Access denied">');
}

########### Init BB ####################################################
my $t_id = $afap->{cgi}->param("t_id");
$bb->errorExit('<AF_M text="Please specify the topic.">') if ($t_id =~ /\D/ || $t_id=="");
my $page = $afap->{cgi}->param("page");
$bb->errorExit('<AF_M text="Please specify the page correctly.">') if ($page =~ /\D/);
$page=0 if ($page eq "");
my $comment = $afap->{cgi}->param("comment");
my $pb_user = ($afap->get_visitor_info("type") eq "pb") ? "1" : "0";
my $user_name = $afap->{cgi}->param("user_name");
my $afid = $afap->{cgi}->param("afid");
if ($pb_user eq "0"){
    $user_name = $afap->get_visitor_info("nickname");
    $afid = $afap->get_visitor_info("afid");
}
my %pref = $bb->getPreference;
my @reply_list;
my @replies;
$bb->errorExit('<AF_M text="The topic was not found.">') if (!(my $current_topic = $bb->getTopic($t_id)));
my $current_forum = $bb->getForum($current_topic->{forum_id});
my $current_category = $bb->getCategory($current_forum->{category_id});
my $can_reply="";
my $opt_msg="";
$bb->addViewCountTopic($t_id);
$tmpl = HTML::Template->new(filename => "./templates/view_topic.tmpl");

########### Can you reply to this topic?  ####################################################
$can_reply="1" if ($afap->check_access("super") || $afap->check_access("user"));  
if ($current_topic->{lock}) {
	$can_reply = "";
	$opt_msg = '<AF_M text="This topic is locked.">';
}

########### Can you edit this topic?  ####################################################
my $can_edit="";
if ($pb_user eq "0"){
	if ($current_topic->{pwd} eq "" && $current_topic->{afid} eq $afid){
	$can_edit = 1;
	} 
}elsif($current_topic->{pwd} ne ""){
    $can_edit = 1;
}
$can_edit=1 if ($afap->get_visitor_info("type") eq "self");

########### Get current time  ####################################################
my ($sec, $min, $hour, $mday, $mon, $year) = localtime($current_topic->{timestamp});
$mon+=1;
$year+=1900;

my $rep_count = $bb->getColumn("SELECT count(reply_id) FROM reply_$t_id");
if ($rep_count >= int($bb->getColumn("SELECT value FROM $bb->{pref_tb} WHERE key = 'max_comments'"))){
	$can_reply = "";
	$opt_msg = '<AF_M text="This topic was cloesd. Please make a new topic.">';
}

########### Set page index  ####################################################
use integer;
my @page_index;
my $num_comments = $bb->getColumn("SELECT value FROM $bb->{pref_tb} WHERE key = 'num_comments'");
my $i = ($rep_count)/$num_comments;
while ($i>0){
	unshift @page_index,
	{
		page => $i,
		p_id => $i-1,
		F_ID => $current_topic->{forum_id},
		T_ID => $t_id,
	};
	$i--;
}
no integer;
@replies = $bb->getReplies($t_id, $rep_count - $page*$num_comments, $rep_count - ($page*$num_comments+$num_comments)+1);

########### Set topic info  ####################################################
$tmpl->param(
	PAGE_TITLE	=>	$pref{"title"},
	CATEGORY	=>	$current_category->{title},
	FORUM		=>	$current_forum->{title},
	F_ID		=>	$current_topic->{forum_id},
	T_ID		=>	$t_id,
	TOPIC_NAME	=>	$current_topic->{title},
	TOPIC_USER	=>	$current_topic->{user},
	TOPIC_AFID	=>	$bb->getUserURI($current_topic->{afid}),
	CAN_EDIT	=>	$can_edit,
	CAN_REPLY	=>	$can_reply, 
	PB_USER		=>	$pb_user,
	REPLY_TITLE	=>	"RE:$current_topic->{title}",
	USER_NAME	=>	$user_name,
	AFID		=>	$afid,
	COMMENT		=>	$comment,
	OPT_MSG		=>	$opt_msg,
	PAGE_INDEX	=>	\@page_index,
	YEAR		=>	$year,
	MONTH		=>	$mon,
	DAY			=>	$mday,
	TIME		=>	sprintf("%02d:%02d", $hour, $min),
	HAS_REPLY	=>	$#replies+1,
	TOPIC_DESCRIPTION => $current_topic->{description},
);

########### Set comments ####################################################
foreach(@replies) {
	my $can_edit="";
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{timestamp});
	$mon+=1;
	$year+=1900;
	if ($pb_user eq "0"){
		if ($_->{pwd} eq "" && $_->{afid} eq $afid){
			$can_edit = 1;
		} 
	}elsif($_->{pwd} ne ""){
		$can_edit = 1;
	}
	$can_edit=1 if ($afap->get_visitor_info("type") eq "self");
	$can_edit="" if ($_->{title} eq "" && $_->{user} eq "" && $_->{afid} eq "");
	my $uri = $bb->getUserURI($_->{afid}) unless ($_->{afid} eq "");

	push @reply_list,
	{
		T_ID	=>	$t_id,
		R_ID	=>	$_->{reply_id},
		TITLE	=>	$_->{title},
		USER	=>	$_->{user},
		AFID	=>	$uri,
		COMMENT	=>	$bb->autolink($_->{comment}),
		YEAR	=>	$year,
		MONTH	=>	$mon,
		DAY		=>	$mday,
		TIME	=>	sprintf("%02d:%02d", $hour, $min),
		CAN_EDIT=>	$can_edit,
		ICON	=>	$_->{icon},
	};
}
$tmpl->param(REPLY_LIST => \@reply_list);

########### Set face icons ####################################################
if ($can_reply){
	my @face_list;
	my $face_dir = './resource/face';
	opendir DIR, "$face_dir";
	my @faces  = grep(!/^\.+/, readdir DIR);
	close DIR;
    
	foreach (@faces){
		unless ($_ eq "owner.gif"){
			push @face_list,
			{
				FACE => $_
			};
		}
	}
	$tmpl->param(FACE_LIST => \@face_list);
}

########### Output html ####################################################
print $bb->translate_templateL10N( $tmpl->output );
print $afap->get_HTML_footer();
