# Copyright (C) 2006 Affelio Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

package Diary;
{
    use strict;

    ######################################################################
    #run_admin
    ######################################################################
    sub run_admin{
	my $self = shift;
	my $afap = $self->{afap};
	my $cgi = $self->{cgi};
	my $wi = $self->{wi};
	
	my %handlers = (
	    "write_diary", "WriteDiary",
	    "pref_set","PrefSet",
	    "edit_category", "EditCategory");

	###########################
	#Check access
	###########################
	unless ($afap->check_access("DF_access")) {
	    $self->accessErrorExit('Access Denied. You don\'t have permission to this application.');
	}   
	unless ($afap->get_visitor_info("type") eq "self"){
	    $self->accessErrorExit('Access Denied. You don\'t have permission to this application.');
	}
	###########################
	#Going to the owner mode
	###########################
	$afap->{af}->set_owner_mode();

	##############################################################
	#prep vars
	##############################################################
	my %output_data = ("tmpl_path", Cwd::getcwd()."/templates/");

	##############################################################
	#Model invocation
	##############################################################
	my $mode = $wi->PTN_mode($cgi->url_param("mode"));
	if ($mode eq "") {$mode="write_diary";}
	debug_print("Diary::Admin::run: mode=$mode");
	
	my $classname = "Diary::" . $handlers{$mode};
	debug_print("Diary::Admin::run: handler= $classname");
	eval "use $classname";
	if($@){
	    throw Affelio::exception::SystemException("Could not load handler [$mode]");
	}
	debug_print("Diary::Admin::run: handler function loaded.");

	my $ret="";
	try{
	    debug_print("Diary::Admin::run: handler function..... ");
	    handler($cgi, $self, \%output_data);
	    debug_print("Diary::Admin::run: handler function done.");
	}catch Error with{
	    my $e = shift;
	    $output_data{"err_msg"} .= $e->stacktrace;
	};
	    debug_print("Diary::Admin::run: $output_data{tmpl_file}");
	##############################################################
	#Output View
	##############################################################
	my $tmpl = new HTML::Template(filename => $output_data{tmpl_file},
				      die_on_bad_params => 0);
	$tmpl->param(%output_data);
	
	print "Content-type: text/html; charset=UTF-8\n";
	print "Pragma: no-cache", "\n\n";
	print $self->translate_templateL10N($self->get_HTML_header_owner("Diary:Owner mode"));
	print $self->translate_templateL10N($tmpl->output);
	print $afap->get_HTML_footer;
	
}

######################################################################
#Get_HTML_header_owner
######################################################################
sub get_HTML_header_owner{
    my $self = shift;
#    my $af = $self->{af};
    my $app__page_title = shift;

    #Set template file name
    my $TMPL_FILE = "$self->{afap}->{af}->{site__tmpldyn_dir}/_header.tmpl";
    #Set data for template
    my %output_data = ();
    $output_data{'app__css_path'} = $self->{afap}->{af}->{site__web_root}."/templates/default/owner_side";
    $output_data{'app__page_title'} = "Affelio Owner's page";
    $output_data{"site__skin_dir"} = $self->{afap}->{af}->{site__web_root} . "/skins/" . $self->{afap}->{af}->{userpref__skin};
    $output_data{'site__web_root'} = $self->{afap}->{af}->{site__web_root};
    $output_data{'site__locale'} = $self->{afap}->{af}->{site__locale};

    $self->{afap}->{af}->get_module_list(\%output_data, $self->{afap}->{af}->{site__web_root},"self");
    $self->{afap}->{af}->get_guest_owner_list(\%output_data);

    #Initiate Template
    my $tmpl = new HTML::Template( filename => $TMPL_FILE,
				   die_on_bad_params => 0);
    $tmpl->param(%output_data);

    my $menu_tmpl = new HTML::Template( filename => "./templates/admin_menu.tmpl",
				   die_on_bad_params => 0);
    $menu_tmpl->param(access_control_URL => $self->{afap}->get_URL("access_control"));
    
    my $final_out = $self->translate_templateL10N($tmpl->output)
	. '<div class="afMain">' . "\n".$self->translate_templateL10N($menu_tmpl->output);

    return($final_out);
}

}
1;
