# Copyright (C) 2006 Affelio Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package Diary;
{
    use strict;
    use Affelio::misc::Debug qw( debug_print);

    ######################################################################
    #run_getrss
    ######################################################################
    sub run_getrss{
	my $self = shift;
	my $afap = $self->{afap};
	my $cgi = $self->{cgi};

	my $wi = new Affelio::misc::WebInput();
	my $count = $wi->PTN_num($cgi->url_param("count"));
	
	debug_print("Diary::GetRss: start");

	###########################
	#Check DF_access
	###########################
	unless ($afap->check_access("DF_access")) {
	    $self->accessErrorExit('Access Denied. You don\'t have permission to this application.');
	}   

	unless ($count) { $count = 5; }
	
	my $tmpl = new HTML::Template(filename => './templates/rss.tmpl');

	my @entries = $self->getall("SELECT * FROM $self->{entry_table} ORDER BY timestamp DESC LIMIT $count");

	my @item_list;
	my @items;
	my $web_root = $self->{afap}->get_site_info('web_root');
	my $uname = $self->{afap}->get_owner_info('nickname');

	foreach (@entries) {
	    my $link = "$afap->{app__fs_root}/show_diary.cgi?id=$_->{id}";
	    push @item_list, { LINK => $link, };
	    my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{timestamp});
	    push @items, {
		TITLE	=> $_->{title},
		LINK	=> $link,
		DESCRIPTION => $_->{contents},
		DATE	=> sprintf("%4d-%02d-%02dT%02d:%02d+09:00", $year, $mon, $mday, $hour, $min),
		CREATOR	=> $uname,
		TPING	=> $web_root."$afap->{app__fs_root}/tb.cgi/$_->{id}",
	    };
	}
	
	$tmpl->param(
	    LINK	=> $web_root,
	    NICKNAME	=> $uname,
	    ITEM_LIST	=> \@item_list,
	    ITEMS	=> \@items,
	);

	print "Content-type: application/xml; charset=UTF-8\n";
	print "Pragma: no-cache", "\n\n"; 
	print $tmpl->output;

	debug_print("Diary::GetRss: end");
}

}
1;
