# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ja.pm,v 1.9 2006/03/03 12:03:48 higefuku Exp $

package Diary::L10N::ja;
{
    use strict;
    use lib("../../../../extlib");
    use lib("../../");
    use Diary::L10N;
    use Diary::L10N::en_us;
    #
    use vars qw(@ISA %Lexicon);

    sub encoding { "UTF-8" }

    @ISA = qw(Diary::L10N::en_us);

    %Lexicon = (
		##########################################################
		#Example
		##########################################################
		'_example_ENCODING_DUMMY' =>'あうほげほげ',
		'_example_check_200_err1' => '[_1] にsendmailが検出できません!',
		##########################################################
		#Add pairs...
		##########################################################
		#行末は全部カンマ入ります（全体で一つの連想配列）

		'Comments'		=> 'コメント',
		'Trackbacks'		=> 'トラックバック',
		'Edit'			=> '編集',
		'Add Diary Entry' 	=> '日記を書く',
		'Confirm' 		=> '確認',
		'Image' 		=> '画像',
		'Upload limit is less than 300KB' => 'アップロードできる画像ファイルは３００ＫＢまでです',
		'Send Trackback Ping'	=> 'Trackback Pingの送信',
		'Add'			=> '追加',
		'Modify'		=> '修正',
		'Submit'		=> '送信',
		'Edit Diary Entry' 	=> '日記の編集',
		'Remove Image'		=> 'アップロードした画像の削除',
		'Update'		=> '修正',
		'Delete Diary Entry'	=> '日記の削除', 
		'Delete'		=> '削除',
		'Do you really want to delete this entry?' => '本当に削除しますか？',
		'yes'			=> 'はい',
		'no'			=> 'いいえ',
		'Your Comment'		=> '以下の内容でコメントします',
		'Comment' 		=> 'コメント',
		'Trackback Ping-Url for this entry' => 'この記事へのTrackback Ping-URL',
		'Diary Configuration'	=> '日記の利用形態の設定',
		'Use this diary'	=> '通常の日記を利用する',
		'Import external blog'	=> '外部のＲＤＦをインポートする',
		'Apply'			=> '設定',
		'Error'			=> 'エラー',
		'An article number was not specified' => '記事番号が指定されていません',
		'The specified article does not exist' => '指定された記事は存在しません',
		'You have no permittion on this page' => 'あなたはこのページにアクセスする権限がありません',
		'Current Login ID'	=> '現在のログインＩＤ',
		'Current Mode'		=> '現在のモード',
		'Login ID'		=> 'ログインＩＤ',
		'Password'		=> 'パスワード',
		'Login'			=> 'ログイン',
		'Logout'		=> 'ログアウト',
		'Allowed HTML tags:'	=> '使用できるHTMLタグ',
		'Only href attribute is allowed in anchor tag' => 'アンカータグの中ではhref属性のみ記述できます',
		'To use this feature, you need XML::Parser module on youre system' => 'この機能を利用するにはXML::Parserモジュールが必要です',
		'Access Control'	=> 'アクセス制御',
		'Access Control Page'	=> 'アクセス制御のページへ',
		'Failed to parse RDF File' => 'RDFファイルの解析に失敗しました。不正なファイルの可能性があります',
		'Error: You may mistype a tag or forget to close it.' => 'タグを閉じ忘れたか、誤って入力しました',
		'You can only use ascii character in your file name' => 'ファイル名が日本語の場合利用できません',
		'Su'			=> '日',
		'Mo'			=> '月',
		'Tu'			=> '火',
		'We'			=> '水',
		'Th'			=> '木',
		'Fr'			=> '金',
		'Sa'			=> '土',
	'Write a diary' => '新しい記事を書く',
	'Access control' => 'アクセスコントロール',
	'General settings' => 'その他の設定',
	'Entry Archives' => '月ごとに表示',
	'Recent Entries' => '最近の記事',
	'Recent Comments' => '最近のコメント',
	'Recent Trackbacks' => '最近のトラックバック',
	'Import BLOG' => '外部のブログを取り込む',
	'Edit categories' => 'カテゴリの編集',
	'Create a new category' => '新しいカテゴリの追加',
	'Category name' => 'カテゴリの名前',
	'Title' => 'タイトル',
	'Content' => '本文',
	'Insert images'=> '画像の挿入',
	'Categories' => 'カテゴリ',
	'none' => 'その他',
	'Confirm your article' => '投稿内容の確認',
	'Image Uploader' => '画像の登録',
	'Open the uploader' => '画像登録画面を開く',
	'Preview' => '出来栄えの確認',
	'Post' => '投稿',
	'Return' => '戻る',
	'A contribution of an article was completed.' => '記事の投稿が完了しました。',
	'Edit the category name' => 'カテゴリ名の修正',
	'New category was created.' => '新しいカテゴリを作成しました。',
	'The category was updated.' => 'カテゴリが更新されました。',
	'The RDF file was unlinked.' => 'RDF設定は解除されました。',
	'RDF file was imported.' => '外部blogの利用を設定しました。',
	'Please write your comment.', => 'コメントをどうぞ',
      	'Date', => '日付',
      	'Done.', => '完了しました。',

		##########################################################
		'_AUTO' => 1,
		);
}
1;

