# Copyright (C) 2006 Affelio Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


package Diary::PrefSet;
{
    use strict;
    use Affelio::misc::Debug qw( debug_print);

    use Exporter;
    @Diary::PrefSet::ISA = "Exporter";
    @Diary::PrefSet::EXPORT = qw (show handler);


    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $diary = shift;
	my $out_ref = shift;
	
	debug_print("Diary::RdfSet::handler: start.");

	###############################
	#normal show
	###############################
	$out_ref->{tmpl_file}
	= $diary->{afap}->{app__fs_root}."/templates/rdf_set.tmpl";
	
	show($diary, $cgi, $out_ref);
	debug_print("Diary::RdfSet::handler: end.");
    }

    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $diary= shift;
	my $cgi=shift;
	my $output_ref = shift;
	debug_print("Diary::RdfSet::show start.");

	my $wi = new Affelio::misc::WebInput();
	my $action = $wi->PTN_mode($cgi->param("action"));
	my $type = $wi->PTN_mode($cgi->param("type"));
	my $url = $wi->PTN_URL($cgi->param("url"));

	if ($action eq "submit"){
	    if ($type eq 'import' && $url ne "") { 
		debug_print("Diary::RdfSet::show: Set the RDF file.");
		if ($url) {
			setRDFURL($diary, $url);
			$output_ref->{"SET_RDF"} = '<AF_M text="RDF file was imported.">';
		}
	    }	else { # normal diary
		debug_print("Diary::RdfSet::show: Unset the RDF file.");
		unsetRDFURL($diary);
		$output_ref->{"UNSET_RDF"} = '<AF_M text="The RDF file was unlinked.">';
	    }
	}

	my $rdf_url = $diary->getRDFURL;
	if ($rdf_url){
	    $output_ref->{"use_rdf"} = 'CHECKED';
	    $output_ref->{"rdf_url"} = $rdf_url; 
	}else{
	    $output_ref->{"default"} = 'CHECKED';
	}

	debug_print("Diary::RdfSet::show end.");
    }

##############################################
# setRDFURL
##############################################

sub setRDFURL {
	my ($diary, $url) = @_;
	local (*OUT);

	open(OUT, "> $diary->{datadir}url");
	print OUT $url;
	close(OUT);
}

##############################################
# unsetRDF
##############################################

sub unsetRDFURL {
	my $diary = shift;
	unlink("$diary->{datadir}url") if (-f "$diary->{datadir}url");
}

}
1;
