# Copyright (C) 2006 Affelio Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


package Diary::ReadRdf;
{
use strict;
use LWP::UserAgent;
use HTTP::Request::Common qw(POST);
use XML::Parser;
use XML::RSS;
use Affelio::misc::Debug qw( debug_print);

use Exporter;
@Diary::ReadRdf::ISA = "Exporter";
@Diary::ReadRdf::EXPORT = qw (show handler);


    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $diary = shift;
	my $out_ref = shift;
	
	debug_print("Diary::ReadRdf::handler: start.");

	###############################
	#normal show
	###############################
	$out_ref->{tmpl_file}
	= $diary->{afap}->{app__fs_root}."/templates/external_blog.tmpl";
	
	show($diary, $cgi, $out_ref);
	debug_print("Diary::ReadRdf::handler: end.");
    }

    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $diary= shift;
	my $cgi=shift;
	my $output_ref = shift;
	debug_print("Diary::ReadRdf::show start.");

	my $urlfile = $diary->{datadir}.'url';
	my $rssfile = $diary->getRDFURL;

# send request 
	my $req = new HTTP::Request(GET => $rssfile);
	my $ua  = new LWP::UserAgent;
	my $res = $ua->request($req);
	my $str;
	if ($res->is_success) {
	    $str = $res->content;
	    $str =~ s/&/&amp;/g; # escape '&'
	}
	else {
	    unlink($urlfile) if (-f $urlfile);
	    $diary->errorExit("Failed to get RDF File");
	    debug_print("Diary::ReadRdf::show Failed to get RDF.");
	}

	my $rss = new XML::RSS;
	unless (eval { $rss->parse($str); }) {
#	    $diary->unsetRDFURL;
	    unlink($urlfile) if (-f $urlfile);
	    $diary->errorExit("Failed to parse RDF File");
	    debug_print("Diary::ReadRdf::show Failed to parse RDF.");
	}

	my @entries;
	my @entry_list;
	my $i = 0;
	foreach (@{ $rss->{items} }) {
	    push @entries, {
		TITLE	=> $_->{'title'},
		LINK	=> $_->{'link'},
		CONTENTS=> &escape_html($_->{'description'}),
		DATE	=> $_->{dc}->{'date'},
	    };
	    push @entry_list, {
		TITLE	=> $_->{'title'},
		LINK	=> $_->{'link'},
	    };
	    last if (++$i >= 10);
	}
#	$output_ref->{WRITABLE} = $writable;
	$output_ref->{WRITABLE} = '0';
	$output_ref->{RSS_URL} = $rssfile;
	$output_ref->{TITLE_MAIN} = $rss->channel('title');
	$output_ref->{LINK_MAIN} = $rss->channel('link');
	$output_ref->{ENTRIES} = \@entries;
	$output_ref->{ENTRY_LIST} = \@entry_list;

	debug_print("Diary::ReadRdf::show end.");
    }

sub escape_html {
    my $html = shift;
    
    if ($html =~ /&lt;/) {
	$html =~ s/&lt;(.*)&gt;//g;
	$html =~ s/&amp;/&/g;
	$html =~ s/&(quot|apos);/"/g;
    }
    
    $html =~ s/&/&amp;/g;
    $html =~ s/"/&quot;/g;
    $html =~ s/'/&#039;/g;
    $html =~ s/<[^>]*>//g;
    $html =~ s/</&lt;/g;
    $html =~ s/>/&gt;/g;
    return $html;
}


}
1;
