# Copyright (C) 2006 Affelio Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

package Diary::ShowDiary;
{
use strict;
use Affelio::misc::Debug qw( debug_print);

use Exporter;
@Diary::ShowDiary::ISA = "Exporter";
@Diary::ShowDiary::EXPORT = qw (show handler);


    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $diary = shift;
	my $out_ref = shift;
	
	debug_print("Diary::ShowDiary::handler: start.");


	###############################
	#normal show
	###############################
	$out_ref->{tmpl_file}
	= $diary->{afap}->{app__fs_root}."/templates/show_diary.tmpl";
	
	show($diary, $cgi, $out_ref);
	debug_print("Diary::ShowDiary::handler: end.");
    }

    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $diary= shift;
	my $cgi=shift;
	my $output_ref = shift;
	debug_print("Diary::ShowDiary::show start.");

	my $wi = new Affelio::misc::WebInput();
	my $id = $wi->PTN_num($cgi->url_param("id"));
	if($diary->{afap}->check_access("write_comment")){
	    $output_ref->{COMMENT_WRITE} = '1';
        }

#my $id = $afap->{cgi}->param('id') or $diary->errorExit("An article number was not specified");
	$diary->errorExit("The specified article does not exist") unless existsEntry($diary,$id);

	debug_print("Diary::ShowDiary::get diary. $id");
	my $category="";
	my $entry = getEntry($diary,$id);
	my ($sec, $min, $hour) = localtime($entry->{timestamp});
	debug_print("Diary_test::ShowDiary::show cate1.");
	my $query="select category from $diary->{category_table} where id=$entry->{c_id}";
	eval{
	    my $sth = $diary->{dbh}->prepare($query);
	    $sth->execute;
	};
	if (!$@){
	    $category = $diary->getColumn("select category from $diary->{category_table} where id=$entry->{c_id}");
	}
	debug_print("Diary::ShowDiary::get diary. $entry->{title}");

	my $images="";
	if (!($entry->{contents} =~ s/<image=\"([A-Za-z0-9\-\_]*\.(jpg|png|gif|bmp|jpeg))\">/<a href=\"show_image.cgi\?id=$entry->{id}&filename=$1&size=l\"><img src=\"show_image.cgi\?id=$entry->{id}&filename=$1&size=s\" border=\"0\"><\/a>/ig)){
	    $images=getUploadedImages($diary, $entry->{id}, 300, 300);
	}

	$output_ref->{"ID"} = $entry->{id};
	$output_ref->{"CATEGORY"} = $category;
	$output_ref->{"MONTH"} = $entry->{month};
	$output_ref->{"DAY"} = $entry->{day};
	$output_ref->{"HOUR"} = $hour;
	$output_ref->{"MIN"} = $min;
	$output_ref->{"TITLE"} = $entry->{title};
	$output_ref->{"CONTENTS"} = $entry->{contents};
	$output_ref->{"IMAGES"} = $images;
	$output_ref->{"USERNAME"} = $entry->{user};

# Comment
if($diary->getCommentsNo($id) > 0) {
	$output_ref->{"HAS_COMMENTS"} = "1";
	my @comments_param;
	my @comments = getComments($diary, $id);
	foreach(@comments) {
		my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{timestamp});
		$mon += 1;

		push @comments_param,
		{
			UNAME => $_->{user},
			COMMENT_TIME => "$mon月$mday日 $hour時$min分",
			COMMENT => $_->{comment}
		};
	}
	$output_ref->{"COMMENTS"} = \@comments_param;
}

	$output_ref->{"install_title"} = $diary->{afap}->get_app_info("install_title");
	debug_print("Diary::ShowDiary::show end.");
    }
}



##############################################
# getEntry
##############################################

sub getEntry {
	my $diary = shift;
	my $id   = $diary->escape(shift, 'int');
	my @ret = $diary->getall("SELECT * FROM $diary->{entry_table} WHERE id = $id");
	return $ret[0];
}


##############################################
# existsEntry
##############################################

sub existsEntry {
	my $diary = shift;
	my $id   = $diary->escape(shift, 'int');
	return $diary->getColumn("SELECT COUNT(*) FROM $diary->{entry_table} WHERE id = $id") > 0;
}

##############################################
# getComments
##############################################

sub getComments {
	my $diary = shift;
	my $id   = $diary->escape(shift, 'int');
	return $diary->getall("SELECT * FROM $diary->{comment_table} WHERE id = $id ORDER BY timestamp");
}


##############################################
# getCommentsNo
##############################################

#sub getCommentsNo {
#	my $diary = shift;
#	my $id   = $diary->escape(shift, 'int');
#	return $diary->getColumn("SELECT count(*) FROM $diary->{comment_table} WHERE id = $id");
#}

##############################################
# getTrackbacksNo
##############################################

sub getTrackbacksNo {
	my $diary = shift;
	my $id   = $diary->escape(shift, 'int');
	return $diary->getColumn("SELECT COUNT(*) FROM $diary->{tb_table} WHERE id = $id");
}

##############################################
# getUploadedImages
##############################################

sub getUploadedImages {
	my ($diary, $id, $width, $height) = @_;

	$width  = "&w=$width" if ($width);
	$height = "&h=$height" if ($height);
	
	my $imgdir = "$diary->{datadir}img/$id/";
	my $ret;
	
	local (*DIR);
	opendir(DIR, $imgdir);
	while (my $file = readdir(DIR)) {
		if (-f $imgdir.$file) {
			$ret .= "<a href=\"show_image.cgi?id=$id&filename=$file\" target=\"_blank\">".
			"<img src=\"show_image.cgi?id=$id&filename=$file$width$height\" border=\"0\" />".
			"</a><br />";
		}
	}
	closedir(DIR);

	return $ret ? "<p>$ret</p>" : "";
}

1;
