# Copyright (C) 2006 Affelio Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

package Diary::ShowTb;
{
use strict;
use Jcode;
use lib("../../../extlib/");
use lib("../../../lib/");
use Diary::L10N;
use DBI;
use LWP::UserAgent;
use HTTP::Request::Common qw(POST);
use AffelioApp;
#use HTML::Template;
#use CGI;
use Cwd;
    use Affelio::misc::Debug qw( debug_print);
    use Affelio::misc::WebInput;
    use Affelio::exception::SystemException;
    use Error qw(:try);

    use Exporter;
    @Diary::ShowTb::ISA = "Exporter";
    @Diary::ShowTb::EXPORT = qw (show handler);


    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $diary = shift;
	my $out_ref = shift;
	
	debug_print("Diary::ShowTb::handler: start.");


	###############################
	#normal show
	###############################
	$out_ref->{tmpl_file}
	= $diary->{afap}->{app__fs_root}."/templates/show_trackback.tmpl";
	
	show($diary, $cgi, $out_ref);
	debug_print("Diary::ShowTb::handler: end.");
    }

    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $diary= shift;
	my $cgi=shift;
	my $output_ref = shift;
	debug_print("Diary::Showtb::show start.");

	my $wi = new Affelio::misc::WebInput();
	my $id = $wi->PTN_num($cgi->url_param("id"));

	my @ts = getTrackbacks($diary,$id);
	my @trackbacks;
	foreach (@ts) {
	    my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{timestamp});
	    $year += 1900; $mon += 1;
	    push @trackbacks, {
		TITLE		=> $diary->escape($_->{title}),
		BLOG_NAME	=> $diary->escape($_->{blog_name}),
		URL		=> $_->{url},
		EXCERPT		=> $_->{excerpt},
		DATE		=> "$year/$mon/$mday $hour:$min",
	    };
	}

	$output_ref->{PING_URL} = $diary->{afap}->{af}->{site__web_root}."/apps/$diary->{afap}->{install_name}/tb.cgi/$id";
	$output_ref->{TRACKBACKS} =\@trackbacks;
	debug_print("Diary::Showtb::show end.");
}

##############################################
# getTrackbacks
##############################################

sub getTrackbacks {
	my $diary = shift;
	my $id   = shift;
	my @ret  = $diary->getall("SELECT * FROM $diary->{tb_table} WHERE id = $id");
#	reset (@ret);
	return @ret;
}

##############################################
# getURLDescription
##############################################

#sub getURLDescription {
#	my $self	= shift;
#	my $id		= shift
	
#	my ($entry) = $self->getall("SELECT * FROM $self->{entry_table} WHERE id = $id");
#	my $tmpl = new HTML::Template(filename => "./templates/tpingrdf.tmpl");
#	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($entry->{timestamp});
#	$year += 1900; $mon += 1;
	
#	$tmpl->param(
#		TITLE => $entry->{title},
#		TURL => "$self->{afap}->{af}->{site__web_root}/apps/$self->{afap}->{install_name}/tb/tb.cgi/$id",
#		IDENT => "$self->{afap}->{af}->{site__web_root}/apps/$self->{afap}->{install_name}/show_diary.cgi?id=$id",
#		DESCRIPTION => $entry->{contents},
#		CREATOR => $self->{afap}->{af}->{user__nickname},
#		DATE => sprintf("%4d-%02d-%02dT%02d:%02d+09:00", $year, $mon, $mday, $hour, $min),
#	);

#	return $tmpl->output;
#}

}
1;
