# Copyright (C) 2006 Affelio Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


package Diary::WriteComment;
{
use strict;
use Affelio::misc::Debug qw( debug_print);

use Exporter;
@Diary::WriteComment::ISA = "Exporter";
@Diary::WriteComment::EXPORT = qw (show handler);


    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $diary = shift;
	my $out_ref = shift;
	
	debug_print("Diary::WriteComment::handler: start.");

	###############################
	#normal show
	###############################
	$diary->checkAccess('write_comment');
	
	show($diary, $cgi, $out_ref);
	debug_print("Diary::WriteComment::handler: end.");
    }

    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $diary= shift;
	my $cgi=shift;
	my $output_ref = shift;
	debug_print("Diary::WriteComment::show start.");

	my $wi = new Affelio::misc::WebInput();
	my $id = $wi->PTN_num($cgi->param("id"));
	my $sub_mode = $wi->PTN_mode($cgi->param("action"));
	my $comment = $cgi->param("comment");

	$diary->errorExit('An article number was not specified') if (!$id);	
	$diary->errorExit("The specified article does not exist") unless $diary->existsEntry($id);
	my $user = $diary->{afap}->get_visitor_info("nickname");

	###############################
	#arg
	###############################
#	try{
	    if( $sub_mode eq "confirm" ){
		debug_print("Diary::WriteComment::show: before confirm");
		$output_ref->{tmpl_file} = $diary->{afap}->{app__fs_root}."/templates/write_comment_confirm.tmpl";
		$output_ref->{"COMMENT_SHOW"} = $diary->escape($comment);
		$output_ref->{"COMMENT"} = $comment;
		$output_ref->{"ID"} = $id;
		$output_ref->{"REQUIRE_NAME"} = 1 unless ($user);
		debug_print("Diary::WriteComment::show: after confirm");
	    }
	    elsif($sub_mode eq "commit") {
		$output_ref->{tmpl_file} = $diary->{afap}->{app__fs_root}."/templates/write_comment.tmpl";
		$output_ref->{"COMMIT"} = 1;
		$output_ref->{"ID"} = $id;

		if(!$user){
		    $user = escape_comment($diary,$cgi->param('visitor_name'));
		}else{
		    my $url = $diary->{afap}->get_visitor_info('afid');
		if ($url =~ /<a href="([^"]*)"/) {
			$url = $1;
		}

		$url = $diary->{afap}->get_site_info('web_root').'/outgoing.cgi?dest_url='.$url;
		$user = "<a href=\"$url\">".$diary->{afap}->get_visitor_info("nickname")."</a>";
	    
		    try {
			addComment($diary, $id, $user, $comment);
		    }
		    catch Error with {
			my $e = shift;
			$output_ref->{err_msg} .= $e->stacktrace . '<BR>';
		    }
		}	    
		debug_print("Diary::WriteComment::show end.");
	    }
}
#		print $diary->getRedirection("show_diary.cgi?id=$id");
#		exit;
#	    else {
#		$diary->errorExit('Invalid Access');
#	    }


##############################################
# addComment
##############################################

sub addComment {
	my $diary    = shift;
	my $id      = $diary->escape(shift, 'int');
	my $user    = shift;
	my $comment = $diary->escape(shift);
	my $time    = time;
	
	my @same = $diary->getall("SELECT id FROM $diary->{comment_table} WHERE user = '$user' AND comment = '$comment'");
	if($#same >= 0) { return; }
	
	$diary->{dbh}->do("INSERT INTO $diary->{comment_table} VALUES ($id, '$user', '$comment', $time)");
}

sub escape_comment {
	my ($diary, $str) = @_;

	$str =~ s/[\t\a]//g;
	$str =~ s/&/&amp;/g;
	$str =~ s/['"]/&quot;/g;
	$str =~ s/</&lt;/g;
	$str =~ s/>/&gt;/g;
	$str =~ s/(\r\n|\r|\n)/<br \/>/g;

	return $str;
}

}
1;
