#!/usr/bin/perl 

use strict;

#use CGI qw(-unique_headers);
use strict;
use CGI;
use Cwd;
use DBI;
use lib("../../../extlib");
use lib("../../../lib");
#use HTML::Template;
use AffelioApp;
use Affelio::Managing::ProfileManager;
use Affelio::Managing::ApplicationManager;
#use Affelio;
use Affelio::misc::Debug qw(debug_print);
use Error qw(:try);

our $cgi = new CGI();

#########################################################################
#1st screen
#########################################################################
if($cgi->url_param("mode") ne "go"){
    print "Content-type: text/html; charset=UTF-8\n";
    print "Pragma: no-cache", "\n\n"; 
    print <<EOM;
<HTML>
<h1>Upgrade Script from Diary1.x to 2.0</h1>
<P>
<H2>2. Upgrade your Affelio Diary</H2>
Push the button below and upgrade your data!
<P>
<FORM ACTION="./index.cgi?mode=go" method=POST>
<INPUT TYPE="submit" VALUE="Upgrade">
</FORM>
</HTML>
EOM
exit(1);


#########################################################################
#Do upgrade
#########################################################################
}else{
#Initialize AFAP
    print "Content-type: text/html; charset=UTF-8\n";
    print "Pragma: no-cache", "\n\n"; 

    ################################
    #Start Affelio
    ################################
    our $afap;
    try{
	chdir '..';
	my $dir = getcwd();
	chdir 'upgrade';
	$afap = new AffelioApp(ConfigDir => $dir, cgi => $cgi);
    }catch Error with{
	my $e = shift;
	print("AffelioApp load error.\n" . $e->stacktrace);
	exit(1);
    };
    my $dbh = $afap->get_userdata_dbh();

    ################################
    #Create tables
    ################################
    my $pref_table = "diary_$afap->{install_name}_pref";

    {
	my $query = "SELECT * from $pref_table";
        my $sth;
	eval{
	    $sth = $dbh->prepare($query);
	    $sth->execute;
	};
	if($@){
	    print "We confirmed that the app table does not exist.<BR>";
	    print "So, We will make it<BR>";
	    my $query = "CREATE TABLE $pref_table (key TEXT, value TEXT)";
            my $sth;
	    eval{
		$sth = $dbh->prepare($query);
		$sth->execute;
	    };
	    if($@){
		print 'Error occured in creating the table<BR><BR>' .  $@;
		exit(1);
	    }
	    #Insert initial data.
	    $dbh->do("INSERT INTO $pref_table (key, value) VALUES ('email', '$afap->{af}->{user__email1}')");
	    $dbh->do("INSERT INTO $pref_table (key, value) VALUES ('max_entries', '10000')");
	    $dbh->do("INSERT INTO $pref_table (key, value) VALUES ('max_comments', '256')");
	    $dbh->do("INSERT INTO $pref_table (key, value) VALUES ('max_commentlen', '1000')");
	    $dbh->do("INSERT INTO $pref_table (key, value) VALUES ('max_textlen', '10000')");
	    $dbh->do("INSERT INTO $pref_table (key, value) VALUES ('show_author', '0')");
	    $dbh->do("INSERT INTO $pref_table (key, value) VALUES ('image_size', '300')");
	}else{
	    #Application table already exists.
	    #So, do nothing.
	    print 'We confirmed that the app table already exists.<BR>';
	    print 'So, We will do nothing.<BR>';
	}
    }#block


    ################################
    #Create application table
    ################################
    my $category_table = "diary_$afap->{install_name}_categories";

    {
	my $query = "SELECT * from $category_table";
        my $sth;
	eval{
	    $sth = $dbh->prepare($query);
	    $sth->execute;
	};
	if($@){
	    print "We confirmed that the app table does not exist.<BR>";
	    print "So, We will make it<BR>";
	    my $DBConfig = Config::Tiny->new();
	    $DBConfig = Config::Tiny->read("$afap->{af}->{site__user_dir}/db.cfg");
	    my $dbtype = $DBConfig->{db}->{type};
	    my $pkey_modifier = $dbtype eq 'mysql' ? " AUTO_INCREMENT PRIMARY KEY " : " PRIMARY KEY ";
	    my $query = "CREATE TABLE $category_table (id INTEGER $pkey_modifier ,category TEXT)";
            my $sth;
	    eval{
		$sth = $dbh->prepare($query);
		$sth->execute;
	    };
	    if($@){
		print 'Error occured in creating the table<BR><BR>' .  $@;
		exit(1);
	    }
	    #Insert initial data.
	    $dbh->do("INSERT INTO $category_table (id, category) VALUES (NULL, 'その他')");
	}else{
	    #Application table already exists.
	    #So, do nothing.
	    print 'We confirmed that the app table already exists.<BR>';
	    print 'So, We will do nothing.<BR>';
	}
    }#block



    ################################
    #Add columns
    ################################
    my $entry_table = "diary_$afap->{install_name}_entries";
    add_column($dbh, $entry_table, 'c_id', "INTEGER");
    add_column($dbh, $entry_table, 'user', "TEXT");
    add_column($dbh, $entry_table, 'uri', "TEXT");
    add_column($dbh, $entry_table, 'pwd', "TEXT");
    add_column($dbh, $entry_table, 'draft', "INTEGER");

   ################################
    #Update tables
    ################################
    update_table($dbh, $entry_table, "c_id", "1", "NULL", "INTEGER");
    update_table($afap->{af}->getDB, "AFuser_CORE_apps", "guest_index", "index.cgi", "list_diary.cgi", "TEXT","app_name","diary");
    update_table($afap->{af}->getDB, "AFuser_CORE_apps", "owner_index", "admin.cgi", "owner.cgi", "TEXT","app_name","diary");
    update_table($afap->{af}->getDB, "AFuser_CORE_apps", "app_version", "2.0", "1.0", "TEXT");
    update_table($afap->{af}->getDB, "AFuser_CORE_apps", "app_version", "2.0", "1.1", "TEXT");

    print "Done.<BR>";

    print '<h2>OK. Successfuly done.</H2><P><B>Delete this CGI immediately!!</B>';
    exit(1);
}



sub add_column{
    my $dbh= shift;
    my $table = shift;
    my $col = shift;
    my $type = shift;
    my $def = shift;

    my $query = "SELECT $col from $table";
    my $sth;
    eval{
	$sth = $dbh->prepare($query);
	$sth->execute;
    };
    if($@){
	print "We confirmed that table [$table] needs column [$col]<BR>";
	my $query2 = "ALTER TABLE $table ADD COLUMN $col $type";
	my $sth;
	eval{
	    $dbh->do($query2);
	};
	if($@){
	    print 'Error occured in modifying the table<BR><BR>' .  $@;
	    exit(1);
	}
	print "Successfully added [$col].<BR>";
	
    }else{
	#Application table already exists.
	#So, do nothing.
	print "We confirmed that table [$table] already has [$col]<BR>"; 
	print 'So, We will do nothing.<BR>';
    }
}


sub update_table{
    my $dbh= shift;
    my $table = shift;
    my $col = shift;
    my $value = shift;
    my $current = shift;
    my $type = shift;
    my $col2 = shift;
    my $current2 = shift;

    my $query;
    if ($type eq "INTEGER"){
	$query = "SELECT * from $table WHERE $col = $current";
    }else{
	$query = "SELECT * from $table WHERE $col = '$current'";
    }
    if ($col2 ne "" && $current2 ne""){
	$query.= " AND $col2 = '$current2'";
    }
#    print $query;
    my $sth;
    eval{
	$sth = $dbh->prepare($query);
	$sth->execute;
    };
    my $row=0;
    while(my @tmp= $sth->fetchrow_array){
	$row++;
    }
    $sth->finish;

    if($row>0){
	my $query2;
	print "We confirmed that table [$table] needs update [$col]<BR>";
	if ($type eq "INTEGER"){
	    $query2 = "UPDATE $table SET $col = $value WHERE $col = $current";
	}else{
	    $query2 = "UPDATE $table SET $col = '$value' WHERE $col = '$current'";
	}
	if ($col2 ne "" && $current2 ne""){
	    $query2.= " AND $col2 = '$current2'";
	}
#    print $query2;
	my $sth;
	eval{
	    $dbh->do($query2);
	};
	if($@){
	    print 'Error occured in modifying the table<BR><BR>' .  $@;
	    exit(1);
	}
	print "Successfully update [$col].<BR>";
	
    }else{
	#Application table already exists.
	#So, do nothing.
	print "We confirmed that table [$table] was updated<BR>"; 
	print 'So, We will do nothing.<BR>';
    }
}
