# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: AccessLog.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::AccessLog;
{
    use strict;

    use lib("../../../../../extlib/");
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Time;
    use Affelio::misc::WebInput;

    use Exporter;
    @Affelio::App::Standalone::Admin::AccessLog::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::AccessLog::EXPORT = qw (show handler);

    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $af = shift;
	my $out_ref = shift;
	
	$out_ref->{tmpl_file}
	= "$af->{site__tmpl_dir}/owner_side/admin_access_log.tmpl";

	show($af,$cgi,$out_ref);
    }

    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $af= shift;
	my $q=shift;
	my $output_ref = shift;
	my $wi = new Affelio::misc::WebInput;

	debug_print("StandAlone::AccessLog::show start.");

	my @access_log=();
	$output_ref->{"access_log"} = \@access_log;

	###############################
	#begin and end
	###############################
	my $t_begin= $wi->PTN_num( $q->url_param("t_begin") );
	my $t_end= $wi->PTN_num( $q->url_param("t_end") );

	if($t_begin == 0){
	    $t_begin = "20050620000000";
	}
	if($t_end == 0){
	    $t_end = get_timestamp();
	}

	###############################
	#View
	###############################
	my $view= $wi->PTN_mode( $q->url_param("view") );

	###############################
	#Create link URLs
	###############################
	$output_ref->{"f1_log_URL"} = "admin.cgi?mode=accesslog&view=f1";
	$output_ref->{"f2_log_URL"} = "admin.cgi?mode=accesslog&view=f2";
	$output_ref->{"affelio_log_URL"} = "admin.cgi?mode=accesslog&view=affelio";
	$output_ref->{"pb_log_URL"} = "admin.cgi?mode=accesslog&view=pb";
	$output_ref->{"all_log_URL"} = "admin.cgi?mode=accesslog";

	###############################
	#Access to AccessLog Manager
	###############################
	my $result = $af->getALM->get_log(t_begin => $t_begin,
					  t_end => $t_end,
					  view => $view);

	###############################
	#Parse result
	###############################
	while( my ($id, $id2, $time, $nickname, $afid, $type) = $result->fetchrow_array ){

	    my $true_name;
	    if($afid =~ /^http:\/\//){
		##########
		#Friend!
		##########
		$true_name = '<A HREF="' . $af->{site__web_root} . "/outgoing.cgi?dest_url=" . $afid . '" target="_blank">' . $nickname . '</A>';
	    }else{
		##########
		#Anonymous
		#afid = remote host
		##########
		my $len = length($afid);
		if($len > 20){
		    $true_name = '<SPAN TITLE="' . $afid . '">...' . substr($afid, $len-20, 20) . '</SPAN>';
		}else{
		    $true_name = $afid;
		}
	    }

	    if($id2 ==0 ){ $id2="";} 

	    my $true_type; 
	    if($type eq "pb") {$true_type='<AF_M text="_VISITOR_TYPE_PB">';}
	    if($type eq "f2") {$true_type='<AF_M text="_VISITOR_TYPE_F2">';}
	    if($type eq "f1") {$true_type='<AF_M text="_VISITOR_TYPE_F1">';}
	    if($type eq "self") {$true_type='<AF_M text="_VISITOR_TYPE_SELF">';}
	    push(@access_log, {id=> $id,
			       id2=> $id2,
			       time=> timestamp2stringB($time),
			       nickname => $true_name,
			       type => $true_type});
	}

	debug_print("StandAlone::AccessLog::show end.");
    }


}
1;
