# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: AffelioNews.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::AffelioNews;
{
    use strict;

    use lib("../../../../../extlib/");
    use Error qw(:try);
    use Fcntl;
    use LWP::Simple 'get';
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::WebInput qw(delete_HTML);
    use Affelio::exception::IOException;
    use Affelio::misc::Time;

    use Exporter;
    @Affelio::App::Standalone::Admin::AffelioNews::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::AffelioNews::EXPORT = qw (getnews getRSS);

    #######################################################################
    #getRSS
    #######################################################################    
    sub getRSS{
	my $af = shift;

	if(-e "$af->{site__user_dir}/AffelioNews/"){
	}else{
	    mkdir("$af->{site__user_dir}/AffelioNews/");
	    if($@){
		throw Affelio::exception::IOException("Cannot make directory for AffelioNews!");
	    }
	}

	#Load last-updated time
	my $updated_time =0;
	my $cur_time = get_timestamp();
	sysopen(IN, "$af->{site__user_dir}/AffelioNews/update", O_RDONLY);
	if($@){
	}else{
	    $updated_time = <IN>;
	    if($cur_time < $updated_time + 10000){  #1h
		return;
	    }
	}
	close(IN);

	my $url = "http://home1.affelio.jp/affelio_news/" 
	    . $af->{site__locale} . "/index.txt";
	if($af->{site__locale} eq "en_us"){
	    $url = "http://affelio.us/affelio_news/en_us/index.txt";
	}

	my $data = LWP::Simple::get($url);
	if($@){
	    #throw Affelio::exception::NetworkException("Network connection error to affelio web site");
	    return();
	}

	sysopen(OUT, "$af->{site__user_dir}/AffelioNews/news.html", 
		O_WRONLY|O_CREAT|O_TRUNC);
	
	my @elements = split('\n', $data);
	my $size = @elements;
	my $index=0;
	my $hot_flg=0;
	while($index < $size){
	    my $datetime_row = $elements[$index];
	    
	    if($cur_time < ($datetime_row*100 + 3000000) ){   #3days :P
		$hot_flg=1;
	    }else{
		$hot_flg=0;
	    }

	    my $datetime = timestamp2string($elements[$index++]);
	    my $type = $elements[$index++];
	    my $title = $elements[$index++];
	    my $url = $elements[$index++];

	    print OUT "<TR><TH>$datetime</TH><TD><A HREF=\"$url\" target=\"_blank\">";
	    if($hot_flg == 1){
		print OUT '<FONT color="red"><B>';
	    }
	    print OUT "$title";
	    if($hot_flg == 1){
		print OUT '</B></FONT>';
	    }
	    print OUT "</A></TD></TR>";

	}

	print OUT "\n\0";
	close(OUT);

	#Record current time
	sysopen(OUT, "$af->{site__user_dir}/AffelioNews/update", 
		O_WRONLY|O_CREAT|O_TRUNC);
	print OUT $cur_time;
	close(OUT);
    }

    #######################################################################
    #getnews
    #######################################################################    
    sub getnews{
	my $af = shift;
	my $output_ref = shift;

	getRSS($af);

	sysopen(IN, "$af->{site__user_dir}/AffelioNews/news.html", 
		O_RDONLY);
	if(!$@){
	    $output_ref->{"AffelioNews"} = <IN>;
	}
	close(IN);
    }


}
1;
