# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ConfigAffelio.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::ConfigAffelio;
{
    use strict;

    use lib("../../../../../extlib/");
    use Error qw(:try);
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::MyCrypt;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Time qw(timestamp2string);
    use Affelio::misc::WebInput;
    use Affelio::exception::InvalidInputException();

    use Exporter;
    @Affelio::App::Standalone::Admin::ConfigAffelio::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::ConfigAffelio::EXPORT = qw (handler show configure);

    #######################################################################
    #handler
    #######################################################################    
    sub handler{
	my $cgi = shift;
	my $af = shift;
	my $out_ref = shift;

	my $ret_msg="";

	my $wi = new Affelio::misc::WebInput();
    
	my $sub_mode = $wi->PTN_mode($cgi->url_param("action"));
	try{
	    if($sub_mode eq "submit" ){
		$ret_msg = configure($af, $cgi);
	    }
	}catch Error with{
	    my $e = shift;
	    $out_ref->{err_msg} .= $e->stacktrace . '<BR>';
	};
	$out_ref->{ret_msg} = $ret_msg;

	$out_ref->{tmpl_file} 
	= "$af->{site__tmpl_dir}/owner_side/admin_affelio_config.tmpl";

	show($af,$out_ref);
    }


    #######################################################################
    #configure
    #######################################################################    
    sub configure{
	my $af= shift;
	my $cgi = shift;

	debug_print("StandAlone::Config::conf: start.");
	my $wi = new Affelio::misc::WebInput;
	
	##############################################
	#Password
	##############################################
	my $old_password = $wi->PTN_through($cgi->param("old_password"));
	my $new_password1 = $wi->PTN_through($cgi->param("new_password1"));
	my $new_password2 = $wi->PTN_through($cgi->param("new_password2"));
	debug_print("StandAlone::Config::conf: old_pw = [$old_password]");
	debug_print("StandAlone::Config::conf: new_pw1 = [$new_password1]");
	debug_print("StandAlone::Config::conf: new_pw2 = [$new_password2]");

	if($old_password ne ""){
	    if(  verify_password($old_password, $af->{site__password}) < 1) {
		return('<AF_M text="Current password is not correct.">');
	    }
	    
	    if(length($new_password1) < 8){
		return('<AF_M text="New password needs to be more than 8 characters.">');
	    }
	    
	    if($new_password1 !~ /[0-9]/){
		return('<AF_M text="New password needs to include at least 1 number.">');
	    }
	    
	    if($new_password1 ne $new_password2){
		return('<AF_M text="New passwords does not match each other.">');
	    }

	    my @salts = ( "A".."Z", "a".."z", "0".."9", ".", "/" );
	    my $salt = $salts[int(rand(64))] . $salts[int(rand(64))];
	    my $crypted_password = crypt($new_password1, $salt);

	    require Affelio::misc::InitAffelio;
	    Affelio::misc::InitAffelio::create_login_cfg($af->{site__user_dir} . "/login.cfg",  $af->{site__username}, $crypted_password);

	    return('<AF_M text="Password has been changed!">');
	}


	##############################################
	#Top page
	##############################################
	my $toppage = $wi->PTN_word($cgi->param("toppage"));
	$af->{userpref__toppage_app_installname} = $toppage;
	debug_print("StandAlone::Config::conf: toppage=[$toppage]");

	##############################################
	#Messaging
	##############################################
	my $val = $wi->PTN_word($cgi->param("pref__mesging__emailflg"));
	debug_print("StandAlone::Config::conf: mesging__emailflg=[$val]");
	if($val eq "no"){
	    $af->{userpref__mesging__emailflg} = "no";	    
	}else{
	    $af->{userpref__mesging__emailflg} = "yes";	    
	}

	##############################################
	#Preferred Hosting Service
	##############################################
	$af->{userpref__preferred_hosting_service} =
	    $wi->PTN_URL($cgi->param("pref__hosting_service"));

	##############################################
	#Password for Affelio Remote Operation
	##############################################
	$af->{userpref__password_remoteop}= 
	    $wi->PTN_password($cgi->param("wsse_pass"));

	$af->write_user_prefs();
	debug_print("StandAlone::Config::conf: end.");

	return("");
    }



    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $af= shift;
	my $output_ref = shift;

	debug_print("StandAlone::Config::show start.");

	##############################################
	#Top Page
	##############################################
	my @applications=();
	my $install_name;
	my $app;
	my $core_flag="";
	my $app_flag="";

	$output_ref->{"applications"} = \@applications;
	if($af->{userpref__toppage_app_installname} eq "Affelio"){
	    $core_flag="true";
	}
	###############
	#Core
	###############
	push(@applications, {install_title => "Affelio Core",
			     install_name => "Affelio",
			     selected => $core_flag}    );
	###############
	#Apps
	###############
	while (($install_name, $app) = each(%{$af->getAM->{apps}})){
	    
	    if($af->{userpref__toppage_app_installname} 
	       eq $app->{install_name}){
		$app_flag="true";
	    }else{
		$app_flag="";
	    }

	    push(@applications, {install_title => "(Application) " . 
				     $app->{install_title},
				 install_name => $app->{install_name},
				 selected => $app_flag}
		 );
	}

	##############################################
	#Messaging
	##############################################
	my $name = "pref__mesging_emailflg__" 
	    . $af->{userpref__mesging__emailflg};
	$output_ref->{$name} = "checked";

	##############################################
	#Preferred Hosting Service
	##############################################
	$output_ref->{"pref__hosting_service"} = 
	    $af->{userpref__preferred_hosting_service};

	##############################################
	#Password for Affelio Remote Operation
	##############################################
	$output_ref->{"wsse_pass"}=
	    $af->{userpref__password_remoteop};

	debug_print("StandAlone::Config::show end.");


    }


}
1;
