# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ConfigApps.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::ConfigApps;
{
    use strict;

    use lib("../../../../../extlib/");
    use Error qw(:try);
    use lib("../../../../../lib/");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::WebInput;
    use Affelio::exception::InvalidInputException;

    use Exporter;
    @Affelio::App::Standalone::Admin::ConfigApps::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::ConfigApps::EXPORT = qw (show install_app handler);

    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $af = shift;
	my $out_ref = shift;
	
	my $wi = new Affelio::misc::WebInput();
	
	my $sub_mode = $wi->PTN_mode($cgi->url_param("action"));
	try{
	    if($sub_mode eq "install_app" ){
		install_app($af, $cgi, $out_ref);
	    }

	    if($sub_mode eq "modify_app" ){
		modify_app($af, $cgi, $out_ref);
	    }

	    if($sub_mode eq "delete_app" ){
		delete_app($af, $cgi, $out_ref);
	    }
	}catch Error with{
	    my $e = shift;
	    $out_ref->{err_msg} .= $e . '<BR>';
	};
	
	$out_ref->{tmpl_file}
	= "$af->{site__tmpl_dir}/owner_side/admin_apps_config.tmpl";
	
	show($af,$out_ref);
    }

    #######################################################################
    #install_app
    #######################################################################    
    sub install_app{
	my $af= shift;
	my $cgi = shift;
	my $out_ref = shift;

	debug_print("StandAlone::ConfigApps::install_app: start.");
	my $wi = new Affelio::misc::WebInput;
	my $app_dir = $wi->PTN_word($cgi->param("app_dir"));
	my $app_dir_abs = $wi->PTN_through($cgi->param("app_dir_abs"));
	my $app_region = $wi->PTN_through($cgi->param("app_region"));
	my $install_dir = $wi->PTN_word($cgi->param("install_dir"));
	my $install_title = $cgi->param("install_title");

	debug_print("StandAlone::ConfigApps::install_app: APP_DIR=[$app_dir]");
	debug_print("StandAlone::ConfigApps::install_app: INST_DIR=[$install_dir]");
	debug_print("StandAlone::ConfigApps::install_app: INST_TITLE=[$install_title]");

	if( ($af->{site__username} ne "farmer")
	    && ($app_region =~ /farmer$/ )    ){
	    throw Affelio::exception::InvalidInputException("Access right violation.");
	}

	if(($install_dir eq "")  || ($install_title eq "")){
	    throw Affelio::exception::InvalidInputException("Invalid input value.");
	}

	$af->getAM->install_app($app_dir, $app_dir_abs, $app_region, $install_dir, $install_title);

	$out_ref->{ret_msg} = "$install_dir is installed.";
    }

    #######################################################################
    #modify_app
    #######################################################################    
    sub modify_app{
	my $af= shift;
	my $cgi = shift;
	my $out_ref = shift;

	debug_print("StandAlone::ConfigApps::modify: start.");

	my $wi = new Affelio::misc::WebInput;
	my $install_title = $cgi->param("install_title");
	my $app_id = $wi->PTN_num($cgi->param("app_id"));

	debug_print("StandAlone::ConfigApps::modify: app_id =[$app_id]");
	debug_print("StandAlone::ConfigApps::modify: title  =[$install_title]");

	if(($app_id eq "" ) || ($app_id < 0)){
	    return;
	}else{
	    $af->getAM()->rename_title($app_id, $install_title);

	    $out_ref->{ret_msg} = "Title has changed to $install_title.";
	}
    }

    #######################################################################
    #delete_app
    #######################################################################    
    sub delete_app{
	my $af= shift;
	my $cgi = shift;
	my $out_ref = shift;

	debug_print("StandAlone::ConfigApps::delete: start.");

	my $wi = new Affelio::misc::WebInput;
	my $app_id = $wi->PTN_num($cgi->param("app_id"));
	my $install_name = $wi->PTN_word($cgi->param("install_name"));

	debug_print("StandAlone::ConfigApps::delete: app_id =[$app_id]");

	if(($app_id eq "" ) || ($app_id < 0)){
	    return;
	}else{
	    $af->getAM()->uninstall_app($app_id, $install_name);
	    $out_ref->{ret_msg} = "Application uninstalled.";
	}
    }

    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $af= shift;
	my $output_ref = shift;

	debug_print("StandAlone::ConfigApps::show start.");

	##############################################
	#Top Page
	##############################################
	my @registered_apps=();
	my @unregistered_apps=();
	$output_ref->{"registered_apps"} = \@registered_apps;
	$output_ref->{"unregistered_apps"} = \@unregistered_apps;

	my $modify_URL=
	    "admin.cgi?mode=config_apps&action=modify_app";

	my $delete_URL=
	    "admin.cgi?mode=config_apps&action=delete_app";

	##############################################
	#Registered Applications
	##############################################
	while (my ($tmp_name, $this_app_ref) = each( %{$af->getAM->{apps}} ) ){
	    push(@registered_apps, 
		 {app_id => $this_app_ref->{app_id},
		  install_name => $this_app_ref->{install_name},
		  install_title => $this_app_ref->{install_title},
		  app_name => $this_app_ref->{app_name},
		  app_version => $this_app_ref->{app_version},
		  modify_URL => $modify_URL,
		  delete_URL => $delete_URL
		  } );
	}

	##############################################
	#Unregistered Applications
	##############################################
	$af->getAM->get_unregistered_apps(\@unregistered_apps);
					  
	debug_print("StandAlone::ConfigApps::show end.");
    }


}
1;
