# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: EditProfile.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::EditProfile;
{
    use strict;

    use lib("../../../../../extlib/");
    use Error qw(:try);
    use Fcntl;
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);

    use Exporter;
    @Affelio::App::Standalone::Admin::EditProfile::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::EditProfile::EXPORT = qw (show_profileeditor  show_profile save_profile handler);


    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $af = shift;
	my $out_ref = shift;
	
	my $wi = new Affelio::misc::WebInput();

	$out_ref->{tmpl_file}
	= "$af->{site__tmpl_dir}/owner_side/admin_editprofile.tmpl";
	
	my $sub_mode = $wi->PTN_mode($cgi->url_param("mode2"));
	
	try{
	    if( $sub_mode eq "submit" ){
		save_profile($af,$cgi);
	    }elsif( $sub_mode eq "uploadimage" ){

		my $uploaded_filename 
		    = $wi->PTN_jpg_filename($cgi->param("file"));
		my $fh = $cgi->upload( "file" );
	
		sysopen(OUT, "$af->{site__user_dir}/profile_face.jpg", 
			O_WRONLY|O_TRUNC|O_CREAT, 0755);
		binmode $fh;
		binmode OUT;
		my $buffer="";
		while (read ($fh, $buffer, 16384)){
		    print OUT $buffer;
		}
		close OUT;

		###################################################
		#Prepare resized images
		###################################################
		require Affelio::misc::ImageEditor;
		Affelio::misc::ImageEditor::resize_image("$af->{site__user_dir}/profile_face.jpg", "$af->{site__user_dir}/profile_face_100x100.jpg", 100);
		Affelio::misc::ImageEditor::resize_image("$af->{site__user_dir}/profile_face.jpg", "$af->{site__user_dir}/profile_face_150x150.jpg", 150);
	    }		

	}catch Error with{
	    my $e = shift;
	    $out_ref->{err_msg} .= $e->stacktrace . '<BR>';
	};
	
	show_profileeditor($af, $out_ref);
    }


    #######################################################################
    #set_profile_into_hash__show
    #######################################################################    
    sub set_profile_into_hash__show{
	my $self = shift;
	my $af = $self->{af};
	my $output_data_ref = shift;
	my $viewers_mode = shift;
	debug_print("StandAlone::set_profile_into_hash__show: start mode=[$viewers_mode]");

	foreach my $key (sort keys %$af){
	    #debug_print("StandAlone::set_profile_into_hash: " . $key . "=" . $af->{$key});
	    
	    if($key =~ /user__mode_/){
		my $key2 = $key;
		$key2 =~ s/user__mode_//;
		
		if(  (($af->{$key} eq "na") 
		      && ($viewers_mode eq "self"))
		     ||
		     (($af->{$key} eq "f1") 
		      && (($viewers_mode eq "self") 
			  || ($viewers_mode eq "f1"))
		      )
		     ||
		     (($af->{$key} eq "f2") 
		      && (($viewers_mode eq "self") 
			  || ($viewers_mode eq "f1") 
			  || ($viewers_mode eq "f2")) 
		      )
		     ||
		     ($af->{$key} eq "pb") 
		     ){
		    
		    my $key3 = "flg_$key2";
		    $$output_data_ref{$key3} = "true";
		    debug_print("StandAlone::af($key3) = $$output_data_ref{$key3}");
		}
		
	    }elsif($key =~ /user__/){
		my $key2 = $key;
		$key2 =~ s/user__//;
		$$output_data_ref{$key2} = $af->{$key};
		debug_print("StandAlone::af($key2) = $af->{$key}");
	    }
	} 
    }

    #######################################################################
    #show_profileeditor
    #######################################################################    
    sub show_profileeditor{
	my $af = shift;
	my $output_data_ref = shift;

	my $dummy=$af->getPM;
	
	foreach my $key (sort keys %$af){
	    #debug_print("StandAlone::set_profile_into_hash: " . $key . "=" . $af->{$key});
	    
	    if($key =~ /user__mode_/){
		
	    }elsif($key =~ /user__/){
		my $key2 = $key;
		$key2 =~ s/user__//;
		$$output_data_ref{$key2} = $af->{$key};
		debug_print("StandAlone::af($key2) = $af->{$key}");
	    }
	} 
    }

    #######################################################################
    #save_profile
    #######################################################################
    sub save_profile{
	my $af = shift;
	my $cgi =shift;
	my $err="";
	
	my @param_names = $cgi->param;

	foreach my $param_key (@param_names){
	    if($param_key ne "submit"){
		$af->{"user__$param_key"} 
		= $cgi->param($param_key);
#		= Jcode->new($cgi->param($param_key), 

		debug_print("StandAlone::EditProfile::save_profile: $param_key= " . Jcode::getcode($cgi->param($param_key)) . "\n");
		debug_print("StandAlone::EditProfile::save_profile: $param_key= [". $af->{"user__$param_key"} . "]");

	    }
	} 
	
	#XXX 
	#Sanitize inputs
	
	#XXX
	#Semantics check
	$err .= check_nickname( $af->{user__nickname} );
	#$err .=  ...

	#Save Profile
	$af->getPM->save_profile();

	return($err);
    }


    #########################################################################
    # Misc routines.
    # XXX  : need to be relocated.
    #########################################################################
    sub check_nickname{
	my $input = shift;

	if($input =~ /[^\w]/){
	    return "nickname can be only alphabet characters.";
	}else{
	    return "";
	}
    }

}
1;
