# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: EditSkins.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::EditSkins;
{
    use strict;

    use Fcntl;
    use lib("../../../../../extlib/");
    use Error qw(:try);
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::WebInput;

    use Exporter;
    @Affelio::App::Standalone::Admin::EditSkins::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::EditSkins::EXPORT = qw (show choose_skin backup upload save_css handler);

    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $af = shift;
	my $out_ref = shift;
	
	my $wi = new Affelio::misc::WebInput();

	my $sub_mode = $wi->PTN_mode($cgi->url_param("action"));

	try{
	    if( $sub_mode eq "submitcss" ){
		save_css($af, $cgi);
	    }elsif( $sub_mode eq "chooseskin" ){
		choose_skin($af, $cgi);
	    }elsif( $sub_mode eq "backup"){
		backup($af,$cgi);
	    }elsif( $sub_mode eq "upload"){
		upload($af,$cgi);
	    }
	}catch Error with{
	    my $e = shift;
	    $out_ref->{err_msg} .= $e->stacktrace . '<BR>';
	};

	$out_ref->{tmpl_file}
	    = "$af->{site__tmpl_dir}/owner_side/admin_edit_skins.tmpl";

	show($af, $out_ref);
    }

    #######################################################################
    #choose_skin
    #######################################################################    
    sub choose_skin{
	my $af = shift;
	my $cgi = shift;
	my $wi = new Affelio::misc::WebInput;

	$af->{userpref__skin} = $wi->PTN_word($cgi->param("skin_list"));
	$af->write_user_prefs();

	return;
    }

    #######################################################################
    #save_css
    #######################################################################    
    sub save_css{
	my $af = shift;
	my $cgi = shift;

	sysopen(FILEOUT, "$af->{site__fs_root}/skins/$af->{userpref__skin}/style.css", O_WRONLY|O_TRUNC|O_CREAT, 0755);
	print FILEOUT $cgi->param("style.css");
	close(FILEOUT);
	return;
    }


    #######################################################################
    #upload
    #######################################################################    
    sub upload{
	my $af = shift;
	my $cgi = shift;
	use File::Basename;

	my $wi = new Affelio::misc::WebInput;

	debug_print("StandAlone::EditSkins:upload: start.");
	
	###############################
	#Enabling/disabling upload
	###############################
	my $farm_con;
	if($af->{site__farm_mode} eq "AFE"){
	    $farm_con = $af->get_farm_connecter();
	    if($farm_con){
		if($farm_con->get_val("can_upload_skin") ne "yes"){
		    return();
		}
	    }
	}
	if($af->{site__farm_mode} eq "AFE2"){
	    return();
	}

	my $filename = $cgi->param('uploadingfile');
	my $filetype = $cgi->uploadInfo($filename)->{'Content-Type'};
	my $basename = ""; #basename($filename,"");

	my $buffer="";
	my $filecontent="";
	while(my $bytesread = read($filename, $buffer, 2048)){
	    $filecontent .= $buffer;
	}
	
	my $ostype = $cgi->param('ostype');
	fileparse_set_fstype("$ostype");

	my $euc_filename = Jcode->new($filename)->euc;
	$euc_filename =~ s|\\|/|g;
	debug_print("StandAlone::EditSkins:upload: euc_filename = $euc_filename");

	if($euc_filename =~ /([\w\-]+\.zip)$/){
	    $basename = ($1);
	}
    
	debug_print("StandAlone::EditSkins:upload: ostype   = $ostype");
	debug_print("StandAlone::EditSkins:upload: filetype = $filetype");
	debug_print("StandAlone::EditSkins:upload: filename = $filename");
	debug_print("StandAlone::EditSkins:upload: basename = $basename");

	$ENV{'PATH'} = '/bin:/usr/bin:/usr/local/bin';

	if($filetype =~ /zip/ || $filename =~ /\.[zip|ZIP]$/){
	    debug_print("StandAlone::EditSkins:upload: OK. This is a zip file. ");
	    debug_print("StandAlone::EditSkins:upload: Extracting [$basename]...");

	    open(FILEOUT, "> $af->{site__fs_root}/skins/$basename");
	    binmode(FILEOUT);
	    print(FILEOUT $filecontent);
	    close(FILEOUT);

	    system("cd $af->{site__fs_root}/skins; unzip $basename");
	    system("cd $af->{site__fs_root}/skins; rm -rf  $basename");

	    debug_print("StandAlone::EditSkins:upload: Extracting [$basename]...DONE.");
	}else{
	    debug_print("StandAlone::EditSkins:upload: This is a NOT zip file. [$basename]");
	    debug_print("StandAlone::EditSkins:upload: Putting [$basename]...");

	    open(FILEOUT, "> $af->{site__fs_root}/skins/$af->{userpref__skin}/$basename");
	    binmode(FILEOUT);
	    print(FILEOUT $filecontent);
	    close(FILEOUT);
	}

    }

    #######################################################################
    #backup
    #######################################################################    
    sub backup{
	my $af = shift;
	my $cgi = shift;

	my $wi = new Affelio::misc::WebInput();

	my $skin_name = $wi->PTN_word($cgi->param("selected_skin"));
	my $specified_name = $wi->PTN_word($cgi->param("archive_name"));

	debug_print("StandAlone::EditSkin:backup skin_name = $skin_name");
	debug_print("StandAlone::EditSkin:backup specified_name = $specified_name");

	my $archive_file_name = "";
	my $archive_dir ="";

	$ENV{'PATH'} = '/bin:/usr/bin:/usr/local/bin';

	if($specified_name ne ""){
	    system("cp -rf $af->{site__fs_root}/skins/$skin_name $af->{site__fs_root}/skins/$specified_name");
	    $archive_file_name = $specified_name . ".zip";
	    $archive_dir = $specified_name;
	}else{
	    $archive_file_name = $skin_name . ".zip";
	    $archive_dir = $skin_name;
	}

	system("cd $af->{site__fs_root}/skins/; zip -r $archive_file_name $archive_dir");

	print <<__EOF__;
Content-Type: application/octet-stream
Content-Disposition: attachment; filename=$archive_file_name

__EOF__
#;

        sysopen(FILEIN, "$af->{site__fs_root}/skins/$archive_file_name", O_RDONLY);
	binmode(OUT);
	print while read FILEIN, $_, 1024;
	close FILEIN;
	close OUT;

	system("cd $af->{site__fs_root}/skins/; rm -rf $specified_name");
	system("cd $af->{site__fs_root}/skins/; rm -rf $archive_file_name");
	return;
    }


    #######################################################################
    #show
    #######################################################################    
    sub show{
	
	my $af = shift;
	my $output_ref = shift;

	###############################
	#Skin list
	###############################
	my @skin_list=();
	my $dir;
	my $selected="";
	opendir(DIR, "$af->{site__fs_root}/skins/");
	while (defined($dir = readdir(DIR))) {
	    #print "$dir\n";
	    if(($dir ne '.') && ($dir ne '..') && ($dir ne 'CVS')){

		if($dir eq $af->{userpref__skin}){
		    $selected="true";
		}else{
		    $selected="";
		}

		push(@skin_list, {name      => $dir,
				  selected  => $selected
				  });
	    }
	}
	$output_ref->{"skin_list"} = \@skin_list;

	###############################
	#Enabling/disabling upload
	###############################
	my $farm_con;
	if($af->{site__farm_mode} eq "AFE"){
	    $farm_con = $af->get_farm_connecter();
	    if($farm_con){
		if($farm_con->get_val("can_upload_skin") eq "yes"){
		    $output_ref->{'upload_disabler'} = "";
		}else{
		    $output_ref->{'upload_disabler'} = "disabled";
		}
	    }
	}
	if($af->{site__farm_mode} eq "AFE2"){
	    $output_ref->{'upload_disabler'} = "disabled";
	}

	###############################
	#Selected skin's CSS file
	###############################
	my $css_body="";
	sysopen(IN, 
		"$af->{site__fs_root}/skins/$af->{userpref__skin}/style.css",
		O_RDONLY);
	if(-w "$af->{site__fs_root}/skins/$af->{userpref__skin}/style.css"){
	    $output_ref->{'current_css_mode'} = "";
	}else{
	    $output_ref->{'current_css_mode'} = "readonly";
	}
	if($af->{site__farm_mode} eq "AFE2"){
	    $output_ref->{'current_css_mode'} = "readonly";
	}


	while(<IN>){$css_body .=$_;}
	close(IN);
	$output_ref->{'current_css_body'} = $css_body;

	$output_ref->{'current_skin_name'} = $af->{userpref__skin};


    }

}
1;
