# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: MakeAffelioLink.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::MakeAffelioLink;
{
    use strict;

    use lib("../../../../../extlib/");
    use Error qw(:try);
    use MIME::Base64;

    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Time qw(timestamp2string get_timestamp);
    use Affelio::misc::WebInput;
    use Affelio::SNS::Handshaker_c;
    use Affelio::SNS::Handshaker_tmpDB;
    use Affelio::exception::CommunicationException;

    use Exporter;
    @Affelio::App::Standalone::Admin::MakeAffelioLink::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::MakeAffelioLink::EXPORT = qw (show send_request handler _send_request);

    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $af = shift;
	my $out_ref = shift;
	
	my $wi = new Affelio::misc::WebInput();
	
	my $sub_mode = $wi->PTN_mode($cgi->url_param("action"));
	
	try{
	    if( $sub_mode eq "submit" ){
		send_request($af, $cgi, $out_ref);
	    }
	}catch Error with{
	    my $e = shift;
	    $out_ref->{err_msg} .= $e->stacktrace . '<BR>';
	};
	
	$out_ref->{tmpl_file}
	= "$af->{site__tmpl_dir}/owner_side/admin_makefriend.tmpl";
	
	show($af,$cgi,$out_ref);
    }

    #######################################################################
    #send_request
    #######################################################################    
    sub send_request{
	my $af = shift;
	my $cgi = shift;
	my $output_ref = shift;
    	my $wi = new Affelio::misc::WebInput;

	debug_print("StandAlone::MakeAffelioLink::send: start.");

	my $dest_uri = $wi->PTN_URL($cgi->param("dest_uri"));
	$dest_uri =~ s/\/$//;
	my $my_mesg = $cgi->param("my_mesg");
	my $cur_time = get_timestamp();
	debug_print("StandAlone::MakeAffelioLink::send: $dest_uri");
	debug_print("StandAlone::MakeAffelioLink::send: $my_mesg");

        ###########################################
        # Send HandShake to the URL
        ###########################################
	my $my_DH_pri_key_str="";
	try{
	    $my_DH_pri_key_str
		= send_HandShake(dest_uri =>  $dest_uri, 
				 my_nickname =>  $af->{user__nickname},
				 my_AFID  =>  $af->{site__user_afid},
				 mesg => $my_mesg,
				 timestamp => $cur_time);
	}catch Affelio::exception::NetworkException with{
	    my $E = shift;
	    throw Affelio::exception::CommunicationException($E);
	}catch Affelio::exception::Exception with{
	    my $E = shift;
	    throw Affelio::exception::CommunicationException($E);
	};
	debug_print("StandAlone::MakeAffelioLink::send: send_HandShake returned success.");

        ###########################################
        # Save peer's info into pending_DB
        ###########################################
	my $tmpdb= new Affelio::SNS::Handshaker_tmpDB($af);
	$tmpdb->add_sent_Handshake($cur_time,
				   $dest_uri,
				   "",
				   $cur_time,
				   $my_DH_pri_key_str);
	debug_print("StandAlone::MakeAffelioLink::send: wroteDB $dest_uri=>[$cur_time]\n");

	$output_ref->{ret_msg} = "Affelio Link Request has been sent to<BR><A HREF=\"$dest_uri\">$dest_uri</A>";

	debug_print("StandAlone::MakeAffelioLink::send: end.");
	return;
    }

    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $af= shift;
	my $q=shift;
	my $output_ref = shift;
	my $wi = new Affelio::misc::WebInput;

	debug_print("StandAlone::MakeAffelioLink::show start.");

	my $dest_uri = $wi->PTN_URL($q->url_param("dest_url"));

	$output_ref->{"dest_uri"} = $dest_uri;

	debug_print("StandAlone::MakeAffelioLink::show end.");
    }


    #######################################################################
    #_send_request
    #######################################################################    
    sub _send_request{
	my $af = shift;
	my $dest_uri = shift;

	debug_print("StandAlone::MakeAffelioLink::send: start.");

    	my $wi = new Affelio::misc::WebInput;

	$dest_uri =~ s/\/$//;

	my $cur_time = get_timestamp();
	debug_print("StandAlone::MakeAffelioLink::send: $dest_uri");

        ###########################################
        # Send HandShake to the URL
        ###########################################
	my $my_DH_pri_key_str="";
	try{
	    $my_DH_pri_key_str
		= send_HandShake(dest_uri =>  $dest_uri, 
				 my_nickname =>  $af->{user__nickname},
				 my_AFID  =>  $af->{site__user_afid},
				 mesg => "",
				 timestamp => $cur_time);
	}catch Affelio::exception::NetworkException with{
	    my $E = shift;
	    throw Affelio::exception::CommunicationException($E);
	}catch Affelio::exception::Exception with{
	    my $E = shift;
	    throw Affelio::exception::CommunicationException($E);
	};
	debug_print("StandAlone::MakeAffelioLink::send: send_HandShake returned success.");

        ###########################################
        # Save peer's info into pending_DB
        ###########################################
	my $tmpdb= new Affelio::SNS::Handshaker_tmpDB($af);
	$tmpdb->add_sent_Handshake($cur_time,
				   $dest_uri,
				   "",
				   $cur_time,
				   $my_DH_pri_key_str);
	debug_print("StandAlone::MakeAffelioLink::send: wroteDB $dest_uri=>[$cur_time]\n");

	debug_print("StandAlone::MakeAffelioLink::send: end.");
	return;
    }


}
1;
