# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ManageApplication.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::ManageApplication;
{
    use strict;

    use lib("../../../../../extlib/");
    use Error qw(:try);
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);

    use Exporter;
    @Affelio::App::Standalone::Admin::ManageApplication::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::ManageApplication::EXPORT = qw (manage_top show_app save_permission handler);

    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $af = shift;
	my $out_ref = shift;
	
	my $wi = new Affelio::misc::WebInput();
	
	my $sub_mode = $wi->PTN_mode($cgi->url_param("mode2"));
	
	try{
	    if($sub_mode eq "modify_app"){
		save_permission($af, $cgi, $cgi->url_param("app_name"));
	    }
	}catch Error with{
	    my $e = shift;
	    $out_ref->{err_msg} .= $e->stacktrace . '<BR>';
	};
	
	if( ($sub_mode eq "modify_app")
	    || ($sub_mode eq "show_app") ){

	    $out_ref->{tmpl_file} = "$af->{site__tmpl_dir}/owner_side/admin_accesscontrol_apps_showapp.tmpl";
	    show_app($af, $cgi->url_param("app_name"), $out_ref);

	}else{
	    $out_ref->{tmpl_file} = "$af->{site__tmpl_dir}/owner_side/admin_accesscontrol_apps_top.tmpl";
	    manage_top($af, $out_ref);
	}
    }


    #####################################################################
    #save_permission
    #####################################################################
    sub save_permission{
	my $af = shift;                 #arg(1) AF
	my $q  = shift;                 #arg(2) CGI
	my $app_name = shift;           #arg(3) app_name
	my $am = $af->getAM;

	#######################
	#debug
	#######################
	my @params = $q->param;
	foreach my  $i (@params){
	    debug_print("StandAlone::save_permission: [$i] =". $q->param($i));
	}

	my @type_array = @{$am->{apps}->{$app_name}->{action_types}};
	my $num_action_types = @type_array;
	my %val_hash=();

	#######################
	# Save values for F1, F2, and PB
	#######################
	{
	    my @gids = ("f1", "f2", "pb");
	    my @option_pids = (1,2,3);

	    for(my $i=0; $i<3; $i++){
		%val_hash=();

		my $gid = $gids[$i];
		my $option_pid = $option_pids[$i];
		debug_print("StandAlone::save_permission: For group[$gid]...");

		#Set values
		my $count=0;
		for($count=0; $count < $num_action_types; $count++){

		    my $param_name 
			= "formdata__f__" . $gid . "__" . $type_array[$count];

		    if($q->param($param_name) eq "on"){
			$val_hash{$type_array[$count]} = 1;
		    }else{
			$val_hash{$type_array[$count]} = 0;
		    }
		}
		debug_print("StandAlone::save_permission: group_permission=[%val_hash]");
		$am->update_permission($app_name,
				       $gid,
				       $option_pid, 
				       \%val_hash);
	    }#for
	}#part
    
	#######################
	# Save values for registered groups
	#######################
        {
	    my $groups_SQL = $af->getGM->get_all_group_list();
	    #For each group returned...
	    while( (my ($gid, $group_name, $members, $option_pid) 
		    = $groups_SQL->fetchrow_array)){

		%val_hash=();

		#Set values
		my $count=0;
		for($count=0; $count < $num_action_types; $count++){

		    my $param_name 
			= "formdata__g__" . $gid . "__" . $type_array[$count];

		    if($q->param($param_name) eq "on"){
			$val_hash{$type_array[$count]} = 1;
		    }else{
			$val_hash{$type_array[$count]} = 0;
		    }
		}
		debug_print("StandAlone::save_permission: group_permission=[%val_hash]");
		$am->update_permission($app_name,
				       $gid,
				       $option_pid, 
				       \%val_hash);

	    }#while

	}#part
    }#sub		


    #####################################################################
    #show_app
    #####################################################################
    sub show_app{
	my $af = shift;                 #arg(1) AF
	my $app_name = shift;           #arg(2) app_name
	my $output_ref = shift;         #arg(3) ref of %output_data; 

	debug_print("StandAlone::ManageApp::show_app: start.");

	#######################
	#Prep
	#######################
	my $am = $af->getAM;
	
	$output_ref->{"install_name"} = $app_name;
	$output_ref->{"install_title"} 
	= $am->{apps}->{$app_name}->{install_title};

	my @type_desc_array = 
	    @{$am->{apps}->{$app_name}->{action_types_desc}};
	my @type_array = 
	    @{$am->{apps}->{$app_name}->{action_types}};

	#######################
	#Headers
	#######################
	my @headers=();
	$output_ref->{"headers"} = \@headers;

	my $count=0;
	foreach my $desc (@type_desc_array){
	    debug_print("StandAlone::ManageApp::show_app: header=[$desc]");
	    push(@headers, {header => "$desc"});
	    $count++;
	}
	$output_ref->{"num_action_types"} = $count;

	my @groups=();
	$output_ref->{"groups"} = \@groups;

	#######################
	# F1, F2, and PB
	#######################
	{
	    my @gids = ("f1", "f2", "pb");
	    my @group_names = ($af->{lh}->maketext("_VISITOR_TYPE_F1"),
			       $af->{lh}->maketext("_VISITOR_TYPE_F2"),
			       $af->{lh}->maketext("_VISITOR_TYPE_PB"));
	    my @option_pids = (1,2,3);

	    for(my $i=0; $i<3; $i++){

		my $gid = $gids[$i];
		my $group_name = $group_names[$i];
		my $option_pid = $option_pids[$i];
		debug_print("StandAlone::ManApp::show_app: For group[$gid]...");

		#set group_name
		my %this_group =();
		$this_group{"group_name"} = $group_name;

		#For each group, get the permission list.
		my $g_perm_result = $am->get_permission("f", $gid, $app_name);
		my @g_perm = $g_perm_result->fetchrow_array;
		debug_print("StandAlone::ManApp::show_app: group_permission=[@g_perm]");

		#Set values
		my @data_array=();
		$this_group{data_array} = \@data_array;
		my $count=0;
		my $count2=-3;
		foreach my $val (@g_perm){
		    if($count2 >= 0){ 
			my $chk_name = "formdata__f__" 
			    . $gid . "__" .  $type_array[$count2];

			push(@data_array, {value => $val,
					   checkbox_name => $chk_name});
		    }
		    $count++;
		    $count2++;
		}
		push(@groups, \%this_group);
	    } #while

	}#part

	#######################
	# Registered Groups
	#######################
	my $groups_SQL = $af->getGM->get_all_group_list();

	#For each group returned...
	while( (my ($gid, $group_name, $members, $option_pid) 
		= $groups_SQL->fetchrow_array)){

	    debug_print("StandAlone::ManApp:show_app: For group[$gid]...");
	    if($gid <1){last;}

	    #set group_name
	    my %this_group =();
	    $this_group{"group_name"} = $group_name;

	    #For each group, get the permission list.
	    my $g_perm_result = $am->get_permission("g", "$gid", $app_name);
	    my @g_perm = $g_perm_result->fetchrow_array;
	    debug_print("StandAlone::ManApp:show_app: group_permission=[@g_perm]");

	    if(@g_perm == ()){
		for(my $num=1; 
		    $num <= ($output_ref->{"num_action_types"}+3); $num++){
		    push(@g_perm, 0);
		}
	    }

	    #Set values
	    my @data_array=();
	    $this_group{data_array} = \@data_array;
	    my $count=0; 
	    my $count2=-3;
	    foreach my $val (@g_perm){
		if($count2 >= 0){ 
		    my $chk_name = "formdata__g__" 
			. $gid . "__" .  $type_array[$count2];

		    push(@data_array, {value => $val,
				       checkbox_name => $chk_name});
		}
		$count++;
		$count2++;
	    }

	    push(@groups, \%this_group);
	}#while

    }


    #####################################################################
    #manage_top
    #####################################################################
    sub manage_top{
	my $af = shift;                 #arg(1) AF
	my $output_ref = shift;         #arg(2) ref of %output_data; 

	my $am = $af->getAM;
	my @applications=();

	my $install_name;
	my $app;
	while (($install_name, $app) = each(%{$am->{apps}})){

	    push(@applications, {install_title => $app->{install_title},
				 install_name => $app->{install_name},
				 #
				 editlink_URL  => "$af->{site__user_afid}/admin.cgi?mode=access_control_apps&mode2=show_app&app_name=$app->{install_name}",
				 app_URL  => "$af->{site__user_afid}/apps/$app->{install_name}/$app->{guest_index}",
				 #
				 app_name  => $app->{app_name},
				 app_version  => $app->{app_version}
			     });	    
	}

	$output_ref->{"applications"} = \@applications;
    }


}#package
1;
